/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class MultipartBodyBuilder {
    private final LinkedMultiValueMap<String, DefaultPartBuilder> parts = new LinkedMultiValueMap();

    public MultiValueMap<String, HttpEntity<?>> build() {
        LinkedMultiValueMap result = new LinkedMultiValueMap(this.parts.size());
        for (Map.Entry entry : this.parts.entrySet()) {
            for (DefaultPartBuilder builder : (List)entry.getValue()) {
                HttpEntity<?> entity = builder.build();
                result.add(entry.getKey(), entity);
            }
        }
        return result;
    }

    public PartBuilder part(String name, Object part) {
        return this.part(name, part, null);
    }

    public PartBuilder part(String name, Object part, @Nullable MediaType contentType) {
        Object partBody;
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull((Object)part, (String)"'part' must not be null");
        HttpHeaders partHeaders = new HttpHeaders();
        if (part instanceof HttpEntity) {
            HttpEntity other = (HttpEntity)part;
            partBody = other.getBody();
            partHeaders.addAll(other.getHeaders());
        } else {
            partBody = part;
        }
        if (contentType != null) {
            partHeaders.setContentType(contentType);
        }
        DefaultPartBuilder builder = new DefaultPartBuilder(partBody, partHeaders);
        this.parts.add((Object)name, (Object)builder);
        return builder;
    }

    private static class DefaultPartBuilder
    implements PartBuilder {
        @Nullable
        private final Object body;
        private final HttpHeaders headers;

        public DefaultPartBuilder(@Nullable Object body, HttpHeaders headers) {
            this.body = body;
            this.headers = headers;
        }

        @Override
        public PartBuilder header(String headerName, String ... headerValues) {
            this.headers.addAll(headerName, Arrays.asList(headerValues));
            return this;
        }

        public HttpEntity<?> build() {
            return new HttpEntity<Object>(this.body, this.headers);
        }
    }

    public static interface PartBuilder {
        public PartBuilder header(String var1, String ... var2);
    }
}

