/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.api.dto.RolePrincipals;
import com.xebialabs.deployit.engine.api.security.Permission;
import com.xebialabs.deployit.engine.api.security.Role;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DtoWriter {
    public List<Role> writeRoles(List<com.xebialabs.deployit.security.Role> roles) {
        return roles.stream().map(DtoWriter::writeRole).collect(Collectors.toList());
    }

    private static Role writeRole(com.xebialabs.deployit.security.Role role) {
        return new Role(role.getId(), role.getName());
    }

    public List<RolePrincipals> writeRoleAssignments(List<com.xebialabs.deployit.security.Role> roles) {
        return roles.stream().map(r -> new RolePrincipals(DtoWriter.writeRole(r), r.getPrincipals())).collect(Collectors.toList());
    }

    public List<RolePermissions> writeRolePermissions(Map<com.xebialabs.deployit.security.Role, Set<com.xebialabs.deployit.security.permission.Permission>> multimap) {
        return multimap.keySet().stream().map(role -> new RolePermissions(DtoWriter.writeRole(role), DtoWriter.writePermissions((Collection)multimap.get(role)))).collect(Collectors.toList());
    }

    private static List<String> writePermissions(Collection<com.xebialabs.deployit.security.permission.Permission> permissions) {
        return permissions.stream().map(com.xebialabs.deployit.security.permission.Permission::getPermissionName).collect(Collectors.toList());
    }

    public static List<Permission> writeReferenceDataPermissions(Collection<com.xebialabs.deployit.security.permission.Permission> values) {
        return values.stream().map(p -> new Permission(p.getPermissionName(), p.getLevel().name(), p.getRoot() != null ? p.getRoot().getRootNodeName() : null)).collect(Collectors.toList());
    }
}

