/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.security.PermissionChecker;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class PermissionEnforcer {
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    private PermissionChecker checker;
    private final RoleService roleService;
    private static final Logger logger = LoggerFactory.getLogger(PermissionEnforcer.class);

    @Autowired
    public PermissionEnforcer(PermissionChecker checker, RoleService roleService) {
        this.checker = checker;
        this.roleService = roleService;
    }

    public boolean hasPermission(Authentication authentication, Permission ... permissions) {
        return this.hasPermission(authentication, Arrays.asList(permissions), "");
    }

    public boolean hasLoggedInUserPermission(Permission ... permissions) {
        Authentication authentication = Permissions.getAuthentication();
        return this.hasPermission(authentication, Arrays.asList(permissions), "");
    }

    public boolean hasLoggedInUserPermission(Permission permission, String onConfigurationItem) {
        return this.hasLoggedInUserPermission(Collections.singletonList(permission), onConfigurationItem);
    }

    public boolean hasLoggedInUserPermission(List<Permission> permissions, String onConfigurationItem) {
        return this.hasPermission(Permissions.getAuthentication(), permissions, onConfigurationItem);
    }

    public boolean hasPermission(Authentication auth, List<Permission> permissions, String onConfigurationItem) {
        List allRoles;
        Collection<String> allPrincipals = Permissions.authenticationToPrincipals(auth);
        return this.isAdmin(allPrincipals, allRoles = this.roleService.getRolesFor(auth)) || this.hasPermission(allRoles, permissions, onConfigurationItem);
    }

    public boolean hasPermission(List<Role> roles, List<Permission> permissions, String onConfigurationItem) {
        return this.checker.checkPermission(permissions, onConfigurationItem, roles);
    }

    boolean isAdmin(Collection<String> allPrincipals, List<Role> allRoles, Authentication auth) {
        Boolean isAdmin = allPrincipals.contains(ROLE_ADMIN) || this.checker.checkPermission(Collections.singletonList(PlatformPermissions.ADMIN), "", allRoles, auth);
        logger.trace("Admin privileges [{}] granted to {}", (Object)(isAdmin != false ? "are" : "are not"), allPrincipals);
        return isAdmin;
    }

    public boolean isAdmin(Collection<String> allPrincipals, List<Role> allRoles) {
        return this.isAdmin(allPrincipals, allRoles, Permissions.getAuthentication());
    }

    public boolean isCurrentUserAdmin() {
        return this.isAdmin(Permissions.getAuthentication());
    }

    public boolean isAdmin(Authentication auth) {
        Collection<String> principals = Permissions.authenticationToPrincipals(auth);
        List allRoles = this.roleService.getRolesFor(auth);
        return this.isAdmin(principals, allRoles, auth);
    }
}

