/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.permission;

import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsData;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.PlatformPermissions;

public class ReadPermissionHandler
extends PermissionHandler {
    public ReadPermissionHandler() {
        super(PlatformPermissions.READ);
    }

    @Override
    public boolean hasPermission(String onConfigurationItem) {
        PermissionEnforcer permissionEnforcer = SecurityServiceLocator.getPermissionEnforcer();
        ViewAsData viewAsData = SecurityServiceLocator.getViewAsData();
        if (viewAsData != null) {
            if (viewAsData.getUser() != null) {
                return permissionEnforcer.hasPermission(viewAsData.getUser(), Permission.getReadPermissions(), onConfigurationItem);
            }
            if (viewAsData.getRoles() != null) {
                return permissionEnforcer.hasPermission(viewAsData.getRoles(), Permission.getReadPermissions(), onConfigurationItem);
            }
        }
        return permissionEnforcer.hasLoggedInUserPermission(Permission.getReadPermissions(), onConfigurationItem);
    }
}

