/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.serialization;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.persistence.serialization.Snapshot;
import akka.serialization.BaseSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import akka.util.ByteString$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001%\u0011!c\u00158baNDw\u000e^*fe&\fG.\u001b>fe*\u00111\u0001B\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011a\u00039feNL7\u000f^3oG\u0016T\u0011aB\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0001\u0003\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\t\u0003#Mi\u0011A\u0005\u0006\u0003\u0007\u0019I!\u0001\u0006\n\u0003\u001d\t\u000b7/Z*fe&\fG.\u001b>fe\"Aa\u0003\u0001BC\u0002\u0013\u0005q#\u0001\u0004tsN$X-\\\u000b\u00021A\u0011\u0011\u0004H\u0007\u00025)\u00111DB\u0001\u0006C\u000e$xN]\u0005\u0003;i\u00111#\u0012=uK:$W\rZ!di>\u00148+_:uK6D\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\bgf\u001cH/Z7!\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\u00111%\n\t\u0003I\u0001i\u0011A\u0001\u0005\u0006-\u0001\u0002\r\u0001\u0007\u0005\bO\u0001\u0011\r\u0011\"\u0011)\u0003=Ign\u00197vI\u0016l\u0015M\\5gKN$X#A\u0015\u0011\u0005-Q\u0013BA\u0016\r\u0005\u001d\u0011un\u001c7fC:Da!\f\u0001!\u0002\u0013I\u0013\u0001E5oG2,H-Z'b]&4Wm\u001d;!\u0011!\u0019\u0001\u0001#b\u0001\n\u0013yS#\u0001\u0019\u0011\u0005E\t\u0014B\u0001\u001a\u0013\u00055\u0019VM]5bY&T\u0018\r^5p]\"AA\u0007\u0001EC\u0002\u0013%Q'\u0001\u000bue\u0006t7\u000f]8si&sgm\u001c:nCRLwN\\\u000b\u0002mA\u00191bN\u001d\n\u0005ab!AB(qi&|g\u000e\u0005\u0002;{9\u0011\u0011cO\u0005\u0003yI\tQbU3sS\u0006d\u0017N_1uS>t\u0017B\u0001 @\u0005-IeNZ8s[\u0006$\u0018n\u001c8\u000b\u0005q\u0012\u0002\"B!\u0001\t\u0003\u0011\u0015\u0001\u0003;p\u0005&t\u0017M]=\u0015\u0005\rK\u0005cA\u0006E\r&\u0011Q\t\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0017\u001dK!\u0001\u0013\u0007\u0003\t\tKH/\u001a\u0005\u0006\u0015\u0002\u0003\rAC\u0001\u0002_\")A\n\u0001C\u0001\u001b\u0006QaM]8n\u0005&t\u0017M]=\u0015\u0007)q\u0005\u000bC\u0003P\u0017\u0002\u00071)A\u0003csR,7\u000fC\u0003R\u0017\u0002\u0007!+\u0001\u0005nC:Lg-Z:u!\rYqg\u0015\u0019\u0003)\u0006\u00042!\u0016/`\u001d\t1&\f\u0005\u0002X\u00195\t\u0001L\u0003\u0002Z\u0011\u00051AH]8pizJ!a\u0017\u0007\u0002\rA\u0013X\rZ3g\u0013\tifLA\u0003DY\u0006\u001c8O\u0003\u0002\\\u0019A\u0011\u0001-\u0019\u0007\u0001\t%\u0011\u0007+!A\u0001\u0002\u000b\u00051MA\u0002`IE\n\"\u0001Z4\u0011\u0005-)\u0017B\u00014\r\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u00035\n\u0005%d!aA!os\")1\u000e\u0001C\u0005Y\u0006q\u0001.Z1eKJ$vNQ5oCJLHcA\"n_\")aN\u001ba\u0001\u0015\u0005A1O\\1qg\"|G\u000fC\u0003qU\u0002\u0007\u0011/\u0001\nt]\u0006\u00048\u000f[8u'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bCA\ts\u0013\t\u0019(C\u0001\u0006TKJL\u0017\r\\5{KJDQ!\u001e\u0001\u0005\nY\f\u0001\u0003[3bI\u0016\u0014hI]8n\u0005&t\u0017M]=\u0015\u0007]\f\t\u0001\u0005\u0003\fqjl\u0018BA=\r\u0005\u0019!V\u000f\u001d7feA\u00111b_\u0005\u0003y2\u00111!\u00138u!\t)f0\u0003\u0002\u0000=\n11\u000b\u001e:j]\u001eDQa\u0014;A\u0002\rCq!!\u0002\u0001\t\u0013\t9!\u0001\tt]\u0006\u00048\u000f[8u)>\u0014\u0015N\\1ssR\u00191)!\u0003\t\r9\f\u0019\u00011\u0001\u000b\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001f\t!c\u001d8baNDw\u000e\u001e$s_6\u0014\u0015N\\1ssR\u0019!\"!\u0005\t\r=\u000bY\u00011\u0001D\u0011\u001d\t)\u0002\u0001C\u0005\u0003/\t\u0001b\u001e:ji\u0016Le\u000e\u001e\u000b\u0007\u00033\ty\"a\r\u0011\u0007-\tY\"C\u0002\u0002\u001e1\u0011A!\u00168ji\"A\u0011\u0011EA\n\u0001\u0004\t\u0019#A\u0002pkR\u0004B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0002j_*\u0011\u0011QF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00022\u0005\u001d\"\u0001D(viB,Ho\u0015;sK\u0006l\u0007bBA\u001b\u0003'\u0001\rA_\u0001\u0002S\"9\u0011\u0011\b\u0001\u0005\n\u0005m\u0012a\u0002:fC\u0012Le\u000e\u001e\u000b\u0004u\u0006u\u0002\u0002CA \u0003o\u0001\r!!\u0011\u0002\u0005%t\u0007\u0003BA\u0013\u0003\u0007JA!!\u0012\u0002(\tY\u0011J\u001c9viN#(/Z1n\u0001")
public class SnapshotSerializer
implements BaseSerializer {
    private Serialization serialization;
    private Option<Serialization.Information> transportInformation;
    private final ExtendedActorSystem system;
    private final boolean includeManifest;
    private final int identifier;
    private volatile byte bitmap$0;

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$((BaseSerializer)this);
    }

    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes, clazz);
    }

    public int identifier() {
        return this.identifier;
    }

    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public boolean includeManifest() {
        return this.includeManifest;
    }

    private Serialization serialization$lzycompute() {
        SnapshotSerializer snapshotSerializer = this;
        synchronized (snapshotSerializer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.serialization$lzycompute() : this.serialization;
    }

    private Option<Serialization.Information> transportInformation$lzycompute() {
        SnapshotSerializer snapshotSerializer = this;
        synchronized (snapshotSerializer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Address address = this.system().provider().getDefaultAddress();
                this.transportInformation = address.hasLocalScope() ? None$.MODULE$ : new Some((Object)new Serialization.Information(address, (ActorSystem)this.system()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.transportInformation;
    }

    private Option<Serialization.Information> transportInformation() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.transportInformation$lzycompute() : this.transportInformation;
    }

    public byte[] toBinary(Object o) {
        Object object = o;
        if (!(object instanceof Snapshot)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't serialize object of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{o.getClass()})));
        }
        Snapshot snapshot = (Snapshot)object;
        Object data = snapshot.data();
        byte[] byArray = this.snapshotToBinary(data);
        return byArray;
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return new Snapshot(this.snapshotFromBinary(bytes));
    }

    private byte[] headerToBinary(Object snapshot, Serializer snapshotSerializer) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, snapshotSerializer.identifier());
        Serializer serializer = snapshotSerializer;
        if (serializer instanceof SerializerWithStringManifest) {
            BoxedUnit boxedUnit;
            String manifest;
            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
            String string = manifest = serializerWithStringManifest.manifest(snapshot);
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                out.write(manifest.getBytes(ByteString$.MODULE$.UTF_8()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if (snapshotSerializer.includeManifest()) {
                out.write(snapshot.getClass().getName().getBytes(ByteString$.MODULE$.UTF_8()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        }
        return out.toByteArray();
    }

    private Tuple2<Object, String> headerFromBinary(byte[] bytes) {
        String string;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int serializerId = this.readInt(in);
        if ((serializerId & 0xEDAC) == 60844) {
            throw new NotSerializableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replaying snapshot from akka 2.3.x version is not supported any more"})).s((Seq)Nil$.MODULE$));
        }
        int remaining = in.available();
        if (remaining == 0) {
            string = "";
        } else {
            byte[] manifestBytes = new byte[remaining];
            in.read(manifestBytes);
            string = new String(manifestBytes, ByteString$.MODULE$.UTF_8());
        }
        String manifest = string;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)serializerId), (Object)manifest);
    }

    private byte[] snapshotToBinary(Object snapshot) {
        byte[] byArray;
        Option<Serialization.Information> option = this.transportInformation();
        if (option instanceof Some) {
            Some some = (Some)option;
            Serialization.Information ti = (Serialization.Information)some.value();
            byArray = (byte[])Serialization$.MODULE$.currentTransportInformation().withValue((Object)ti, (Function0 & Serializable & scala.Serializable)() -> this.serialize$1(snapshot));
        } else if (None$.MODULE$.equals(option)) {
            byArray = this.serialize$1(snapshot);
        } else {
            throw new MatchError(option);
        }
        return byArray;
    }

    private Object snapshotFromBinary(byte[] bytes) {
        int headerLength = this.readInt(new ByteArrayInputStream(bytes));
        byte[] headerBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(4, headerLength + 4);
        byte[] snapshotBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).drop(headerLength + 4);
        Tuple2<Object, String> tuple2 = this.headerFromBinary(headerBytes);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int serializerId = tuple2._1$mcI$sp();
        String manifest = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)serializerId), (Object)manifest);
        Tuple2 tuple23 = tuple22;
        int serializerId2 = tuple23._1$mcI$sp();
        String manifest2 = (String)tuple23._2();
        return this.serialization().deserialize(snapshotBytes, serializerId2, manifest2).get();
    }

    private void writeInt(OutputStream out, int i) {
        out.write(i >>> 0);
        out.write(i >>> 8);
        out.write(i >>> 16);
        out.write(i >>> 24);
    }

    private int readInt(InputStream in) {
        int b1 = in.read();
        int b2 = in.read();
        int b3 = in.read();
        int b4 = in.read();
        if ((b1 | b2 | b3 | b3) == -1) {
            throw new EOFException();
        }
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    private final byte[] serialize$1(Object snapshot$1) {
        Serializer snapshotSerializer = this.serialization().findSerializerFor(snapshot$1);
        byte[] headerBytes = this.headerToBinary(snapshot$1, snapshotSerializer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, headerBytes.length);
        out.write(headerBytes);
        out.write(snapshotSerializer.toBinary(snapshot$1));
        return out.toByteArray();
    }

    public SnapshotSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$((Serializer)this);
        BaseSerializer.$init$((BaseSerializer)this);
        this.includeManifest = false;
    }
}

