/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.ConfigurationException;
import akka.dispatch.ThreadPoolConfig$;
import akka.remote.transport.netty.NettyTransportSettings$Tcp$;
import akka.remote.transport.netty.NettyTransportSettings$Udp$;
import akka.remote.transport.netty.SSLSettings;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tUr!B\u0001\u0003\u0011\u0003Y\u0011A\u0006(fiRLHK]1ogB|'\u000f^*fiRLgnZ:\u000b\u0005\r!\u0011!\u00028fiRL(BA\u0003\u0007\u0003%!(/\u00198ta>\u0014HO\u0003\u0002\b\u0011\u00051!/Z7pi\u0016T\u0011!C\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003-9+G\u000f^=Ue\u0006t7\u000f]8siN+G\u000f^5oON\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1BB\u0004\u001b\u001bA\u0005\u0019\u0013E\u000e\u0003\t5{G-Z\n\u00033AI3!G\u000fa\r\u0015qR\u0002#! \u0005\r!6\r]\n\u0006;A\u0001#%\n\t\u0003Cei\u0011!\u0004\t\u0003#\rJ!\u0001\n\n\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011CJ\u0005\u0003OI\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQaF\u000f\u0005\u0002%\"\u0012A\u000b\t\u0003CuAQ\u0001L\u000f\u0005B5\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002]A\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0005Y\u0006twMC\u00014\u0003\u0011Q\u0017M^1\n\u0005U\u0002$AB*ue&tw\rC\u00048;\u0005\u0005I\u0011\t\u001d\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005q\u0003b\u0002\u001e\u001e\u0003\u0003%\taO\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002yA\u0011\u0011#P\u0005\u0003}I\u00111!\u00138u\u0011\u001d\u0001U$!A\u0005\u0002\u0005\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002C\u000bB\u0011\u0011cQ\u0005\u0003\tJ\u00111!\u00118z\u0011\u001d1u(!AA\u0002q\n1\u0001\u001f\u00132\u0011\u001dAU$!A\u0005B%\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0002\u0015B\u00191J\u0014\"\u000e\u00031S!!\u0014\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002P\u0019\nA\u0011\n^3sCR|'\u000fC\u0004R;\u0005\u0005I\u0011\u0001*\u0002\u0011\r\fg.R9vC2$\"a\u0015,\u0011\u0005E!\u0016BA+\u0013\u0005\u001d\u0011un\u001c7fC:DqA\u0012)\u0002\u0002\u0003\u0007!\tC\u0004Y;\u0005\u0005I\u0011I-\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001\u0010\u0005\b7v\t\t\u0011\"\u0003]\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003u\u0003\"a\f0\n\u0005}\u0003$AB(cU\u0016\u001cGOB\u0003b\u001b!\u0005%MA\u0002VIB\u001cR\u0001\u0019\t!E\u0015BQa\u00061\u0005\u0002\u0011$\u0012!\u001a\t\u0003C\u0001DQ\u0001\f1\u0005B5Bqa\u000e1\u0002\u0002\u0013\u0005\u0003\bC\u0004;A\u0006\u0005I\u0011A\u001e\t\u000f\u0001\u0003\u0017\u0011!C\u0001UR\u0011!i\u001b\u0005\b\r&\f\t\u00111\u0001=\u0011\u001dA\u0005-!A\u0005B%Cq!\u00151\u0002\u0002\u0013\u0005a\u000e\u0006\u0002T_\"9a)\\A\u0001\u0002\u0004\u0011\u0005b\u0002-a\u0003\u0003%\t%\u0017\u0005\b7\u0002\f\t\u0011\"\u0003]\u000f\u0015\u0019X\u0002#!+\u0003\r!6\r]\u0004\u0006k6A\t)Z\u0001\u0004+\u0012\u0004h\u0001\u0002\b\u0003\u0001]\u001c\"A\u001e\t\t\u0011e4(\u0011!Q\u0001\ni\faaY8oM&<\u0007cA>\u0002\u00045\tAP\u0003\u0002z{*\u0011ap`\u0001\tif\u0004Xm]1gK*\u0011\u0011\u0011A\u0001\u0004G>l\u0017bAA\u0003y\n11i\u001c8gS\u001eDaa\u0006<\u0005\u0002\u0005%A\u0003BA\u0006\u0003\u001b\u0001\"\u0001\u0004<\t\re\f9\u00011\u0001{\u0011%\t\tB\u001eb\u0001\n\u0003\t\u0019\"A\u0007Ue\u0006t7\u000f]8si6{G-Z\u000b\u0003\u0003+\u00012!a\u0006\u001a\u001d\r\tI\u0002\u0001\b\u0005\u00037\tiC\u0004\u0003\u0002\u001e\u0005-b\u0002BA\u0010\u0003SqA!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003KQ\u0011A\u0002\u001fs_>$h(C\u0001\n\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001\u0002\u0005\t\u0003c1\b\u0015!\u0003\u0002\u0016\u0005qAK]1ogB|'\u000f^'pI\u0016\u0004\u0003\"CA\u001bm\n\u0007I\u0011AA\u001c\u0003%)e.\u00192mKN\u001bH.F\u0001T\u0011\u001d\tYD\u001eQ\u0001\nM\u000b!\"\u00128bE2,7k\u001d7!\u0011%\tyD\u001eb\u0001\n\u0003\t\t%\u0001\u000eT'2+enZ5oKB\u0013xN^5eKJ\u001cE.Y:t\u001d\u0006lW-\u0006\u0002\u0002DA!\u0011QIA'\u001d\u0011\t9%!\u0013\u0011\u0007\u0005\u0005\"#C\u0002\u0002LI\ta\u0001\u0015:fI\u00164\u0017bA\u001b\u0002P)\u0019\u00111\n\n\t\u0011\u0005Mc\u000f)A\u0005\u0003\u0007\n1dU*M\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3s\u00072\f7o\u001d(b[\u0016\u0004\u0003\"CA,m\n\u0007I\u0011AA-\u0003I)6/\u001a#jgB\fGo\u00195fe\u001a{'/S8\u0016\u0005\u0005m\u0003#B\t\u0002^\u0005\r\u0013bAA0%\t1q\n\u001d;j_:D\u0001\"a\u0019wA\u0003%\u00111L\u0001\u0014+N,G)[:qCR\u001c\u0007.\u001a:G_JLu\u000e\t\u0005\t\u0003O2\b\u0015\"\u0003\u0002j\u0005Qq\u000e\u001d;j_:\u001c\u0016N_3\u0015\t\u0005-\u0014Q\u000e\t\u0005#\u0005uC\b\u0003\u0005\u0002p\u0005\u0015\u0004\u0019AA\"\u0003\u0005\u0019\b\"CA:m\n\u0007I\u0011AA;\u0003E\u0019uN\u001c8fGRLwN\u001c+j[\u0016|W\u000f^\u000b\u0003\u0003o\u0002B!!\u001f\u0002\u00046\u0011\u00111\u0010\u0006\u0005\u0003{\ny(\u0001\u0005ekJ\fG/[8o\u0015\r\t\tIE\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAC\u0003w\u0012aBR5oSR,G)\u001e:bi&|g\u000e\u0003\u0005\u0002\nZ\u0004\u000b\u0011BA<\u0003I\u0019uN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\t\u0013\u00055eO1A\u0005\u0002\u0005=\u0015\u0001G,sSR,')\u001e4gKJD\u0015n\u001a5XCR,'/T1sWV\u0011\u00111\u000e\u0005\t\u0003'3\b\u0015!\u0003\u0002l\u0005IrK]5uK\n+hMZ3s\u0011&<\u0007nV1uKJl\u0015M]6!\u0011%\t9J\u001eb\u0001\n\u0003\ty)A\fXe&$XMQ;gM\u0016\u0014Hj\\<XCR,'/T1sW\"A\u00111\u0014<!\u0002\u0013\tY'\u0001\rXe&$XMQ;gM\u0016\u0014Hj\\<XCR,'/T1sW\u0002B\u0011\"a(w\u0005\u0004%\t!a$\u0002\u001dM+g\u000e\u001a\"vM\u001a,'oU5{K\"A\u00111\u0015<!\u0002\u0013\tY'A\bTK:$')\u001e4gKJ\u001c\u0016N_3!\u0011%\t9K\u001eb\u0001\n\u0003\ty)A\tSK\u000e,\u0017N^3Ck\u001a4WM]*ju\u0016D\u0001\"a+wA\u0003%\u00111N\u0001\u0013%\u0016\u001cW-\u001b<f\u0005V4g-\u001a:TSj,\u0007\u0005\u0003\u0005\u00020Z\u0014\r\u0011\"\u0001<\u00031i\u0015\r\u001f$sC6,7+\u001b>f\u0011\u001d\t\u0019L\u001eQ\u0001\nq\nQ\"T1y\rJ\fW.Z*ju\u0016\u0004\u0003\u0002CA\\m\n\u0007I\u0011A\u001e\u0002\u000f\t\u000b7m\u001b7pO\"9\u00111\u0018<!\u0002\u0013a\u0014\u0001\u0003\"bG.dwn\u001a\u0011\t\u0013\u0005}fO1A\u0005\u0002\u0005]\u0012A\u0003+da:{G-\u001a7bs\"9\u00111\u0019<!\u0002\u0013\u0019\u0016a\u0003+da:{G-\u001a7bs\u0002B\u0011\"a2w\u0005\u0004%\t!a\u000e\u0002\u0019Q\u001b\u0007oS3fa\u0006d\u0017N^3\t\u000f\u0005-g\u000f)A\u0005'\u0006iAk\u00199LK\u0016\u0004\u0018\r\\5wK\u0002B\u0011\"a4w\u0005\u0004%\t!a\u000e\u0002\u0019Q\u001b\u0007OU3vg\u0016\fE\r\u001a:\t\u000f\u0005Mg\u000f)A\u0005'\u0006iAk\u00199SKV\u001cX-\u00113ee\u0002B\u0011\"a6w\u0005\u0004%\t!!\u0011\u0002\u0011!{7\u000f\u001e8b[\u0016D\u0001\"a7wA\u0003%\u00111I\u0001\n\u0011>\u001cHO\\1nK\u0002B\u0011\"a8w\u0005\u0004%\t!!\u0011\u0002\u0019\tKg\u000e\u001a%pgRt\u0017-\\3\t\u0011\u0005\rh\u000f)A\u0005\u0003\u0007\nQBQ5oI\"{7\u000f\u001e8b[\u0016\u0004\u0003\u0002CAtm\n\u0007I\u0011A\u001e\u0002\u0019A{'\u000f^*fY\u0016\u001cGo\u001c:)\u0011\u0005\u0015\u00181^Ay\u0003k\u00042!EAw\u0013\r\tyO\u0005\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAAz\u0003M:\u0016I\u0015(J\u001d\u001eS\u0004\u0005\u00165jg\u0002\u001a\bn\\;mI\u0002zg\u000e\\=!E\u0016\u0004So]3eA\tL\b\u0005\u001d:pM\u0016\u001c8/[8oC2\u001ch&\t\u0002\u0002x\u0006\u0019!G\f\u0019\t\u000f\u0005mh\u000f)A\u0005y\u0005i\u0001k\u001c:u'\u0016dWm\u0019;pe\u0002B\u0001\"a@w\u0005\u0004%\taO\u0001\u0011\u0005&tG\rU8siN+G.Z2u_JD\u0003\"!@\u0002l\u0006E(1A\u0011\u0003\u0005\u000b\t1A\r\u00185\u0011\u001d\u0011IA\u001eQ\u0001\nq\n\u0011CQ5oIB{'\u000f^*fY\u0016\u001cGo\u001c:!\u0011%\u0011iA\u001eb\u0001\n\u0003\u0011y!A\u0006Tg2\u001cV\r\u001e;j]\u001e\u001cXC\u0001B\t!\u0015\t\u0012Q\fB\n!\ra!QC\u0005\u0004\u0005/\u0011!aC*T\u0019N+G\u000f^5oOND\u0001Ba\u0007wA\u0003%!\u0011C\u0001\r'Nd7+\u001a;uS:<7\u000f\t\u0005\t\u0005?1(\u0019!C\u0001w\u0005Q2+\u001a:wKJ\u001cvnY6fi^{'o[3s!>|GnU5{K\"9!1\u0005<!\u0002\u0013a\u0014aG*feZ,'oU8dW\u0016$xk\u001c:lKJ\u0004vn\u001c7TSj,\u0007\u0005\u0003\u0005\u0003(Y\u0014\r\u0011\"\u0001<\u0003i\u0019E.[3oiN{7m[3u/>\u00148.\u001a:Q_>d7+\u001b>f\u0011\u001d\u0011YC\u001eQ\u0001\nq\n1d\u00117jK:$8k\\2lKR<vN]6feB{w\u000e\\*ju\u0016\u0004\u0003b\u0002B\u0018m\u0012%!\u0011G\u0001\u000bG>l\u0007/\u001e;f/B\u001bFc\u0001\u001f\u00034!1\u0011P!\fA\u0002i\u0004")
public class NettyTransportSettings {
    private final Config config;
    private final Mode TransportMode;
    private final boolean EnableSsl;
    private final String SSLEngineProviderClassName;
    private final Option<String> UseDispatcherForIo;
    private final FiniteDuration ConnectionTimeout;
    private final Option<Object> WriteBufferHighWaterMark;
    private final Option<Object> WriteBufferLowWaterMark;
    private final Option<Object> SendBufferSize;
    private final Option<Object> ReceiveBufferSize;
    private final int MaxFrameSize;
    private final int Backlog;
    private final boolean TcpNodelay;
    private final boolean TcpKeepalive;
    private final boolean TcpReuseAddr;
    private final String Hostname;
    private final String BindHostname;
    private final int PortSelector;
    private final int BindPortSelector;
    private final Option<SSLSettings> SslSettings;
    private final int ServerSocketWorkerPoolSize;
    private final int ClientSocketWorkerPoolSize;

    public Mode TransportMode() {
        return this.TransportMode;
    }

    public boolean EnableSsl() {
        return this.EnableSsl;
    }

    public String SSLEngineProviderClassName() {
        return this.SSLEngineProviderClassName;
    }

    public Option<String> UseDispatcherForIo() {
        return this.UseDispatcherForIo;
    }

    private Option<Object> optionSize(String s) {
        None$ none$;
        int n = (int)Predef$.MODULE$.Long2long(this.config.getBytes(s));
        switch (n) {
            case 0: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                if (n < 0) {
                    throw new ConfigurationException(new StringBuilder(52).append("Setting '").append(s).append("' must be 0 or positive (and fit in an Int)").toString());
                }
                none$ = new Some((Object)BoxesRunTime.boxToInteger((int)n));
                break;
            }
        }
        return none$;
    }

    public FiniteDuration ConnectionTimeout() {
        return this.ConnectionTimeout;
    }

    public Option<Object> WriteBufferHighWaterMark() {
        return this.WriteBufferHighWaterMark;
    }

    public Option<Object> WriteBufferLowWaterMark() {
        return this.WriteBufferLowWaterMark;
    }

    public Option<Object> SendBufferSize() {
        return this.SendBufferSize;
    }

    public Option<Object> ReceiveBufferSize() {
        return this.ReceiveBufferSize;
    }

    public int MaxFrameSize() {
        return this.MaxFrameSize;
    }

    public int Backlog() {
        return this.Backlog;
    }

    public boolean TcpNodelay() {
        return this.TcpNodelay;
    }

    public boolean TcpKeepalive() {
        return this.TcpKeepalive;
    }

    public boolean TcpReuseAddr() {
        return this.TcpReuseAddr;
    }

    public String Hostname() {
        return this.Hostname;
    }

    public String BindHostname() {
        return this.BindHostname;
    }

    public int PortSelector() {
        return this.PortSelector;
    }

    public int BindPortSelector() {
        return this.BindPortSelector;
    }

    public Option<SSLSettings> SslSettings() {
        return this.SslSettings;
    }

    public int ServerSocketWorkerPoolSize() {
        return this.ServerSocketWorkerPoolSize;
    }

    public int ClientSocketWorkerPoolSize() {
        return this.ClientSocketWorkerPoolSize;
    }

    private int computeWPS(Config config) {
        return ThreadPoolConfig$.MODULE$.scaledPoolSize(config.getInt("pool-size-min"), config.getDouble("pool-size-factor"), config.getInt("pool-size-max"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$EnableSsl$2(NettyTransportSettings $this, boolean x$1) {
        if (!x$1) return true;
        Mode mode = $this.TransportMode();
        NettyTransportSettings$Tcp$ nettyTransportSettings$Tcp$ = NettyTransportSettings$Tcp$.MODULE$;
        if (mode != null) {
            if (!mode.equals(nettyTransportSettings$Tcp$)) return false;
            return true;
        }
        if (nettyTransportSettings$Tcp$ == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$ReceiveBufferSize$2(NettyTransportSettings $this, Option s) {
        if (s.isDefined()) return true;
        Mode mode = $this.TransportMode();
        NettyTransportSettings$Udp$ nettyTransportSettings$Udp$ = NettyTransportSettings$Udp$.MODULE$;
        if (mode == null) {
            if (nettyTransportSettings$Udp$ == null) return false;
            return true;
        } else if (mode.equals(nettyTransportSettings$Udp$)) return false;
        return true;
    }

    public NettyTransportSettings(Config config) {
        Product product;
        this.config = config;
        String string = config.getString("transport-protocol");
        if ("tcp".equals(string)) {
            product = NettyTransportSettings$Tcp$.MODULE$;
        } else if ("udp".equals(string)) {
            product = NettyTransportSettings$Udp$.MODULE$;
        } else {
            throw new ConfigurationException(new StringBuilder(21).append("Unknown transport: [").append(string).append("]").toString());
        }
        this.TransportMode = product;
        this.EnableSsl = BoxesRunTime.unboxToBoolean((Object)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToBoolean((boolean)config.getBoolean("enable-ssl"))), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NettyTransportSettings.$anonfun$EnableSsl$2(this, BoxesRunTime.unboxToBoolean((Object)x$1))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append(this.TransportMode()).append(" does not support SSL").toString()));
        this.SSLEngineProviderClassName = this.EnableSsl() ? config.getString("ssl-engine-provider") : "";
        String string2 = config.getString("use-dispatcher-for-io");
        boolean bl = "".equals(string2) ? true : string2 == null;
        Object object = bl ? None$.MODULE$ : new Some((Object)string2);
        this.UseDispatcherForIo = object;
        this.ConnectionTimeout = Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "connection-timeout");
        this.WriteBufferHighWaterMark = this.optionSize("write-buffer-high-water-mark");
        this.WriteBufferLowWaterMark = this.optionSize("write-buffer-low-water-mark");
        this.SendBufferSize = this.optionSize("send-buffer-size");
        this.ReceiveBufferSize = (Option)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring(this.optionSize("receive-buffer-size")), (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)NettyTransportSettings.$anonfun$ReceiveBufferSize$2(this, s)), (Function0 & Serializable & scala.Serializable)() -> "receive-buffer-size must be specified for UDP");
        this.MaxFrameSize = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)((int)Predef$.MODULE$.Long2long(config.getBytes("maximum-frame-size"))))), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 >= 32000, (Function0 & Serializable & scala.Serializable)() -> "Setting 'maximum-frame-size' must be at least 32000 bytes"));
        this.Backlog = config.getInt("backlog");
        this.TcpNodelay = config.getBoolean("tcp-nodelay");
        this.TcpKeepalive = config.getBoolean("tcp-keepalive");
        String string3 = config.getString("tcp-reuse-addr");
        boolean bl2 = "off-for-windows".equals(string3) ? !Helpers$.MODULE$.isWindows() : config.getBoolean("tcp-reuse-addr");
        this.TcpReuseAddr = bl2;
        String string4 = config.getString("hostname");
        String string5 = "".equals(string4) ? InetAddress.getLocalHost().getHostAddress() : string4;
        this.Hostname = string5;
        String string6 = config.getString("bind-hostname");
        String string7 = "".equals(string6) ? this.Hostname() : string6;
        this.BindHostname = string7;
        this.PortSelector = config.getInt("port");
        String string8 = config.getString("bind-port");
        int n = "".equals(string8) ? this.PortSelector() : new StringOps(Predef$.MODULE$.augmentString(string8)).toInt();
        this.BindPortSelector = n;
        this.SslSettings = this.EnableSsl() ? new Some((Object)new SSLSettings(config.getConfig("security"))) : None$.MODULE$;
        this.ServerSocketWorkerPoolSize = this.computeWPS(config.getConfig("server-socket-worker-pool"));
        this.ClientSocketWorkerPoolSize = this.computeWPS(config.getConfig("client-socket-worker-pool"));
    }

    public static interface Mode {
    }
}

