/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.filters.impl;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.sql.archiving.BaseSelectArchivedBuilder;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.repository.Ids;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Metadata(label="TemplateFilter", versioned=false)
public class TemplateFilter
extends ReportFilter {
    @Property(description="The ID of the template to filter.")
    private String templateId = "";

    public TemplateFilter() {
    }

    public TemplateFilter(String templateId) {
        this.templateId = templateId;
    }

    public void visit(BaseSelectArchivedBuilder<?> builder) {
        if (this.templateId != null) {
            List<String> params = Collections.singletonList(Ids.getName((String)this.templateId));
            builder.withCondition(String.format("%s = ?", ArchivedReleases.REPORT_RELEASES_TABLE_ALIAS() + "." + ArchivedReleases.REPORT_RELEASES_ORIGIN_TEMPLATE_ID()), params);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemplateFilter that = (TemplateFilter)((Object)o);
        return Objects.equals(this.templateId, that.templateId);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.templateId);
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }
}

