/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\r\re\u0001B\u0001\u0003\u00015\u0011AcU9m%\u0016dW-Y:f%\u0016\u0004xn]5u_JL(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\t!B]3q_NLGo\u001c:z\u0015\t9\u0001\"A\u0005yYJ,G.Z1tK*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0007\u00019!\u0002\u0004\t\u0013\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0005\u0013\t9BAA\tSK2,\u0017m]3SKB|7/\u001b;pef\u0004\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\u000bMdg\r\u000e6\u000b\u0003u\t\u0001b\u001a:jujdW\rZ\u0005\u0003?i\u0011q\u0001T8hO&tw\r\u0005\u0002\"E5\t!!\u0003\u0002$\u0005\t1B)Z:fe&\fG.\u001b>bi&|gnU;qa>\u0014H\u000f\u0005\u0002\"K%\u0011aE\u0001\u0002\u001f\u0007>tg-[4ve\u0006$\u0018n\u001c8SK\u001a,'/\u001a8dKN\u001cV\u000f\u001d9peRD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\u0013e\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002+[5\t1F\u0003\u0002-\u0005\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\tq3F\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016\u0004\"A\u000b\u001a\n\u0005MZ#a\u0004+bg.\u0004VM]:jgR,gnY3\t\u0011U\u0002!\u0011!Q\u0001\nY\nQ\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002+o%\u0011\u0001h\u000b\u0002\u0016\t\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2f\u0011!Q\u0004A!A!\u0002\u0013Y\u0014AE2p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016\u0004\"A\u000b\u001f\n\u0005uZ#AE\"p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016D\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001Q\u0001\u000fi\u0016\fWNU3q_NLGo\u001c:z!\t)\u0012)\u0003\u0002C\t\tqA+Z1n%\u0016\u0004xn]5u_JL\b\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\u00027I,G.Z1tK\u0016CH/\u001a8tS>t7OU3q_NLGo\u001c:z!\t)b)\u0003\u0002H\t\tY\"+\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pefD\u0001\"\u0013\u0001\u0003\u0006\u0004%\tAS\u0001\u0019G>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,W#A&\u0011\u0005)b\u0015BA',\u0005a\u0019uN\u001c4jOV\u0014\u0018\r^5p]B+'o]5ti\u0016t7-\u001a\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0017\u0006I2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3!\u0011!\t\u0006A!b\u0001\n\u0003\u0011\u0016!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\t1\u000b\u0005\u0002\")&\u0011QK\u0001\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\t\u0011]\u0003!\u0011!Q\u0001\nM\u000b!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA!A\u0011\f\u0001B\u0001B\u0003%!,\u0001\nue&<w-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007C\u0001\u0016\\\u0013\ta6F\u0001\nUe&<w-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\u0002\u001f\u0019\f7-\u001a;SKB|7/\u001b;pef\u0004\"!\u00061\n\u0005\u0005$!a\u0004$bG\u0016$(+\u001a9pg&$xN]=\t\u0011\r\u0004!Q1A\u0005\u0004\u0011\f!b]9m\t&\fG.Z2u+\u0005)\u0007C\u00014z\u001d\t9gO\u0004\u0002ii:\u0011\u0011N\u001d\b\u0003UFt!a\u001b9\u000f\u00051|W\"A7\u000b\u00059d\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u00111OB\u0001\u0003I\nL!aA;\u000b\u0005M4\u0011BA<y\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003\u0007UL!A_>\u0003\u000f\u0011K\u0017\r\\3di*\u0011q\u000f\u001f\u0005\t{\u0002\u0011\t\u0011)A\u0005K\u0006Y1/\u001d7ES\u0006dWm\u0019;!\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\u00051A(\u001b8jiz\"b#a\u0001\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\"!\u0006\u0002\u0018\u0005e\u00111\u0004\u000b\u0005\u0003\u000b\t9\u0001\u0005\u0002\"\u0001!)1M a\u0002K\")\u0001F a\u0001S!)\u0001G a\u0001c!)QG a\u0001m!)!H a\u0001w!)qH a\u0001\u0001\")AI a\u0001\u000b\")\u0011J a\u0001\u0017\")\u0011K a\u0001'\")\u0011L a\u00015\")aL a\u0001?\"I\u0011q\u0004\u0001A\u0002\u0013%\u0011\u0011E\u0001\u0018a\u0016\u00148/[:uK:\u001cW-\u00138uKJ\u001cW\r\u001d;peN,\"!a\t\u0011\r\u0005\u0015\u0012qFA\u001b\u001d\u0011\t9#a\u000b\u000f\u00071\fI#C\u0001\u0012\u0013\r\ti\u0003E\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t$a\r\u0003\u0007M+\u0017OC\u0002\u0002.A\u0001R!FA\u001c\u0003wI1!!\u000f\u0005\u0005Y\u0001VM]:jgR,gnY3J]R,'oY3qi>\u0014\b\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005c!\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003\u000b\nyDA\u0004SK2,\u0017m]3\t\u0013\u0005%\u0003\u00011A\u0005\n\u0005-\u0013a\u00079feNL7\u000f^3oG\u0016Le\u000e^3sG\u0016\u0004Ho\u001c:t?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0005M\u0003cA\b\u0002P%\u0019\u0011\u0011\u000b\t\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003+\n9%!AA\u0002\u0005\r\u0012a\u0001=%c!A\u0011\u0011\f\u0001!B\u0013\t\u0019#\u0001\rqKJ\u001c\u0018n\u001d;f]\u000e,\u0017J\u001c;fe\u000e,\u0007\u000f^8sg\u0002Bq!!\u0018\u0001\t\u0003\ny&\u0001\u0004fq&\u001cHo\u001d\u000b\u0005\u0003C\n9\u0007E\u0002\u0010\u0003GJ1!!\u001a\u0011\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u001b\u0002\\\u0001\u0007\u00111N\u0001\u0003S\u0012\u0004B!!\u001c\u0002v9!\u0011qNA9!\ta\u0007#C\u0002\u0002tA\ta\u0001\u0015:fI\u00164\u0017\u0002BA<\u0003s\u0012aa\u0015;sS:<'bAA:!!\"\u00111LA?!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAABq\u0006YAO]1og\u0006\u001cG/[8o\u0013\u0011\t9)!!\u0003\u0015%\u001b(+Z1e\u001f:d\u0017\u0010\u000b\u0003\u0002\\\u0005-\u0005\u0003BAG\u00037k!!a$\u000b\t\u0005E\u00151S\u0001\u000bC:tw\u000e^1uS>t'\u0002BAK\u0003/\u000bq!\\3ue&\u001c7OC\u0002\u0002\u001a*\t\u0001bY8eC\"\fG.Z\u0005\u0005\u0003;\u000byIA\u0003US6,G\rC\u0004\u0002\"\u0002!\t%a)\u0002\r\r\u0014X-\u0019;f)\u0019\tY$!*\u0002*\"A\u0011qUAP\u0001\u0004\tY$A\u0004sK2,\u0017m]3\t\u0011\u0005-\u0016q\u0014a\u0001\u0003[\u000bQC]3mK\u0006\u001cXm\u0011:fCRLwN\\*pkJ\u001cW\r\u0005\u0003\u00020\u0006UVBAAY\u0015\u0011\t\u0019,a\u0010\u0002\r\u00154XM\u001c;t\u0013\u0011\t9,!-\u0003+I+G.Z1tK\u000e\u0013X-\u0019;j_:\u001cv.\u001e:dK\"\"\u0011qTAF\u0011\u001d\ti\f\u0001C!\u0003\u007f\u000b\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0007\u0003w\t\t-a1\t\u0011\u0005%\u00141\u0018a\u0001\u0003WB\u0001\"!2\u0002<\u0002\u0007\u0011qY\u0001\bo>\u00148\u000eR5s!\u0011\tI-!5\u000e\u0005\u0005-'bA\u0003\u0002N*\u0019\u0011q\u001a\u0005\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!a5\u0002L\n9qk\u001c:l\t&\u0014\b\u0006BA^\u0003\u0017Cq!!7\u0001\t\u0003\nY.A\bgS:$\u0017\nZ:CsN#\u0018\r^;t)\u0011\ti.a8\u0011\r\u0005\u0015\u0012qFA6\u0011!\t\t/a6A\u0002\u0005\r\u0018\u0001C:uCR,8/Z:\u0011\u000b=\t)/!;\n\u0007\u0005\u001d\bC\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002B!a;\u0002r6\u0011\u0011Q\u001e\u0006\u0005\u0003_\fy$\u0001\u0004ti\u0006$Xo]\u0005\u0005\u0003g\fiOA\u0007SK2,\u0017m]3Ti\u0006$Xo\u001d\u0015\u0005\u0003/\fY\t\u000b\u0003\u0002X\u0006e\b\u0003BA~\u0003\u007fl!!!@\u000b\u0007\u0005E\u0005#\u0003\u0003\u0003\u0002\u0005u(a\u0002<be\u0006\u0014xm\u001d\u0005\b\u0005\u000b\u0001A\u0011\tB\u0004\u0003M1\u0017N\u001c3Cs\u000e\u000bG.\u001a8eCJ$vn[3o)\u0011\tYD!\u0003\t\u0011\t-!1\u0001a\u0001\u0003W\nQbY1mK:$\u0017M\u001d+pW\u0016t\u0007\u0006\u0002B\u0002\u0003\u0017CqA!\u0005\u0001\t\u0003\u0011\u0019\"\u0001\rgS:$\u0017I]2iSZ\f'\r\\3SK2,\u0017m]3JIN$b!!8\u0003\u0016\t%\u0002\u0002\u0003B\f\u0005\u001f\u0001\rA!\u0007\u0002\t\u0011\fG/\u001a\t\u0005\u00057\u0011)#\u0004\u0002\u0003\u001e)!!q\u0004B\u0011\u0003\u0011)H/\u001b7\u000b\u0005\t\r\u0012\u0001\u00026bm\u0006LAAa\n\u0003\u001e\t!A)\u0019;f\u0011!\u0011YCa\u0004A\u0002\t5\u0012\u0001\u00039bO\u0016\u001c\u0016N_3\u0011\u0007=\u0011y#C\u0002\u00032A\u00111!\u00138uQ\u0011\u0011y!! )\t\t=\u00111\u0012\u0005\b\u0005s\u0001A\u0011\tB\u001e\u0003\u0019\u0019X-\u0019:dQR!!Q\bB\"!\u0019\u0011YBa\u0010\u0002<%!!\u0011\tB\u000f\u0005\u0011a\u0015n\u001d;\t\u0011\t\u0015#q\u0007a\u0001\u0005\u000f\nAb]3be\u000eD\u0007+\u0019:b[N\u00042!\u0006B%\u0013\r\u0011Y\u0005\u0002\u0002\u0016%\u0016dW-Y:f'\u0016\f'o\u00195CsB\u000b'/Y7tQ\u0011\u00119$a#\t\u000f\tE\u0003\u0001\"\u0011\u0003T\u00051A-\u001a7fi\u0016$B!!\u0014\u0003V!A\u0011\u0011\u000eB(\u0001\u0004\tY\u0007\u000b\u0003\u0003P\u0005-\u0005b\u0002B.\u0001\u0011%!QL\u0001\u0018I\u0016dW\r^3SK2,\u0017m]3SK\u001a,'/\u001a8dKN$b!!\u0014\u0003`\t\u0005\u0004\u0002CA5\u00053\u0002\r!a\u001b\t\u0011\t\r$\u0011\fa\u0001\u0005[\t!B]3mK\u0006\u001cX-V5e\u0011\u001d\u00119\u0007\u0001C!\u0005S\nQ\u0002Z3mKR,w+\u001b;i+&$GCBA'\u0005W\u0012i\u0007\u0003\u0005\u0002j\t\u0015\u0004\u0019AA6\u0011!\u0011\u0019G!\u001aA\u0002\t5\u0002\u0006\u0002B3\u0003\u0017CqAa\u001d\u0001\t\u0003\u0012)(\u0001\u0003n_Z,GCBA'\u0005o\u0012Y\b\u0003\u0005\u0003z\tE\u0004\u0019AA6\u0003)y'/[4j]\u0006d\u0017\n\u001a\u0005\t\u0005{\u0012\t\b1\u0001\u0002l\u0005)a.Z<JI\"\"!\u0011OAF\u0011\u001d\u0011\u0019\t\u0001C!\u0005\u000b\u000b\u0011bZ3u'R\fG/^:\u0015\t\u0005%(q\u0011\u0005\t\u0003S\u0012\t\t1\u0001\u0002l!\"!\u0011QAF\u0011\u001d\u0011i\t\u0001C!\u0005\u001f\u000b1bZ3u'R\fG/^:fgR!!\u0011\u0013BJ!\u0019\t)#a\f\u0002j\"A!Q\u0013BF\u0001\u0004\ti.A\u0002jINDCAa#\u0002\f\"9!1\u0014\u0001\u0005B\tu\u0015!D4fiJK7o[*d_J,7\u000f\u0006\u0003\u0003 \n\u0005\u0006CBA\u0013\u0003_\u0011i\u0003\u0003\u0005\u0003\u0016\ne\u0005\u0019AAoQ\u0011\u0011I*! )\t\te\u00151\u0012\u0005\b\u0005S\u0003A\u0011\tBV\u00035\u0019X\r\u001e*jg.\u001c6m\u001c:fgRA\u0011Q\nBW\u0005c\u0013)\f\u0003\u0005\u00030\n\u001d\u0006\u0019AA6\u0003%\u0011X\r\\3bg\u0016LE\r\u0003\u0005\u00034\n\u001d\u0006\u0019\u0001B\u0017\u0003\u0015\u00198m\u001c:f\u0011!\u00119La*A\u0002\t5\u0012A\u0003;pi\u0006d7kY8sK\"\"!qUAF\u0011\u001d\u0011i\f\u0001C!\u0005\u007f\u000b!\"[:UK6\u0004H.\u0019;f)\u0011\t\tG!1\t\u0011\t=&1\u0018a\u0001\u0003WBCAa/\u0002~!\"!1XAF\u0011\u001d\u0011I\r\u0001C!\u0005\u0017\f\u0001bZ3u)&$H.\u001a\u000b\u0005\u0003W\u0012i\r\u0003\u0005\u0002j\t\u001d\u0007\u0019AA6Q\u0011\u00119-! )\t\t\u001d\u00171\u0012\u0005\b\u0005+\u0004A\u0011\tBl\u0003\u0019)\b\u000fZ1uKR!\u00111\bBm\u0011!\t9Ka5A\u0002\u0005m\u0002\u0006\u0002Bj\u0003\u0017CqA!6\u0001\t\u0003\u0012y\u000e\u0006\u0004\u0002<\t\u0005(Q\u001d\u0005\t\u0005G\u0014i\u000e1\u0001\u0002<\u0005AqN]5hS:\fG\u000e\u0003\u0005\u0003h\nu\u0007\u0019AA\u001e\u0003\u001d)\b\u000fZ1uK\u0012DCA!8\u0002\f\"9!Q\u001e\u0001\u0005B\t=\u0018a\u0002:fa2\f7-\u001a\u000b\u0007\u0003w\u0011\tPa=\t\u0011\t\r(1\u001ea\u0001\u0003wA\u0001Ba:\u0003l\u0002\u0007\u00111\b\u0015\u0005\u0005W\fY\tC\u0004\u0003z\u0002!IAa?\u0002+U\u0004H-\u0019;f\u0007>lW.\u001a8ug>sG+Y:lgR1\u0011Q\nB\u007f\u0007\u000fA\u0001Ba@\u0003x\u0002\u00071\u0011A\u0001\r_JLw-\u001b8bYR\u000b7o\u001b\t\u0005\u0003{\u0019\u0019!\u0003\u0003\u0004\u0006\u0005}\"\u0001\u0002+bg.D\u0001b!\u0003\u0003x\u0002\u00071\u0011A\u0001\fkB$\u0017\r^3e)\u0006\u001c8\u000eC\u0004\u0004\u000e\u0001!\tea\u0004\u0002\u0015\u001d,G/\u00117m)\u0006<7\u000f\u0006\u0003\u0004\u0012\r]\u0001C\u0002B\u000e\u0007'\tY'\u0003\u0003\u0004\u0016\tu!aA*fi\"A1\u0011DB\u0006\u0001\u0004\u0011i#A\u0006mS6LGOT;nE\u0016\u0014\b\u0006BB\u0006\u0003{BCaa\u0003\u0002\f\"91\u0011\u0005\u0001\u0005\n\r\r\u0012\u0001E5og\u0016\u0014H\u000fR3qK:$WM\\2z)\u0011\u0019)c!\r\u0015\t\u000553q\u0005\u0005\t\u0007S\u0019y\u00021\u0001\u0004,\u0005QA-\u001a9f]\u0012,gnY=\u0011\t\u0005u2QF\u0005\u0005\u0007_\tyD\u0001\u0006EKB,g\u000eZ3oGfD\u0001ba\r\u0004 \u0001\u00071QG\u0001\fO\u0006$X\rV1tWVKG\r\u0005\u0003\u00048\r\u001dc\u0002BB\u001d\u0007\u000brAaa\u000f\u0004D9!1QHB!\u001d\rI7qH\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u00051\u0012\u0011bAA\u0017W%!1\u0011JB&\u0005\u0015\u0019\u0015.V5e\u0015\r\tic\u000b\u0005\b\u0007\u001f\u0002A\u0011BB)\u0003)9W\r\u001e*fY\u0016\f7/\u001a\u000b\u0007\u0003w\u0019\u0019fa\u0019\t\u0011\t=6Q\na\u0001\u0007+\u0002Baa\u0016\u0004^9!1\u0011HB-\u0013\r\u0019YfK\u0001\u0005\u0007&LE-\u0003\u0003\u0004`\r\u0005$\u0001B\"j\u0013\u0012T1aa\u0017,\u0011!\u0019)g!\u0014A\u0002\rU\u0013\u0001C3oi&$\u00180\u00133\t\u000f\r%\u0004\u0001\"\u0003\u0004l\u0005\u00113\r[3dW&\u001bhj\u001c;SK\u001a,'/\u001a8dK\u0012\u0014\u0015\u0010R3qK:$WM\\2jKN$B!!\u0014\u0004n!A1qNB4\u0001\u0004\u0019)&A\fqY\u0006t\u0017\n^3n\u0013\u0012|%/\u0013;t\u0007\"LG\u000e\u001a:f]\"911\u000f\u0001\u0005B\rU\u0014A\b:fO&\u001cH/\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0017J\u001c;fe\u000e,\u0007\u000f^8s)\u0011\tiea\u001e\t\u0011\re4\u0011\u000fa\u0001\u0003k\ta\u0003]3sg&\u001cH/\u001a8dK&sG/\u001a:dKB$xN\u001d\u0015\u0004\u0001\ru\u0004\u0003BA@\u0007\u007fJAa!!\u0002\u0002\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlReleaseRepository
implements ReleaseRepository,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationPersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final TriggerPersistence triggerPersistence;
    private final FacetRepository facetRepository;
    private final SqlBuilder.Dialect sqlDialect;
    private Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public Release findById(String id) {
        return ReleaseRepository.findById$((ReleaseRepository)this, (String)id);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses));
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    private Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    private void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$.MODULE$.RichCiId(id).normalized());
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.persistenceInterceptors().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.onCreate((ConfigurationItem)release);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.insert(release);
        release.getReleaseTriggers().forEach(trigger -> $this.triggerPersistence.insert((ReleaseTrigger)trigger));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$3(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> $this.releaseExtensionsRepository.create(extension));
        this.updateConfigurationRefs(release);
        this.facetRepository.createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala());
        return release;
    }

    @Timed
    public Release findById(String id, WorkDir workDir) {
        return this.getRelease(id, id);
    }

    @Timed
    public Seq<String> findIdsByStatus(Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData)).map((Function1 & Serializable & scala.Serializable)release -> $this.releaseExtensionsRepository.decorate(release)).map((Function1 & Serializable & scala.Serializable)release -> $this.commentPersistence.decorate((Release)release)).orNull(Predef$.MODULE$.$conforms());
    }

    @Timed
    @IsReadOnly
    public Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0))).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)((Object)folderId2.fold((Function1 & Serializable & scala.Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable & scala.Serializable)ancestorId -> base.withAncestor((String)ancestorId)));
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).nonEmpty() ? sqlBuilder.withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> $this.releaseExtensionsRepository.decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> $this.commentPersistence.decorate((Release)release), Seq$.MODULE$.canBuildFrom())).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable & scala.Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence.deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.triggerPersistence.deleteByTemplateId(id);
        this.commentPersistence.deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid));
        this.taskPersistence.deleteTasksByReleaseUid(releaseUid);
        this.teamRepository.deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository.deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.persistenceInterceptors().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.onDelete(id);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$.MODULE$.RichCiId(id).normalized()).orNull(Predef$.MODULE$.$conforms());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public Seq<ReleaseStatus> getStatuses(Seq<String> ids) {
        return ids.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable & scala.Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    @IsReadOnly
    public Seq<Object> getRiskScores(Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$.MODULE$.RichCiId(id).normalized()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(original.getAllTasks()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable & scala.Serializable)task -> {
                SqlReleaseRepository.$anonfun$update$1(this, updated, task);
                return BoxedUnit.UNIT;
            });
            Buffer originalTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(original.getReleaseTriggers()).asScala();
            Buffer updatedTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getReleaseTriggers()).asScala();
            Diff triggerDiff = Diff$.MODULE$.apply((Iterable)originalTriggers, (Iterable)updatedTriggers);
            triggerDiff.newValues().foreach((Function1 & Serializable & scala.Serializable)trigger -> {
                this.triggerPersistence.insert(trigger);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)((TraversableLike)triggerDiff.updatedPairs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$5(x0$1)))).map((Function1 & Serializable & scala.Serializable)x$3 -> (ReleaseTrigger)x$3._2(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)releaseTrigger -> {
                this.triggerPersistence.update(releaseTrigger);
                return BoxedUnit.UNIT;
            });
        }
        this.updateConfigurationRefs(updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            Diff tasksDiff = Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(original.getAllTasks()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getAllTasks()).asScala());
            tasksDiff.newValues().foreach((Function1 & Serializable & scala.Serializable)task -> {
                SqlReleaseRepository.$anonfun$replace$1(this, original, task);
                return BoxedUnit.UNIT;
            });
            tasksDiff.deletedValues().foreach((Function1 & Serializable & scala.Serializable)task -> {
                SqlReleaseRepository.$anonfun$replace$4(this, task);
                return BoxedUnit.UNIT;
            });
            tasksDiff.updatedPairs().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                SqlReleaseRepository.$anonfun$replace$7(this, x0$2);
                return BoxedUnit.UNIT;
            });
            Diff triggerDiff = Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(original.getReleaseTriggers()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getReleaseTriggers()).asScala());
            triggerDiff.newValues().foreach((Function1 & Serializable & scala.Serializable)trigger -> {
                this.triggerPersistence.insert(trigger);
                return BoxedUnit.UNIT;
            });
            triggerDiff.updatedValues().foreach((Function1 & Serializable & scala.Serializable)trigger -> {
                this.triggerPersistence.update(trigger);
                return BoxedUnit.UNIT;
            });
            new Diff(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(original.getExtensions()).asScala()).map((Function1 & Serializable & scala.Serializable)ext -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ext.getId()), ext), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getExtensions()).asScala()).map((Function1 & Serializable & scala.Serializable)ext -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ext.getId()), ext), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).foreachValue((Function1 & Serializable & scala.Serializable)ext -> {
                this.releaseExtensionsRepository.create(ext);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)ext -> {
                this.releaseExtensionsRepository.update(ext);
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable & scala.Serializable)ext -> {
                this.releaseExtensionsRepository.delete(ext.getId());
                return BoxedUnit.UNIT;
            });
            if (Ids.isInRootFolder((String)original.getId())) {
                Diff teamDiff = Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(original.getTeams()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getTeams()).asScala());
                teamDiff.deletedValues().foreach((Function1 & Serializable & scala.Serializable)team -> {
                    this.teamRepository.delete(team.getId());
                    return BoxedUnit.UNIT;
                });
                teamDiff.updatedValues().foreach((Function1 & Serializable & scala.Serializable)teamToUpdate -> $this.teamRepository.update(teamToUpdate));
                teamDiff.newValues().foreach((Function1 & Serializable & scala.Serializable)x$5 -> $this.teamRepository.create(updated.getId(), x$5));
            }
        }
        this.updateConfigurationRefs(updated);
        return updated;
    }

    private void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        Integer taskUid = (Integer)this.taskPersistence.taskUidById(updatedTask.getId()).get();
        Buffer originalComments = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(CiCloneHelper.cloneCis((List)originalTask.getComments())).asScala();
        originalComments.foreach((Function1 & Serializable & scala.Serializable)comment -> {
            comment.setId(Ids.getName((String)comment.getId()));
            return BoxedUnit.UNIT;
        });
        Buffer updatedComments = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(CiCloneHelper.cloneCis((List)updatedTask.getComments())).asScala();
        updatedComments.foreach((Function1 & Serializable & scala.Serializable)comment -> {
            comment.setId(Ids.getName((String)comment.getId()));
            return BoxedUnit.UNIT;
        });
        Diff commentsDiff = Diff$.MODULE$.apply((Iterable)originalComments, (Iterable)updatedComments);
        commentsDiff.newValues().foreach((Function1 & Serializable & scala.Serializable)newComment -> BoxesRunTime.boxToBoolean((boolean)this.commentPersistence.create(taskUid, CommentPersistence$CommentRow$.MODULE$.fromComment(newComment))));
        commentsDiff.updatedPairs().withFilter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$updateCommentsOnTasks$4(x0$3))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$updateCommentsOnTasks$5(this, taskUid, x0$4)));
        commentsDiff.deletedValues().foreach((Function1 & Serializable & scala.Serializable)deletedComment -> BoxesRunTime.boxToInteger((int)this.commentPersistence.delete(taskUid, deletedComment.getId())));
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    private void insertDependency(Integer gateTaskUid, Dependency dependency) {
        this.dependencyPersistence.insertDependencyWithGateTaskUid(gateTaskUid, dependency);
    }

    private Release getRelease(String releaseId, String entityId) {
        Release release = (Release)this.repositoryAdapter().read(releaseId);
        if (release == null) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Repository entity [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityId})), new Object[0]);
        }
        this.releaseExtensionsRepository.decorate(release);
        return this.commentPersistence.decorate(release);
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        Seq externalIncomingDependencies = (Seq)((TraversableLike)this.dependencyPersistence.findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$6 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$6).fullDependencyId(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren).normalized())));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot delete [", "] because it or one of its children is referenced by "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{planItemIdOrItsChildren})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"one or more dependencies: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{externalIncomingDependencies.mkString(", ")})), new Object[0]);
        }
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        PersistenceInterceptor<Release> persistenceInterceptor2 = persistenceInterceptor;
        this.persistenceInterceptors_$eq((Seq<PersistenceInterceptor<Release>>)((Seq)this.persistenceInterceptors().$plus$colon(persistenceInterceptor2, Seq$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ void $anonfun$create$3(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence.insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)$this.commentPersistence.create(taskUid, CommentPersistence$CommentRow$.MODULE$.fromComment(comment))));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence.insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)$this.commentPersistence.create(taskUid, CommentPersistence$CommentRow$.MODULE$.fromComment(c))));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$5(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReleaseTrigger orig = (ReleaseTrigger)tuple2._1();
        ReleaseTrigger up = (ReleaseTrigger)tuple2._2();
        boolean bl = orig.isEnabled() != up.isEnabled();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$replace$1(SqlReleaseRepository $this, Release original$1, Task task) {
        Integer taskUid = $this.taskPersistence.insert(task, Predef$.MODULE$.Integer2int(original$1.getCiUid()));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)$this.commentPersistence.create(taskUid, CommentPersistence$CommentRow$.MODULE$.fromComment(c))));
    }

    public static final /* synthetic */ void $anonfun$replace$4(SqlReleaseRepository $this, Task task) {
        ((IterableLike)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)id -> {
            $this.dependencyPersistence.deleteDependency(id);
            return BoxedUnit.UNIT;
        });
        Integer taskUid = (Integer)$this.taskPersistence.taskUidById(task.getId()).get();
        $this.commentPersistence.deleteAll(taskUid);
        $this.taskPersistence.delete(task);
    }

    public static final /* synthetic */ void $anonfun$replace$7(SqlReleaseRepository $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task oTask = (Task)tuple2._1();
        Task uTask = (Task)tuple2._2();
        $this.taskPersistence.updateProperties(uTask);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(uTask)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.dependencyPersistence.updateDependency(dependency);
            return BoxedUnit.UNIT;
        });
        $this.updateCommentsOnTasks(oTask, uTask);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$updateCommentsOnTasks$4(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Comment oComment = (Comment)tuple2._1();
        Comment uComment = (Comment)tuple2._2();
        String string = oComment.getText();
        String string2 = uComment.getText();
        if (string == null) {
            if (string2 != null) {
                return true;
            }
        } else if (!string.equals(string2)) return true;
        Date date = oComment.getDate();
        Date date2 = uComment.getDate();
        if (date == null) {
            if (date2 == null) return false;
            return true;
        } else if (((Object)date).equals(date2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$updateCommentsOnTasks$5(SqlReleaseRepository $this, Integer taskUid$4, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Comment uComment = (Comment)tuple2._2();
        boolean bl = $this.commentPersistence.update(taskUid$4, uComment.getId(), uComment.getText(), (Option<DateTime>)new Some((Object)new DateTime((Object)uComment.getDate())));
        return bl;
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationPersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, TriggerPersistence triggerPersistence, FacetRepository facetRepository, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.triggerPersistence = triggerPersistence;
        this.facetRepository = facetRepository;
        this.sqlDialect = sqlDialect;
        ReleaseRepository.$init$((ReleaseRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        this.persistenceInterceptors = (Seq)Seq$.MODULE$.empty();
    }
}

