/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.PermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamCreatedEvent;
import com.xebialabs.xlrelease.domain.events.TeamDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TeamUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TeamService {
    public static final String GLOBAL_ROLES_ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/security/global";
    private TeamRepository teamRepository;
    private ReleaseRepository releaseRepository;
    private ArchivingService archivingService;
    private SecuredCis securedCis;
    private XLReleaseEventBus eventBus;
    private CiIdService ciIdService;

    @Autowired
    public TeamService(TeamRepository teamRepository, ReleaseRepository releaseRepository, ArchivingService archivingService, SecuredCis securedCis, XLReleaseEventBus eventBus, CiIdService ciIdService) {
        this.teamRepository = teamRepository;
        this.releaseRepository = releaseRepository;
        this.archivingService = archivingService;
        this.securedCis = securedCis;
        this.eventBus = eventBus;
        this.ciIdService = ciIdService;
    }

    @Timed
    public Team addTeam(Release release, Team team) {
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't add team to release '%s' because it is %s", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Preconditions.checkArgument((!Ids.isInFolder((String)release.getId()) ? 1 : 0) != 0, (String)"Can't add team to release '%s' because it is inside a folder", (Object[])new Object[]{release.getTitle()});
        this.generateIdIfNecessary(release.getId(), team);
        Team addedTeam = this.teamRepository.create(release.getId(), team);
        release.addTeam(addedTeam);
        this.eventBus.publish((XLReleaseEvent)new TeamCreatedEvent(release, addedTeam));
        return addedTeam;
    }

    @Timed
    public Team updateTeam(String teamId, Team newTeam) {
        String releaseId = Ids.releaseIdFrom((String)teamId);
        Release release = this.releaseRepository.findById(releaseId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't update team on release '%s' because it is %s", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Preconditions.checkArgument((!Ids.isInFolder((String)releaseId) ? 1 : 0) != 0, (String)"Can't update team on release '%s' because it is inside a folder", (Object[])new Object[]{release.getTitle()});
        this.decorateWithStoredTeams(release);
        Team team = release.getTeamWithId(teamId);
        if (team.isSystemTeam()) {
            Preconditions.checkArgument((boolean)newTeam.getTeamName().equals(team.getTeamName()), (Object)"Cannot rename a system release");
        }
        release.updateTeam(newTeam);
        this.saveTeamsToPlatform(release);
        this.eventBus.publish((XLReleaseEvent)new TeamUpdatedEvent(release, team, newTeam));
        return team;
    }

    @Timed
    public List<Team> updateTeams(String releaseId, List<Team> updatedTeams) {
        Release release = this.releaseRepository.findById(releaseId);
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't update teams on release '%s' because it is %s", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Preconditions.checkArgument((!Ids.isInFolder((String)releaseId) ? 1 : 0) != 0, (String)"Can't update teams on release '%s' because it is inside a folder", (Object[])new Object[]{release.getTitle()});
        this.decorateWithStoredTeams(release);
        List currentTeams = release.getTeams();
        Map<String, Set<String>> currentPermissions = this.getTeamsPermissions(currentTeams);
        Set updatedTeamIds = updatedTeams.stream().map(BaseConfigurationItem::getId).collect(Collectors.toSet());
        Set currentTeamIds = currentTeams.stream().map(BaseConfigurationItem::getId).collect(Collectors.toSet());
        Set<Team> toDelete = currentTeams.stream().filter(team -> !updatedTeamIds.contains(team.getId())).collect(Collectors.toSet());
        Set<Team> toUpdate = updatedTeams.stream().filter(team -> currentTeamIds.contains(team.getId())).collect(Collectors.toSet());
        Set<Team> toCreate = updatedTeams.stream().filter(team -> !currentTeamIds.contains(team.getId())).collect(Collectors.toSet());
        ArrayList<PermissionsUpdatedEvent> teamEvents = new ArrayList<PermissionsUpdatedEvent>();
        toDelete.forEach(team -> {
            release.deleteTeam(team.getId());
            teamEvents.add((PermissionsUpdatedEvent)new TeamDeletedEvent(release, team));
        });
        toUpdate.forEach(team -> {
            Team currentTeam = release.getTeamWithId(team.getId());
            Team original = CiCloneHelper.cloneCi(currentTeam);
            release.updateTeam(team);
            if (!original.equals(team)) {
                teamEvents.add((PermissionsUpdatedEvent)new TeamUpdatedEvent(release, original, team));
            }
        });
        toCreate.forEach(team -> {
            release.addTeam(team);
            teamEvents.add((PermissionsUpdatedEvent)new TeamCreatedEvent(release, team));
        });
        Map<String, Set<String>> newPermissions = this.getTeamsPermissions(release.getTeams());
        if (!newPermissions.equals(currentPermissions)) {
            teamEvents.add(new PermissionsUpdatedEvent(release.getTeams()));
        }
        this.saveTeamsToPlatform(release);
        teamEvents.forEach(this.eventBus::publish);
        return release.getTeams();
    }

    @Timed
    public void deleteTeam(Release release, String teamId) {
        Preconditions.checkArgument((boolean)release.isUpdatable(), (String)"Can't delete team from release '%s' because it is %s", (Object[])new Object[]{release.getTitle(), release.getStatus()});
        Preconditions.checkArgument((!Ids.isInFolder((String)release.getId()) ? 1 : 0) != 0, (String)"Can't delete team from release '%s' because it is inside a folder", (Object[])new Object[]{release.getTitle()});
        Team team = release.getTeamWithId(teamId);
        release.deleteTeam(teamId);
        this.saveTeamsToPlatform(release);
        this.eventBus.publish((XLReleaseEvent)new TeamDeletedEvent(release, team));
    }

    public List<Team> saveTeamsToPlatform(Release release) {
        return this.saveTeamsToPlatform(release.getId(), release.getTeams());
    }

    public List<Team> saveTeamsToPlatform(String containerId, List<Team> teams) {
        Optional<Team> invalidTeam = teams.stream().filter(team -> !Ids.isNullId((String)team.getId()) && !containerId.equals(Ids.getParentId((String)team.getId()))).findFirst();
        Preconditions.checkArgument((!invalidTeam.isPresent() ? 1 : 0) != 0, (String)"Cannot save team '%s' as it does not belong to '%s'", (Object[])new Object[]{invalidTeam, containerId});
        teams.forEach(team -> this.generateIdIfNecessary(containerId, (Team)team));
        return this.teamRepository.saveTeamsToPlatform(containerId, teams);
    }

    public void deleteTeamsFromPlatform(String containerId) {
        this.teamRepository.deleteTeamsFromPlatform(containerId);
    }

    public Optional<Team> findTeamByName(String containerId, String teamName) {
        return this.findTeamsByNames(containerId, Collections.singletonList(teamName)).findFirst();
    }

    public Stream<Team> findTeamsByNames(String containerId, Collection<String> teamNames) {
        return this.getEffectiveTeams(containerId).stream().filter(team -> teamNames.contains(team.getTeamName()));
    }

    public void decorateWithEffectiveTeams(Release release) {
        release.setTeams(this.getEffectiveTeams(release));
    }

    public List<Team> getEffectiveTeams(Release release) {
        if (release.isArchived()) {
            return release.getTeams();
        }
        return this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId()));
    }

    public List<Team> getEffectiveTeams(String containerId) {
        if (this.isArchivedRelease(containerId)) {
            return this.archivingService.getRelease(containerId).getTeams();
        }
        return this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(containerId));
    }

    public void decorateWithStoredTeams(Release release) {
        release.setTeams(this.getStoredTeams(release));
    }

    public List<Team> getStoredTeams(Release release) {
        if (release.isArchived()) {
            return release.getTeams();
        }
        return this.teamRepository.getTeams(this.securedCis.getSecuredCi(release.getId()));
    }

    public List<Team> getStoredTeams(String containerId) {
        if (this.isArchivedRelease(containerId)) {
            return this.archivingService.getRelease(containerId).getTeams();
        }
        return this.teamRepository.getTeams(this.securedCis.getSecuredCi(containerId));
    }

    private Map<String, Set<String>> getTeamsPermissions(Collection<Team> teams) {
        return teams.stream().collect(Collectors.toMap(Team::getTeamName, team -> new HashSet(team.getPermissions())));
    }

    private boolean isArchivedRelease(String containerId) {
        return Ids.isReleaseId((String)containerId) && !this.releaseRepository.exists(containerId) && this.archivingService.exists(containerId);
    }

    public void generateIdIfNecessary(String containerId, Team team) {
        if (Ids.isNullId((String)team.getId())) {
            team.setId(this.ciIdService.getUniqueId(Type.valueOf(Team.class), containerId));
        }
    }

    public void generateIdIfNecessary(Role role) {
        if (role != null && (Ids.isNullId((String)role.getId()) || "-1".equals(role.getId()))) {
            role.setId(Ids.getName((String)this.ciIdService.getUniqueId("Role", GLOBAL_ROLES_ROOT)));
        }
    }
}

