/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.repository.nexus;

import akka.http.scaladsl.model.Uri;
import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.metadata.Version;
import com.xebialabs.plugin.manager.metadata.Version$;
import com.xebialabs.plugin.manager.metadata.Version$VersionOps$;
import com.xebialabs.plugin.manager.repository.nexus.NexusPluginRepository;
import com.xebialabs.plugin.manager.repository.nexus.NexusPluginRepositoryException;
import com.xebialabs.plugin.manager.repository.nexus.NexusRepositoryConfig;
import com.xebialabs.plugin.manager.repository.storage.PluginMetadataMemoryStorage;
import com.xebialabs.plugin.manager.repository.storage.PluginMetadataStorage;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.codec.digest.DigestUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class NexusPluginRepository$
implements scala.Serializable {
    public static NexusPluginRepository$ MODULE$;
    private final Uri.Path searchPath;
    private final Uri.Path repositoriesPath;
    private final Uri.Path contentPath;
    private final Path cachePath;

    static {
        new NexusPluginRepository$();
    }

    public Uri.Path searchPath() {
        return this.searchPath;
    }

    public Uri.Path repositoriesPath() {
        return this.repositoriesPath;
    }

    public Uri.Path contentPath() {
        return this.contentPath;
    }

    public Path cachePath() {
        return this.cachePath;
    }

    public NexusPluginRepository memCached(String name, NexusRepositoryConfig config) {
        return new NexusPluginRepository(name, config, new PluginMetadataMemoryStorage(name));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Try<Object> verifyContentLength(PluginId.Artifact pluginId, Option<Object> expected, long found) {
        boolean bl = false;
        Some some = null;
        Option<Object> option = expected;
        if (None$.MODULE$.equals(option)) {
            return new Success((Object)BoxesRunTime.boxToLong((long)found));
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            long length = BoxesRunTime.unboxToLong((Object)some.value());
            if (found == length) {
                return new Success((Object)BoxesRunTime.boxToLong((long)found));
            }
        }
        if (!bl) throw new MatchError(option);
        long length = BoxesRunTime.unboxToLong((Object)some.value());
        return new Failure((Throwable)((Object)new NexusPluginRepositoryException.ContentLengthMismatch(pluginId, found, length)));
    }

    public Try<String> verifySHA1(PluginId.Artifact pluginId, byte[] expected, byte[] found) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new String(expected, StandardCharsets.UTF_8)).flatMap((Function1 & Serializable & scala.Serializable)sha1 -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DigestUtils.sha1Hex((byte[])found)).flatMap((Function1 & Serializable & scala.Serializable)digest -> {
            String string = digest;
            String string2 = sha1;
            return (!(string != null ? !string.equals(string2) : string2 != null) ? new Success(digest) : new Failure((Throwable)((Object)new NexusPluginRepositoryException.ChecksumMismatch(pluginId, (String)digest, (String)sha1)))).map((Function1 & Serializable & scala.Serializable)result -> result);
        }));
    }

    public Future<Tuple2<String, Object>> verifyPlugin(PluginId.Artifact pluginId, byte[] sha1, byte[] plugin, Option<Object> length) {
        return Future$.MODULE$.fromTry(this.verifySHA1(pluginId, sha1, plugin).flatMap((Function1 & Serializable & scala.Serializable)digest -> MODULE$.verifyContentLength(pluginId, length, plugin.length).map((Function1 & Serializable & scala.Serializable)length -> NexusPluginRepository$.$anonfun$verifyPlugin$2(digest, BoxesRunTime.unboxToLong((Object)length)))));
    }

    public Option<Version> latestVersion(Version pv, Seq<Version> versions) {
        return ((TraversableLike)((SeqLike)versions.filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)NexusPluginRepository$.MODULE$.isProductVersion(pv, v)))).sortBy((Function1 & Serializable & scala.Serializable)x$20 -> Version$VersionOps$.MODULE$.id$extension(Version$.MODULE$.VersionOps((Version)x$20)), (Ordering)Ordering.String$.MODULE$)).lastOption();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isProductVersion(Version pv, Version v) {
        if (pv.major() != v.major()) return false;
        Option<Object> option = pv.minor();
        Option<Object> option2 = v.minor();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = pv.revision();
        Option<Object> option4 = v.revision();
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    public NexusPluginRepository apply(String name, NexusRepositoryConfig config, PluginMetadataStorage cache) {
        return new NexusPluginRepository(name, config, cache);
    }

    public Option<Tuple3<String, NexusRepositoryConfig, PluginMetadataStorage>> unapply(NexusPluginRepository x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.name(), (Object)x$0.config(), (Object)x$0.cache()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$verifyPlugin$2(String digest$1, long length) {
        return new Tuple2((Object)digest$1, (Object)BoxesRunTime.boxToLong((long)length));
    }

    private NexusPluginRepository$() {
        MODULE$ = this;
        this.searchPath = Uri.Path$.Empty$.MODULE$.$div("lucene").$div("search");
        this.repositoriesPath = Uri.Path$.Empty$.MODULE$.$div("repositories");
        this.contentPath = Uri.Path$.Empty$.MODULE$.$div("content");
        this.cachePath = Paths.get("cache", new String[0]);
    }
}

