/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.artifact;

import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.engine.replacer.PlaceholderScanner;
import com.xebialabs.deployit.engine.replacer.Placeholders;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import com.xebialabs.deployit.service.replacement.PlaceholderScanningFailedException;
import com.xebialabs.deployit.util.DevNull;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xlplatform.artifact.ExternalArtifactDownloader$;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.function.Supplier;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u0017\t\u0001\u0012I\u001d;jM\u0006\u001cG/\u00128sS\u000eDWM\u001d\u0006\u0003\u0007\u0011\t\u0001\"\u0019:uS\u001a\f7\r\u001e\u0006\u0003\u000b\u0019\t!\u0002\u001f7qY\u0006$hm\u001c:n\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aD\u0001b\u0001\u0001\u0003\u0002\u0003\u0006Ia\u0005\t\u0003)yi\u0011!\u0006\u0006\u0003\u0007YQ!a\u0006\r\u0002\u0007U$WN\u0003\u0002\u001a5\u0005\u0019\u0011\r]5\u000b\u0005ma\u0012A\u00029mk\u001eLgN\u0003\u0002\u001e\r\u0005AA-\u001a9m_fLG/\u0003\u0002 +\tA\u0011I\u001d;jM\u0006\u001cG\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003\u001d9xN]6ESJ\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u000f\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002(I\t9qk\u001c:l\t&\u0014\b\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\bF\u0002,[9\u0002\"\u0001\f\u0001\u000e\u0003\tAQa\u0001\u0015A\u0002MAQ!\t\u0015A\u0002\tBQ\u0001\r\u0001\u0005\u0002E\na!\u001a8sS\u000eDG#\u0001\u001a\u0011\u00055\u0019\u0014B\u0001\u001b\u000f\u0005\u0011)f.\u001b;\t\rY\u0002A\u0011\u0001\u00022\u00039)gN]5dQ\u0006\u0013H/\u001b4bGRDQ\u0001\u000f\u0001\u0005\ne\n!\u0003Z8TG\u0006t\u0007\u000b\\1dK\"|G\u000eZ3sgR\u0011!G\u000f\u0005\u0006w]\u0002\r\u0001P\u0001\u000fg>,(oY3BeRLg-Y2u!\t!R(\u0003\u0002?+\tq1k\\;sG\u0016\f%\u000f^5gC\u000e$\b\"\u0002!\u0001\t\u0003\t\u0015aC:fi\u000eCWmY6tk6$\"A\r\"\t\u000b\r{\u0004\u0019\u0001\u001f\u0002\t%$X-\u001c\u0015\u0005\u0001\u0015CU\f\u0005\u0002\u000e\r&\u0011qI\u0004\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017'B\u0012J)b+\u0006C\u0001&R\u001d\tYu\n\u0005\u0002M\u001d5\tQJ\u0003\u0002O\u0015\u00051AH]8pizJ!\u0001\u0015\b\u0002\rA\u0013X\rZ3g\u0013\t\u00116K\u0001\u0004TiJLgn\u001a\u0006\u0003!:I!!\u0016,\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\t9f\"\u0001\u0006eKB\u0014XmY1uK\u0012\fTaI-[7^s!!\u0004.\n\u0005]s\u0011\u0007\u0002\u0012\u000e\u001dq\u0013Qa]2bY\u0006\fTaI%_A~K!a\u0018,\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133c\u0015\u0019\u0013LW1Xc\u0011\u0011SB\u0004/")
public class ArtifactEnricher {
    private final Artifact artifact;
    private final WorkDir workDir;

    public void enrich() {
        this.enrichArtifact();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void enrichArtifact() {
        boolean bl = false;
        SourceArtifact sourceArtifact = null;
        Artifact artifact = this.artifact;
        if (artifact instanceof SourceArtifact) {
            bl = true;
            sourceArtifact = (SourceArtifact)artifact;
            if (!ArtifactFileUtils.hasRealOrResolvedFile((Artifact)sourceArtifact)) {
                BoxedUnit boxedUnit;
                sourceArtifact.setFile((OverthereFile)ExternalArtifactDownloader$.MODULE$.downloadResolvedFile(sourceArtifact, this.workDir));
                this.setChecksum(sourceArtifact);
                if (Placeholders.shouldScanPlaceholders((SourceArtifact)sourceArtifact)) {
                    this.doScanPlaceholders(sourceArtifact);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            }
        }
        if (bl && Placeholders.shouldScanPlaceholders((SourceArtifact)sourceArtifact)) {
            this.doScanPlaceholders(sourceArtifact);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void doScanPlaceholders(SourceArtifact sourceArtifact) {
        try {
            Placeholders.scanPlaceholders((SourceArtifact)sourceArtifact, (PlaceholderScanner)new MustachePlaceholderScanner());
        }
        catch (RuntimeException re) {
            PlaceholderScanningFailedException.throwException((String)sourceArtifact.getId(), (RuntimeException)re);
        }
    }

    public void setChecksum(SourceArtifact item) {
        SourceArtifact sourceArtifact;
        MessageDigest sha1 = JavaCryptoUtils.getSha1();
        SourceArtifact sourceArtifact2 = item;
        if (sourceArtifact2 != null && (sourceArtifact = sourceArtifact2).hasProperty("checksum") && Strings.isBlank((String)((String)sourceArtifact.getProperty("checksum")))) {
            block8: {
                try {
                    BoxedUnit boxedUnit;
                    SourceArtifact sourceArtifact3 = sourceArtifact;
                    if (sourceArtifact3 instanceof FolderArtifact) {
                        FolderArtifact folderArtifact = (FolderArtifact)sourceArtifact3;
                        Exploder.calculateCheckSum((Supplier)new Supplier<InputStream>(null, folderArtifact){
                            private final FolderArtifact x2$1;

                            public InputStream get() {
                                return this.x2$1.getFile().getInputStream();
                            }
                            {
                                this.x2$1 = x2$1;
                            }
                        }, (MessageDigest)sha1);
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        break block8;
                    }
                    DigestInputStream dataInput = new DigestInputStream(sourceArtifact3.getFile().getInputStream(), sha1);
                    try {
                        OverthereUtils.write((InputStream)dataInput, (OutputStream)new DevNull());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)dataInput);
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                }
                catch (IOException e) {
                    throw new RuntimeIOException("Could not calculate checksum for the artifact.", (Throwable)e);
                }
            }
            sourceArtifact.setProperty("checksum", (Object)JavaCryptoUtils.digest((MessageDigest)sha1));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ArtifactEnricher(Artifact artifact, WorkDir workDir) {
        this.artifact = artifact;
        this.workDir = workDir;
    }
}

