/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigSyntax;
import com.xebialabs.deployit.security.SecretKeyHolder;
import com.xebialabs.xlplatform.config.package$;
import com.xebialabs.xlplatform.config.package$ConfigPasswordUtils$;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Marker;
import org.springframework.util.ResourceUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class ConfigLoader$
implements Logging {
    public static ConfigLoader$ MODULE$;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    static {
        new ConfigLoader$();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ConfigLoader$ configLoader$ = this;
        synchronized (configLoader$) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Config loadWithDynamic(String configResource) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configResource})));
        return this.resolveWithDynamic(ConfigFactory.parseResources((String)configResource).withFallback((ConfigMergeable)ConfigFactory.defaultReference()));
    }

    public Config loadSecuredWithDynamic(String configResource, SecretKeyHolder keyHolder) {
        return this.loadSecuredWithDynamic(configResource, keyHolder, (Function1<String, Option<File>>)(Function1 & Serializable & scala.Serializable)resource -> MODULE$.findFirstInClassPath((String)resource));
    }

    public Config loadSecuredWithDynamic(String configResource, SecretKeyHolder keyHolder, Function1<String, Option<File>> findResourceFile) {
        this.replacePlainTextIfNeeded(configResource, keyHolder, findResourceFile);
        return package$ConfigPasswordUtils$.MODULE$.decrypted$extension(package$.MODULE$.ConfigPasswordUtils(this.loadWithDynamic(configResource)), keyHolder);
    }

    private void replacePlainTextIfNeeded(String configResource, SecretKeyHolder keyHolder, Function1<String, Option<File>> findResourceFile) {
        Config config = ConfigFactory.parseResources((String)configResource, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(true));
        if (package$ConfigPasswordUtils$.MODULE$.hasPlainPasswords$extension(package$.MODULE$.ConfigPasswordUtils(config), keyHolder)) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configuration file ", " contains plain text passwords"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configResource})));
            Option option = (Option)findResourceFile.apply((Object)configResource);
            if (option instanceof Some) {
                Some some = (Some)option;
                File file = (File)some.value();
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing secured configuration file to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
                Files.write(file.toPath(), (Iterable<? extends CharSequence>)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{package$ConfigPasswordUtils$.MODULE$.encrypted$extension(package$.MODULE$.ConfigPasswordUtils(config), keyHolder).root().render(ConfigRenderOptions.defaults().setFormatted(true).setJson(false).setOriginComments(false).setComments(true))}))).asJava()), new OpenOption[0]);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configuration file ", " cannot be found in file system. Encryption aborted!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configResource})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    private Config resolveWithDynamic(Config config) {
        Config config2;
        if (config.hasPath("xl.conf-file.location")) {
            String serverConfigLocation = config.getString("xl.conf-file.location");
            File serverConfigFile = ResourceUtils.getFile((String)serverConfigLocation);
            config2 = ConfigFactory.parseFile((File)serverConfigFile, (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.PROPERTIES));
        } else {
            config2 = ConfigFactory.empty();
        }
        Config serverConfig = config2;
        return ConfigFactory.parseResources((String)"dynamic-reference.conf").withFallback((ConfigMergeable)config).withFallback((ConfigMergeable)serverConfig).resolve();
    }

    private Option<File> findFirstInClassPath(String resource) {
        return ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(ClassLoaderUtils$.MODULE$.classLoader().getResources(resource)).asScala()).map((Function1 & Serializable & scala.Serializable)url -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new File(url.toURI())).toOption()).find((Function1 & Serializable & scala.Serializable)maybeFile -> BoxesRunTime.boxToBoolean((boolean)ConfigLoader$.fileExists$1(maybeFile))).flatten(Predef$.MODULE$.$conforms());
    }

    private static final boolean fileExists$1(Option maybeFile) {
        return maybeFile.exists((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.exists()));
    }

    private ConfigLoader$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

