/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.core.data.AbstractDataRecord;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;

public class FileDataRecord
extends AbstractDataRecord {
    private final File file;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileDataRecord(DataIdentifier identifier, File file) {
        super(identifier);
        if (!$assertionsDisabled && !file.isFile()) {
            throw new AssertionError();
        }
        this.file = file;
    }

    public long getLength() {
        return this.file.length();
    }

    public InputStream getStream() throws DataStoreException {
        try {
            return new FileInputStream(this.file);
        }
        catch (IOException e) {
            throw new DataStoreException("Error opening input stream of " + this.file.getAbsolutePath(), e);
        }
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    static {
        $assertionsDisabled = !FileDataRecord.class.desiredAssertionStatus();
    }
}

