/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events.handler;

import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.actors.ReleaseGroupActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutionEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;
import com.xebialabs.xlrelease.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.risk.domain.events.RiskScoreUpdated;
import com.xebialabs.xlrelease.service.ReleaseGroupService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u001b\tA\"+\u001a7fCN,wI]8va\u00163XM\u001c;IC:$G.\u001a:\u000b\u0005\r!\u0011a\u00025b]\u0012dWM\u001d\u0006\u0003\u000b\u0019\ta!\u001a<f]R\u001c(BA\u0004\t\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\n\u0015\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!\u0011!Q\u0001\nY\t\u0001D]3mK\u0006\u001cXm\u0012:pkB\f5\r^8s'\u0016\u0014h/[2f!\t9\"$D\u0001\u0019\u0015\tIb!\u0001\u0004bGR|'o]\u0005\u00037a\u0011\u0001DU3mK\u0006\u001cXm\u0012:pkB\f5\r^8s'\u0016\u0014h/[2f\u0011!i\u0002A!A!\u0002\u0013q\u0012a\u0005:fY\u0016\f7/Z$s_V\u00048+\u001a:wS\u000e,\u0007CA\u0010#\u001b\u0005\u0001#BA\u0011\u0007\u0003\u001d\u0019XM\u001d<jG\u0016L!a\t\u0011\u0003'I+G.Z1tK\u001e\u0013x.\u001e9TKJ4\u0018nY3\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\r9\u0013F\u000b\t\u0003Q\u0001i\u0011A\u0001\u0005\u0006+\u0011\u0002\rA\u0006\u0005\u0006;\u0011\u0002\rA\b\u0015\u0003I1\u0002\"!\f\u001d\u000e\u00039R!a\f\u0019\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u00022e\u00059a-Y2u_JL(BA\u001a5\u0003\u0015\u0011W-\u00198t\u0015\t)d'A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u00059\u0014aA8sO&\u0011\u0011H\f\u0002\n\u0003V$xn^5sK\u0012DQa\u000f\u0001\u0005\u0002q\n!c\u001c8SK2,\u0017m]3Fq\u0016\u001cW\u000f^5p]R\u0011Q\b\u0011\t\u0003\u001fyJ!a\u0010\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0003j\u0002\rAQ\u0001\u0006KZ,g\u000e\u001e\t\u0003\u0007\u001ek\u0011\u0001\u0012\u0006\u0003\u000b\u0015S!A\u0012\u0004\u0002\r\u0011|W.Y5o\u0013\tAEIA\u000bSK2,\u0017m]3Fq\u0016\u001cW\u000f^5p]\u00163XM\u001c;)\u0005iR\u0005CA&M\u001b\u0005!\u0011BA'\u0005\u0005U\u0019\u0016P\\2ie>t\u0017N_3e'V\u00147o\u0019:jE\u0016DQa\u0014\u0001\u0005\u0002A\u000b!c\u001c8SSN\\7kY8sKV\u0003H-\u0019;fIR\u0011Q(\u0015\u0005\u0006\u0003:\u0003\rA\u0015\t\u0003'bk\u0011\u0001\u0016\u0006\u0003\u000bUS!A\u0012,\u000b\u0005]3\u0011\u0001\u0002:jg.L!!\u0017+\u0003!IK7o[*d_J,W\u000b\u001d3bi\u0016$\u0007F\u0001(K\u0011\u0015a\u0006\u0001\"\u0001^\u0003AygNR8mI\u0016\u0014H)\u001a7fi&tw\r\u0006\u0002>=\")ql\u0017a\u0001A\u00061\u0011m\u0019;j_:\u0004\"aQ1\n\u0005\t$%\u0001\u0006$pY\u0012,'\u000fR3mKRLgnZ!di&|g\u000e\u000b\u0002\\\u0015\")Q\r\u0001C\u0005M\u0006ABO]5hO\u0016\u00148\u000b^1ukN\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\u0005u:\u0007\"\u00025e\u0001\u0004I\u0017a\u0002:fY\u0016\f7/\u001a\t\u0003U.l\u0011!R\u0005\u0003Y\u0016\u0013qAU3mK\u0006\u001cX\r\u000b\u0002\u0001]B\u00111j\\\u0005\u0003a\u0012\u0011Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\bF\u0001\u0001s!\t\u0019h/D\u0001u\u0015\t)H'\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016L!a\u001e;\u0003\u0013\r{W\u000e]8oK:$\b")
public class ReleaseGroupEventHandler {
    private final ReleaseGroupActorService releaseGroupActorService;
    private final ReleaseGroupService releaseGroupService;

    @SynchronizedSubscribe
    public void onReleaseExecution(ReleaseExecutionEvent event) {
        this.triggerStatusCalculation(event.release());
    }

    @SynchronizedSubscribe
    public void onRiskScoreUpdated(RiskScoreUpdated event) {
        this.releaseGroupService.findGroupsReferencingRelease(event.releaseId()).foreach((Function1 & Serializable & scala.Serializable)groupId -> {
            this.releaseGroupActorService.updateGroupRisk(groupId);
            return BoxedUnit.UNIT;
        });
    }

    @SynchronizedSubscribe
    public void onFolderDeleting(FolderDeletingAction action) {
        Seq<CiIdWithTitle> groups = this.releaseGroupService.findActiveGroupsReferencingFolder(action.folderId());
        if (groups.nonEmpty()) {
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You cannot delete this folder. The folder or its subfolders contain releases referenced by active groups: "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((SeqLike)((TraversableLike)groups.take(20)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.title(), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\"", "\", \"", "\"")})), new Object[0]);
        }
    }

    private void triggerStatusCalculation(Release release) {
        this.releaseGroupService.findGroupsReferencingRelease(release.getId()).foreach((Function1 & Serializable & scala.Serializable)groupId -> {
            this.releaseGroupActorService.updateGroupStatus(groupId);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public ReleaseGroupEventHandler(ReleaseGroupActorService releaseGroupActorService, ReleaseGroupService releaseGroupService) {
        this.releaseGroupActorService = releaseGroupActorService;
        this.releaseGroupService = releaseGroupService;
    }
}

