/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\r]d\u0001B\u0001\u0003\u00015\u0011AcU9m%\u0016dW-Y:f%\u0016\u0004xn]5u_JL(BA\u0002\u0005\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u0019\t!B]3q_NLGo\u001c:z\u0015\t9\u0001\"A\u0005yYJ,G.Z1tK*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\t\u00019!\u0002D\t\u0016.aA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\u0011I!a\u0006\u0003\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010E\u0002\u001a5qi\u0011AA\u0005\u00037\t\u0011Q#\u00138uKJ\u001cW\r\u001d;fIJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u001eA5\taD\u0003\u0002 \r\u00051Am\\7bS:L!!\t\u0010\u0003\u000fI+G.Z1tKB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0006g24GG\u001b\u0006\u0002O\u0005AqM]5{u2,G-\u0003\u0002*I\t9Aj\\4hS:<\u0007CA\r,\u0013\ta#A\u0001\fEKN,'/[1mSj\fG/[8o'V\u0004\bo\u001c:u!\tIb&\u0003\u00020\u0005\tq2i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cWm]*vaB|'\u000f\u001e\t\u00033EJ!A\r\u0002\u00035M\u000bHNU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011\u0016d\u0007/\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\n!C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dKB\u0011a'O\u0007\u0002o)\u0011\u0001HA\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u0002;o\t\u0011\"+\u001a7fCN,\u0007+\u001a:tSN$XM\\2f\u0011!a\u0004A!b\u0001\n#i\u0014a\u0004;bg.\u0004VM]:jgR,gnY3\u0016\u0003y\u0002\"AN \n\u0005\u0001;$a\u0004+bg.\u0004VM]:jgR,gnY3\t\u0011\t\u0003!\u0011!Q\u0001\ny\n\u0001\u0003^1tWB+'o]5ti\u0016t7-\u001a\u0011\t\u0011\u0011\u0003!Q1A\u0005\u0012\u0015\u000bQ\u0003Z3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-F\u0001G!\t1t)\u0003\u0002Io\t)B)\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002-\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dK\u0002B\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t\"T\u0001\u0013G>lW.\u001a8u!\u0016\u00148/[:uK:\u001cW-F\u0001O!\t1t*\u0003\u0002Qo\t\u00112i\\7nK:$\b+\u001a:tSN$XM\\2f\u0011!\u0011\u0006A!A!\u0002\u0013q\u0015aE2p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016\u0004\u0003\u0002\u0003+\u0001\u0005\u000b\u0007I\u0011C+\u0002\u001dQ,\u0017-\u001c*fa>\u001c\u0018\u000e^8ssV\ta\u000b\u0005\u0002\u0016/&\u0011\u0001\f\u0002\u0002\u000f)\u0016\fWNU3q_NLGo\u001c:z\u0011!Q\u0006A!A!\u0002\u00131\u0016a\u0004;fC6\u0014V\r]8tSR|'/\u001f\u0011\t\u0011q\u0003!Q1A\u0005\u0012u\u000b1D]3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JLX#\u00010\u0011\u0005Uy\u0016B\u00011\u0005\u0005m\u0011V\r\\3bg\u0016,\u0005\u0010^3og&|gn\u001d*fa>\u001c\u0018\u000e^8ss\"A!\r\u0001B\u0001B\u0003%a,\u0001\u000fsK2,\u0017m]3FqR,gn]5p]N\u0014V\r]8tSR|'/\u001f\u0011\t\u0011\u0011\u0004!Q1A\u0005\u0002\u0015\f\u0001dY8oM&<WO]1uS>t\u0007+\u001a:tSN$XM\\2f+\u00051\u0007C\u0001\u001ch\u0013\tAwG\u0001\rD_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016D\u0001B\u001b\u0001\u0003\u0002\u0003\u0006IAZ\u0001\u001aG>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0005\u0003\u0005m\u0001\t\u0015\r\u0011\"\u0001n\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u000b\u0002]B\u0011\u0011d\\\u0005\u0003a\n\u0011AcU9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\b\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011\u00028\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000f\t\u0005\ti\u0002\u0011)\u0019!C\tk\u0006\u0011BO]5hO\u0016\u0014\b+\u001a:tSN$XM\\2f+\u00051\bC\u0001\u001cx\u0013\tAxG\u0001\nUe&<w-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0002\u0003>\u0001\u0005\u0003\u0005\u000b\u0011\u0002<\u0002'Q\u0014\u0018nZ4feB+'o]5ti\u0016t7-\u001a\u0011\t\u0011q\u0004!\u0011!Q\u0001\nu\fqBZ1dKR\u0014V\r]8tSR|'/\u001f\t\u0003+yL!a \u0003\u0003\u001f\u0019\u000b7-\u001a;SKB|7/\u001b;pefD!\"a\u0001\u0001\u0005\u000b\u0007I1AA\u0003\u0003)\u0019\u0018\u000f\u001c#jC2,7\r^\u000b\u0003\u0003\u000f\u0001B!!\u0003\u000209!\u00111BA\u0015\u001d\u0011\ti!!\n\u000f\t\u0005=\u0011\u0011\u0005\b\u0005\u0003#\tyB\u0004\u0003\u0002\u0014\u0005ua\u0002BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005eA\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I1!a\t\u0007\u0003\t!'-C\u0002\u0004\u0003OQ1!a\t\u0007\u0013\u0011\tY#!\f\u0002\u0015M\u000bHNQ;jY\u0012,'OC\u0002\u0004\u0003OIA!!\r\u00024\t9A)[1mK\u000e$(\u0002BA\u0016\u0003[A!\"a\u000e\u0001\u0005\u0003\u0005\u000b\u0011BA\u0004\u0003-\u0019\u0018\u000f\u001c#jC2,7\r\u001e\u0011\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\u00051A(\u001b8jiz\"b#a\u0010\u0002F\u0005\u001d\u0013\u0011JA&\u0003\u001b\ny%!\u0015\u0002T\u0005U\u0013q\u000b\u000b\u0005\u0003\u0003\n\u0019\u0005\u0005\u0002\u001a\u0001!A\u00111AA\u001d\u0001\b\t9\u0001\u0003\u00045\u0003s\u0001\r!\u000e\u0005\u0007y\u0005e\u0002\u0019\u0001 \t\r\u0011\u000bI\u00041\u0001G\u0011\u0019a\u0015\u0011\ba\u0001\u001d\"1A+!\u000fA\u0002YCa\u0001XA\u001d\u0001\u0004q\u0006B\u00023\u0002:\u0001\u0007a\r\u0003\u0004m\u0003s\u0001\rA\u001c\u0005\u0007i\u0006e\u0002\u0019\u0001<\t\rq\fI\u00041\u0001~\u0011\u001d\tY\u0006\u0001C!\u0003;\na!\u001a=jgR\u001cH\u0003BA0\u0003K\u00022aDA1\u0013\r\t\u0019\u0007\u0005\u0002\b\u0005>|G.Z1o\u0011!\t9'!\u0017A\u0002\u0005%\u0014AA5e!\u0011\tY'a\u001d\u000f\t\u00055\u0014q\u000e\t\u0004\u0003+\u0001\u0012bAA9!\u00051\u0001K]3eK\u001aLA!!\u001e\u0002x\t11\u000b\u001e:j]\u001eT1!!\u001d\u0011Q\u0011\tI&a\u001f\u0011\t\u0005u\u00141Q\u0007\u0003\u0003\u007fRA!!!\u0002.\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\t))a \u0003\u0015%\u001b(+Z1e\u001f:d\u0017\u0010\u000b\u0003\u0002Z\u0005%\u0005\u0003BAF\u00033k!!!$\u000b\t\u0005=\u0015\u0011S\u0001\u000bC:tw\u000e^1uS>t'\u0002BAJ\u0003+\u000bq!\\3ue&\u001c7OC\u0002\u0002\u0018*\t\u0001bY8eC\"\fG.Z\u0005\u0005\u00037\u000biIA\u0003US6,G\rC\u0004\u0002 \u0002!\t%!)\u0002\r\r\u0014X-\u0019;f)\u0015a\u00121UAT\u0011\u001d\t)+!(A\u0002q\tqA]3mK\u0006\u001cX\r\u0003\u0005\u0002*\u0006u\u0005\u0019AAV\u0003U\u0011X\r\\3bg\u0016\u001c%/Z1uS>t7k\\;sG\u0016\u0004B!!,\u000246\u0011\u0011q\u0016\u0006\u0004\u0003cs\u0012AB3wK:$8/\u0003\u0003\u00026\u0006=&!\u0006*fY\u0016\f7/Z\"sK\u0006$\u0018n\u001c8T_V\u00148-\u001a\u0015\u0005\u0003;\u000bI\tC\u0004\u0002<\u0002!\t%!0\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$R\u0001HA`\u0003\u0003D\u0001\"a\u001a\u0002:\u0002\u0007\u0011\u0011\u000e\u0005\t\u0003\u0007\fI\f1\u0001\u0002F\u00069qo\u001c:l\t&\u0014\b\u0003BAd\u0003\u001fl!!!3\u000b\u0007\u0015\tYMC\u0002\u0002N\"\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003#\fIMA\u0004X_J\\G)\u001b:)\t\u0005e\u0016\u0011\u0012\u0005\b\u0003/\u0004A\u0011IAm\u0003=1\u0017N\u001c3JIN\u0014\u0015p\u0015;biV\u001cH\u0003BAn\u0003[\u0004b!!8\u0002h\u0006%d\u0002BAp\u0003GtA!!\u0006\u0002b&\t\u0011#C\u0002\u0002fB\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002j\u0006-(aA*fc*\u0019\u0011Q\u001d\t\t\u0011\u0005=\u0018Q\u001ba\u0001\u0003c\f\u0001b\u001d;biV\u001cXm\u001d\t\u0006\u001f\u0005M\u0018q_\u0005\u0004\u0003k\u0004\"A\u0003\u001fsKB,\u0017\r^3e}A!\u0011\u0011`A\u0000\u001b\t\tYPC\u0002\u0002~z\taa\u001d;biV\u001c\u0018\u0002\u0002B\u0001\u0003w\u0014QBU3mK\u0006\u001cXm\u0015;biV\u001c\b\u0006BAk\u0003\u0013CC!!6\u0003\bA!!\u0011\u0002B\u0007\u001b\t\u0011YAC\u0002\u0002\u0010BIAAa\u0004\u0003\f\t9a/\u0019:be\u001e\u001c\bb\u0002B\n\u0001\u0011\u0005#QC\u0001\u0014M&tGMQ=DC2,g\u000eZ1s)>\\WM\u001c\u000b\u00049\t]\u0001\u0002\u0003B\r\u0005#\u0001\r!!\u001b\u0002\u001b\r\fG.\u001a8eCJ$vn[3oQ\u0011\u0011\t\"!#\t\u000f\t}\u0001\u0001\"\u0001\u0003\"\u0005Ab-\u001b8e\u0003J\u001c\u0007.\u001b<bE2,'+\u001a7fCN,\u0017\nZ:\u0015\r\u0005m'1\u0005B\u001c\u0011!\u0011)C!\bA\u0002\t\u001d\u0012\u0001\u00023bi\u0016\u0004BA!\u000b\u000345\u0011!1\u0006\u0006\u0005\u0005[\u0011y#\u0001\u0003vi&d'B\u0001B\u0019\u0003\u0011Q\u0017M^1\n\t\tU\"1\u0006\u0002\u0005\t\u0006$X\r\u0003\u0005\u0003:\tu\u0001\u0019\u0001B\u001e\u0003!\u0001\u0018mZ3TSj,\u0007cA\b\u0003>%\u0019!q\b\t\u0003\u0007%sG\u000f\u000b\u0003\u0003\u001e\u0005m\u0004\u0006\u0002B\u000f\u0003\u0013CqAa\u0012\u0001\t\u0003\u0012I%\u0001\btKR\u0004&/Z!sG\"Lg/\u001a3\u0015\r\t-#\u0011\u000bB+!\ry!QJ\u0005\u0004\u0005\u001f\u0002\"\u0001B+oSRD\u0001Ba\u0015\u0003F\u0001\u0007\u0011\u0011N\u0001\ne\u0016dW-Y:f\u0013\u0012D\u0001Ba\u0016\u0003F\u0001\u0007\u0011qL\u0001\faJ,\u0017I]2iSZ,G\r\u000b\u0003\u0003F\u0005%\u0005b\u0002B/\u0001\u0011\u0005!qL\u0001\u001aM&tG\r\u0015:f\u0003J\u001c\u0007.\u001b<bE2,'+\u001a7fCN,7\u000f\u0006\u0004\u0003b\t\r$q\r\t\u0006\u0003;\f9\u000f\b\u0005\t\u0005K\u0012Y\u00061\u0001\u0003<\u0005!\u0001/Y4f\u0011!\u0011IDa\u0017A\u0002\tm\u0002\u0006\u0002B.\u0003wBCAa\u0017\u0002\n\"9!q\u000e\u0001\u0005B\tE\u0014AB:fCJ\u001c\u0007\u000e\u0006\u0003\u0003t\te\u0004#\u0002B\u0015\u0005kb\u0012\u0002\u0002B<\u0005W\u0011A\u0001T5ti\"A!1\u0010B7\u0001\u0004\u0011i(\u0001\u0007tK\u0006\u00148\r\u001b)be\u0006l7\u000fE\u0002\u0016\u0005\u007fJ1A!!\u0005\u0005U\u0011V\r\\3bg\u0016\u001cV-\u0019:dQ\nK\b+\u0019:b[NDCA!\u001c\u0002\n\"9!q\u0011\u0001\u0005B\t%\u0015A\u00023fY\u0016$X\r\u0006\u0003\u0003L\t-\u0005\u0002CA4\u0005\u000b\u0003\r!!\u001b)\t\t\u0015\u0015\u0011\u0012\u0005\b\u0005#\u0003A\u0011\u0002BJ\u0003]!W\r\\3uKJ+G.Z1tKJ+g-\u001a:f]\u000e,7\u000f\u0006\u0004\u0003L\tU%q\u0013\u0005\t\u0003O\u0012y\t1\u0001\u0002j!A!\u0011\u0014BH\u0001\u0004\u0011Y$\u0001\u0006sK2,\u0017m]3VS\u0012DqA!(\u0001\t\u0003\u0012y*A\u0007eK2,G/Z,ji\",\u0016\u000e\u001a\u000b\u0007\u0005\u0017\u0012\tKa)\t\u0011\u0005\u001d$1\u0014a\u0001\u0003SB\u0001B!'\u0003\u001c\u0002\u0007!1\b\u0015\u0005\u00057\u000bI\tC\u0004\u0003*\u0002!\tEa+\u0002\t5|g/\u001a\u000b\u0007\u0005\u0017\u0012iK!-\t\u0011\t=&q\u0015a\u0001\u0003S\n!b\u001c:jO&t\u0017\r\\%e\u0011!\u0011\u0019La*A\u0002\u0005%\u0014!\u00028fo&#\u0007\u0006\u0002BT\u0003\u0013CqA!/\u0001\t\u0003\u0012Y,A\u0005hKR\u001cF/\u0019;vgR!\u0011q\u001fB_\u0011!\t9Ga.A\u0002\u0005%\u0004\u0006\u0002B\\\u0003\u0013CqAa1\u0001\t\u0003\u0012)-A\u0006hKR\u001cF/\u0019;vg\u0016\u001cH\u0003\u0002Bd\u0005\u0013\u0004b!!8\u0002h\u0006]\b\u0002\u0003Bf\u0005\u0003\u0004\r!a7\u0002\u0007%$7\u000f\u000b\u0003\u0003B\u0006%\u0005b\u0002Bi\u0001\u0011\u0005#1[\u0001\u000eO\u0016$(+[:l'\u000e|'/Z:\u0015\t\tU'q\u001b\t\u0007\u0003;\f9Oa\u000f\t\u0011\t-'q\u001aa\u0001\u00037DCAa4\u0002|!\"!qZAE\u0011\u001d\u0011y\u000e\u0001C!\u0005C\fQb]3u%&\u001c8nU2pe\u0016\u001cH\u0003\u0003B&\u0005G\u0014)O!;\t\u0011\tM#Q\u001ca\u0001\u0003SB\u0001Ba:\u0003^\u0002\u0007!1H\u0001\u0006g\u000e|'/\u001a\u0005\t\u0005W\u0014i\u000e1\u0001\u0003<\u0005QAo\u001c;bYN\u001bwN]3)\t\tu\u0017\u0011\u0012\u0005\b\u0005c\u0004A\u0011\tBz\u0003)I7\u000fV3na2\fG/\u001a\u000b\u0005\u0003?\u0012)\u0010\u0003\u0005\u0003T\t=\b\u0019AA5Q\u0011\u0011y/a\u001f)\t\t=\u0018\u0011\u0012\u0005\b\u0005{\u0004A\u0011\tB\u0000\u0003!9W\r\u001e+ji2,G\u0003BA5\u0007\u0003A\u0001\"a\u001a\u0003|\u0002\u0007\u0011\u0011\u000e\u0015\u0005\u0005w\fY\b\u000b\u0003\u0003|\u0006%\u0005bBB\u0005\u0001\u0011\u000531B\u0001\u0007kB$\u0017\r^3\u0015\u0007q\u0019i\u0001C\u0004\u0002&\u000e\u001d\u0001\u0019\u0001\u000f)\t\r\u001d\u0011\u0011\u0012\u0005\b\u0007\u0013\u0001A\u0011IB\n)\u0015a2QCB\r\u0011\u001d\u00199b!\u0005A\u0002q\t\u0001b\u001c:jO&t\u0017\r\u001c\u0005\b\u00077\u0019\t\u00021\u0001\u001d\u0003\u001d)\b\u000fZ1uK\u0012DCa!\u0005\u0002\n\"91\u0011\u0005\u0001\u0005B\r\r\u0012a\u0002:fa2\f7-\u001a\u000b\u00069\r\u00152q\u0005\u0005\b\u0007/\u0019y\u00021\u0001\u001d\u0011\u001d\u0019Yba\bA\u0002qACaa\b\u0002\n\"91Q\u0006\u0001\u0005B\r=\u0012AC4fi\u0006cG\u000eV1hgR!1\u0011GB\u001c!\u0019\u0011Ica\r\u0002j%!1Q\u0007B\u0016\u0005\r\u0019V\r\u001e\u0005\t\u0007s\u0019Y\u00031\u0001\u0003<\u0005YA.[7ji:+XNY3sQ\u0011\u0019Y#a\u001f)\t\r-\u0012\u0011\u0012\u0005\b\u0007\u0003\u0002A\u0011BB\"\u0003)9W\r\u001e*fY\u0016\f7/\u001a\u000b\u00069\r\u00153\u0011\r\u0005\t\u0005'\u001ay\u00041\u0001\u0004HA!1\u0011JB.\u001d\u0011\u0019Yea\u0016\u000f\t\r53Q\u000b\b\u0005\u0007\u001f\u001a\u0019F\u0004\u0003\u0002\u0010\rE\u0013BA\u0003\u0007\u0013\t\u0019A!\u0003\u00029\u0005%\u00191\u0011L\u001c\u0002\t\rK\u0017\nZ\u0005\u0005\u0007;\u001ayF\u0001\u0003DS&#'bAB-o!A11MB \u0001\u0004\u00199%\u0001\u0005f]RLG/_%e\u0011\u001d\u00199\u0007\u0001C\u0005\u0007S\n!e\u00195fG.L5OT8u%\u00164WM]3oG\u0016$')\u001f#fa\u0016tG-\u001a8dS\u0016\u001cH\u0003\u0002B&\u0007WB\u0001b!\u001c\u0004f\u0001\u00071qI\u0001\u0018a2\fg.\u0013;f[&#wJ]%ug\u000eC\u0017\u000e\u001c3sK:D3\u0001AB9!\u0011\tiha\u001d\n\t\rU\u0014q\u0010\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationPersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final TriggerPersistence triggerPersistence;
    private final FacetRepository facetRepository;
    private final SqlBuilder.Dialect sqlDialect;
    private Logger grizzled$slf4j$Logging$$_logger;
    private Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile boolean bitmap$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceTriggers(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTriggers$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(Release release) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, release);
    }

    @Override
    public void deleteConfigurationRefs(Integer releaseUid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, releaseUid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$(this, persistenceInterceptor);
    }

    @Override
    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$(this, ci);
    }

    @Override
    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$(this, ciId);
    }

    public Release findById(String id) {
        return ReleaseRepository.findById$((ReleaseRepository)this, (String)id);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    @Override
    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationPersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$.MODULE$.RichCiId(id).normalized());
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        release.getReleaseTriggers().forEach(trigger -> this.triggerPersistence().insert((ReleaseTrigger)trigger));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$2(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs(release);
        this.facetRepository.createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala());
        return release;
    }

    @Timed
    public Release findById(String id, WorkDir workDir) {
        return this.getRelease(id, id);
    }

    @Timed
    public Seq<String> findIdsByStatus(Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable & scala.Serializable)releaseData -> this.deserializeRelease((ReleaseRow)releaseData)).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release)).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release)).orNull(Predef$.MODULE$.$conforms());
    }

    @Timed
    @IsReadOnly
    public Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((Seq<ReleaseStatus>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0)));
        boolean x$6 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$6).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        Seq inactive = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)releaseData -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)releaseData)), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isTutorial()))).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)((Object)folderId2.fold((Function1 & Serializable & scala.Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable & scala.Serializable)ancestorId -> base.withAncestor((String)ancestorId)));
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).nonEmpty() ? sqlBuilder.withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable & scala.Serializable)releaseData -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)releaseData)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.releaseExtensionsRepository().decorate(release), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)release -> this.commentPersistence().decorate((Release)release), Seq$.MODULE$.canBuildFrom())).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable & scala.Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.triggerPersistence().deleteByTemplateId(id);
        this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid));
        this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
        this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository().deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.interceptDelete(id);
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$.MODULE$.RichCiId(id).normalized()).orNull(Predef$.MODULE$.$conforms());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public Seq<ReleaseStatus> getStatuses(Seq<String> ids) {
        return ids.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : (Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable & scala.Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()), Seq$.MODULE$.canBuildFrom());
    }

    @Timed
    @IsReadOnly
    public Seq<Object> getRiskScores(Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$.MODULE$.RichCiId(id).normalized()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(original.getAllTasks()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable & scala.Serializable)task -> {
                SqlReleaseRepository.$anonfun$update$1(this, updated, task);
                return BoxedUnit.UNIT;
            });
            Buffer originalTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(original.getReleaseTriggers()).asScala();
            Buffer updatedTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(updated.getReleaseTriggers()).asScala();
            Diff triggerDiff = Diff$.MODULE$.apply((Iterable)originalTriggers, (Iterable)updatedTriggers);
            triggerDiff.newValues().foreach((Function1 & Serializable & scala.Serializable)trigger -> {
                SqlReleaseRepository.$anonfun$update$5(this, trigger);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)((TraversableLike)triggerDiff.updatedPairs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$6(x0$1)))).map((Function1 & Serializable & scala.Serializable)x$3 -> (ReleaseTrigger)x$3._2(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)releaseTrigger -> {
                SqlReleaseRepository.$anonfun$update$8(this, releaseTrigger);
                return BoxedUnit.UNIT;
            });
        }
        this.updateConfigurationRefs(updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceTriggers(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs(updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    private Release getRelease(String releaseId, String entityId) {
        Release release = (Release)this.repositoryAdapter().read(releaseId);
        if (release == null) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Repository entity [", "] not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityId})), new Object[0]);
        }
        this.releaseExtensionsRepository().decorate(release);
        return this.commentPersistence().decorate(release);
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        Seq externalIncomingDependencies = (Seq)((TraversableLike)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$4 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$4).fullDependencyId(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren).normalized())));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot delete [", "] because it or one of its children is referenced by "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{planItemIdOrItsChildren})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"one or more dependencies: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{externalIncomingDependencies.mkString(", ")})), new Object[0]);
        }
    }

    public static final /* synthetic */ boolean $anonfun$create$3(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$2(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$3($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$2(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$2($this, taskUid, c)));
        ((IterableLike)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isArchived()))).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$5(SqlReleaseRepository $this, ReleaseTrigger trigger) {
        $this.triggerPersistence().insert(trigger);
    }

    public static final /* synthetic */ boolean $anonfun$update$6(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReleaseTrigger orig = (ReleaseTrigger)tuple2._1();
        ReleaseTrigger up = (ReleaseTrigger)tuple2._2();
        boolean bl = orig.isEnabled() != up.isEnabled();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$update$8(SqlReleaseRepository $this, ReleaseTrigger releaseTrigger) {
        $this.triggerPersistence().update(releaseTrigger);
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationPersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, TriggerPersistence triggerPersistence, FacetRepository facetRepository, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.triggerPersistence = triggerPersistence;
        this.facetRepository = facetRepository;
        this.sqlDialect = sqlDialect;
        ReleaseRepository.$init$((ReleaseRepository)this);
        InterceptedRepository.$init$(this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
    }
}

