/*
 * Decompiled with CFR 0.152.
 */
package com.romix.akka.serialization.kryo;

import com.romix.akka.serialization.kryo.Transformation;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001\u001b\t\tBJ\u0017\u001bLef|7i\\7qe\u0016\u001c8o\u001c:\u000b\u0005\r!\u0011\u0001B6ss>T!!\u0002\u0004\u0002\u001bM,'/[1mSj\fG/[8o\u0015\t9\u0001\"\u0001\u0003bW.\f'BA\u0005\u000b\u0003\u0015\u0011x.\\5y\u0015\u0005Y\u0011aA2p[\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u001dQ\u0013\u0018M\\:g_Jl\u0017\r^5p]\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u0003+\u0001A\u0001\"\b\u0001\t\u0006\u0004%\tAH\u0001\u000bYj$d-Y2u_JLX#A\u0010\u0011\u0005\u0001:S\"A\u0011\u000b\u0005\t\u001a\u0013a\u00017{i)\u0011A%J\u0001\bUB|WO\u001c;{\u0015\u00051\u0013a\u00018fi&\u0011\u0001&\t\u0002\u000b\u0019j#d)Y2u_JL\b\"\u0002\u0016\u0001\t\u0003Y\u0013\u0001\u0003;p\u0005&t\u0017M]=\u0015\u00051\u0012\u0004cA\b._%\u0011a\u0006\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u001fAJ!!\r\t\u0003\t\tKH/\u001a\u0005\u0006g%\u0002\r\u0001L\u0001\nS:\u0004X\u000f\u001e\"vM\u001aDQ!\u000e\u0001\u0005\u0002Y\n!B\u001a:p[\nKg.\u0019:z)\tas\u0007C\u00034i\u0001\u0007A\u0006")
public class LZ4KryoCompressor
implements Transformation {
    private LZ4Factory lz4factory;
    private volatile boolean bitmap$0;

    private LZ4Factory lz4factory$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.lz4factory = LZ4Factory.fastestInstance();
                this.bitmap$0 = true;
            }
        }
        return this.lz4factory;
    }

    public LZ4Factory lz4factory() {
        if (!this.bitmap$0) {
            return this.lz4factory$lzycompute();
        }
        return this.lz4factory;
    }

    @Override
    public byte[] toBinary(byte[] inputBuff) {
        int inputSize = inputBuff.length;
        LZ4Compressor lz4 = this.lz4factory().fastCompressor();
        int maxOutputSize = lz4.maxCompressedLength(inputSize);
        byte[] outputBuff = new byte[maxOutputSize + 4];
        int outputSize = lz4.compress(inputBuff, 0, inputSize, outputBuff, 4, maxOutputSize);
        outputBuff[0] = (byte)(inputSize & 0xFF);
        outputBuff[1] = (byte)(inputSize >> 8 & 0xFF);
        outputBuff[2] = (byte)(inputSize >> 16 & 0xFF);
        outputBuff[3] = (byte)(inputSize >> 24 & 0xFF);
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(outputBuff)).take(outputSize + 4);
    }

    @Override
    public byte[] fromBinary(byte[] inputBuff) {
        int size = inputBuff[0] & 0xFF | (inputBuff[1] & 0xFF) << 8 | (inputBuff[2] & 0xFF) << 16 | (inputBuff[3] & 0xFF) << 24;
        LZ4FastDecompressor lz4 = this.lz4factory().fastDecompressor();
        byte[] outputBuff = new byte[size];
        lz4.decompress(inputBuff, 4, outputBuff, 0, size);
        return outputBuff;
    }
}

