/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import org.commonmark.node.Block;
import org.commonmark.node.ListItem;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.ParserState;

public class ListItemParser
extends AbstractBlockParser {
    private final ListItem block = new ListItem();
    private int contentIndent;

    public ListItemParser(int contentIndent) {
        this.contentIndent = contentIndent;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block block) {
        return true;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.isBlank()) {
            if (this.block.getFirstChild() == null) {
                return BlockContinue.none();
            }
            return BlockContinue.atIndex(state.getNextNonSpaceIndex());
        }
        if (state.getIndent() >= this.contentIndent) {
            return BlockContinue.atColumn(state.getColumn() + this.contentIndent);
        }
        return BlockContinue.none();
    }
}

