/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BaseScriptTask;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.domain.utils.PythonScriptCiHelper;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.events.TaskStartOrRetryOperation;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.service.ExecuteTaskAction;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label="Python Script", versioned=false)
public class CustomScriptTask
extends BaseScriptTask {
    public static final Type UNKNOWN_TYPE = Type.valueOf((String)"xlrelease.UnknownType");
    public static final String PYTHON_SCRIPT_PREFIX = "pythonScript.";
    private static final String IGNORE_SCRIPT_VARIABLE_INTERPOLATION = "scriptIgnoreVariableInterpolation";
    private static final String KEEP_PREVIOUS_OUTPUT_PROPERTIES_ON_RETRY = "keepPreviousOutputPropertiesOnRetry";
    private static final String SCRIPT_PROPERTY_NAME = "script";
    @Property
    private PythonScript pythonScript;
    @Property(required=false, description="Status line of the task that will appear in UI.")
    private String statusLine;
    @Property(category="internal", description="Path of the next script to schedule.")
    private String nextScriptPath;
    @Property(required=false, category="internal", description="Delay in seconds before the next script will start executing.")
    private Integer interval;
    @Property(required=false, description="Keep the previous output properties on retry")
    private boolean keepPreviousOutputPropertiesOnRetry;

    @Override
    protected Set<String> freezeVariablesInCustomFields(Map<String, String> variables, Map<String, String> passwordVariables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet unresolvedVariables = Sets.newHashSet();
        PythonScript pythonScript = this.getPythonScript();
        Collection<PropertyDescriptor> propertiesWithVariables = pythonScript.getPropertiesWithVariables();
        for (PropertyDescriptor propertyDescriptor : propertiesWithVariables) {
            Object value = pythonScript.getProperty(propertyDescriptor.getName());
            if (propertyDescriptor.isPassword()) {
                value = VariableHelper.replaceAll(value, passwordVariables, (Set<String>)unresolvedVariables, freezeEvenIfUnresolved);
            } else if (!propertyDescriptor.getName().equals(SCRIPT_PROPERTY_NAME) || propertyDescriptor.getName().equals(SCRIPT_PROPERTY_NAME) && !this.isPropertyVariableInterpolationOff(this.getPythonScript())) {
                value = VariableHelper.replaceAll(value, variables, (Set<String>)unresolvedVariables, freezeEvenIfUnresolved);
            }
            pythonScript.setProperty(propertyDescriptor.getName(), value);
        }
        if (!propertiesWithVariables.isEmpty()) {
            changes.update((ConfigurationItem)pythonScript);
        }
        return unresolvedVariables;
    }

    @Override
    protected boolean shouldFreezeVariableMapping(CiProperty property) {
        return !"output".equals(property.getDescriptor().getCategory());
    }

    @Override
    public boolean isPreconditionEnabled() {
        return (Boolean)this.pythonScript.getProperty("preconditionEnabled");
    }

    @Override
    protected Changes execute(String targetId, TaskStartOrRetryOperation operation) {
        return this.executeScript(targetId, operation, new ExecuteTaskAction(this));
    }

    @PublicApiMember
    public PythonScript getPythonScript() {
        return this.pythonScript;
    }

    @PublicApiMember
    public void setPythonScript(PythonScript pythonScript) {
        this.pythonScript = pythonScript;
    }

    @Override
    public String getEngine() {
        return "jython";
    }

    @PublicApiMember
    public String getStatusLine() {
        return this.statusLine;
    }

    public void setStatusLine(String statusLine) {
        this.statusLine = statusLine;
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        ArrayList<UsagePoint> usagePoints = new ArrayList<UsagePoint>(super.getVariableUsages());
        usagePoints.addAll(this.getPythonScript().getInputProperties().stream().filter(pd -> !pd.getName().equals(SCRIPT_PROPERTY_NAME) || pd.getName().equals(SCRIPT_PROPERTY_NAME) && !this.isPropertyVariableInterpolationOff(this.pythonScript)).map(pd -> new PropertyUsagePoint((ConfigurationItem)this.getPythonScript(), pd.getName())).collect(Collectors.toList()));
        usagePoints.addAll(this.getPythonScript().getOutputProperties().stream().map(pd -> new PropertyUsagePoint((ConfigurationItem)this.getPythonScript(), pd.getName())).collect(Collectors.toList()));
        return usagePoints;
    }

    public void setNextScriptPath(String nextScriptPath) {
        this.nextScriptPath = nextScriptPath;
    }

    public String getNextScriptPath() {
        return this.nextScriptPath;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public boolean hasNextScriptToExecute() {
        return Strings.isNotBlank((String)this.nextScriptPath);
    }

    @PublicApiMember
    public void schedule(String scriptPath) {
        this.schedule(scriptPath, null);
    }

    @PublicApiMember
    public void schedule(String scriptPath, Integer interval) {
        if (interval != null && interval < 1) {
            throw new IllegalArgumentException("interval must be in range between 1 and 2147483647");
        }
        this.nextScriptPath = scriptPath;
        this.interval = interval;
    }

    public void resetSchedule() {
        this.nextScriptPath = null;
        this.interval = null;
    }

    @Override
    public boolean resumeOnRecovery() {
        return this.isInProgress() && this.hasNextScriptToExecute();
    }

    @Override
    public Changes retry(String targetId) {
        this.resetPythonScriptState();
        this.statusLine = null;
        Changes changes = super.retry(targetId);
        changes.update((ConfigurationItem)this.pythonScript);
        return changes;
    }

    private void resetPythonScriptState() {
        this.resetSchedule();
        this.getPythonScript().getTransitionalAndOutputProperties().stream().filter(pd -> !this.isKeepPreviousOutputPropertiesOnRetry() || PythonScriptCiHelper.isEmpty(this.pythonScript.getProperty(pd.getName()))).forEach(propertyDescriptor -> propertyDescriptor.set((ConfigurationItem)this.getPythonScript(), propertyDescriptor.getDefaultValue()));
    }

    public String getScriptPath() {
        if (this.hasNextScriptToExecute()) {
            return this.nextScriptPath;
        }
        String customScriptLocation = (String)this.pythonScript.getProperty("scriptLocation");
        if (Strings.isNotBlank((String)customScriptLocation)) {
            return customScriptLocation;
        }
        return ScriptHelper.getDefaultPath(this.pythonScript.getType());
    }

    private boolean isPropertyVariableInterpolationOff(PythonScript pythonScript) {
        return pythonScript.hasProperty(IGNORE_SCRIPT_VARIABLE_INTERPOLATION) ? (Boolean)pythonScript.getProperty(IGNORE_SCRIPT_VARIABLE_INTERPOLATION) : false;
    }

    public boolean isUnknown() {
        return this.pythonScript.getType().equals((Object)UNKNOWN_TYPE);
    }

    @PublicApiMember
    public boolean isKeepPreviousOutputPropertiesOnRetry() {
        return this.keepPreviousOutputPropertiesOnRetry;
    }

    @PublicApiMember
    public void setKeepPreviousOutputPropertiesOnRetry(boolean keepPreviousOutputPropertiesOnRetry) {
        this.keepPreviousOutputPropertiesOnRetry = keepPreviousOutputPropertiesOnRetry;
    }
}

