/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.client.RemoteRuntimeException;
import org.apache.jackrabbit.rmi.remote.RemoteLock;

public class ClientLock
implements Lock {
    private Node node;
    private RemoteLock remote;

    public ClientLock(Node node, RemoteLock remote) {
        this.node = node;
        this.remote = remote;
    }

    public Node getNode() {
        return this.node;
    }

    public String getLockOwner() {
        try {
            return this.remote.getLockOwner();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isDeep() {
        try {
            return this.remote.isDeep();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public String getLockToken() {
        try {
            return this.remote.getLockToken();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isLive() throws RepositoryException {
        try {
            return this.remote.isLive();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public void refresh() throws RepositoryException {
        try {
            this.remote.refresh();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public boolean isSessionScoped() {
        try {
            return this.remote.isSessionScoped();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }
}

