/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.excel;

import com.xebialabs.xlrelease.excel.Export;
import com.xebialabs.xlrelease.reports.dto.ReleaseDuration;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class TopLongestReleaseExport
extends Export {
    private List<ReleaseDuration> topLongestReleases;
    public static final int TITLE_COLUMN = 0;
    public static final int DURATION_COLUMN = 1;
    private static final String TITLE_HEADER = "Release";
    private static final String DURATION_HEADER = "Duration";

    public TopLongestReleaseExport(List<ReleaseDuration> topLongestReleases) {
        this.topLongestReleases = topLongestReleases;
    }

    public void addContent() {
        for (ReleaseDuration releaseDuration : this.topLongestReleases) {
            XSSFRow row = this.sheet.createRow(this.rowIndex++);
            CellUtil.createCell((Row)row, (int)0, (String)releaseDuration.getTitle());
            XSSFCell duration = row.createCell(1);
            duration.setCellValue((double)releaseDuration.getDuration());
        }
    }

    protected void setColumnsWidth() {
        this.sheet.setColumnWidth(0, this.numberOfCharacter(30));
        this.sheet.setColumnWidth(1, this.numberOfCharacter(15));
    }

    protected void addHeaderRow() {
        XSSFRow row = this.sheet.createRow(this.rowIndex++);
        CellUtil.createCell((Row)row, (int)0, (String)TITLE_HEADER);
        CellUtil.createCell((Row)row, (int)1, (String)DURATION_HEADER);
        this.sheet.createRow(this.rowIndex++);
    }
}

