/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.filters;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.db.sql.archiving.BaseSelectArchivedBuilder;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Metadata(description="Composite filter to combine multiple child filters into a single AND or OR condition.")
public class CompositeFilter
extends ReportFilter {
    @Property(description="Operator to apply when merging the child filters.")
    private Operator operator = Operator.OR;
    @Property(asContainment=true, description="Child filters.")
    private List<ReportFilter> filters = new ArrayList<ReportFilter>();

    public CompositeFilter() {
    }

    public CompositeFilter(Operator operator, ReportFilter ... filters) {
        this.operator = operator;
        this.filters = Arrays.asList(filters);
    }

    public List<ReportFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<ReportFilter> filters) {
        this.filters = filters;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public void visit(BaseSelectArchivedBuilder builder) {
        if (this.filters != null && !this.filters.isEmpty()) {
            BaseSelectArchivedBuilder childBuilder = builder.newInstance();
            this.filters.forEach(filter -> filter.visit(childBuilder));
            builder.withConditions(childBuilder.conditions(), this.operator.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CompositeFilter that = (CompositeFilter)((Object)o);
        return this.operator == that.operator && Objects.equals(this.filters, that.filters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.operator, this.filters});
    }

    public String toString() {
        return this.filters.stream().map(Object::toString).collect(Collectors.joining(" " + this.operator.getValue() + " "));
    }

    public static enum Operator {
        AND("AND"),
        OR("OR");

        private String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

