/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.filters.impl;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.api.v1.forms.TimeFrame;
import com.xebialabs.xlrelease.db.sql.archiving.BaseSelectArchivedBuilder;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import java.util.Date;
import java.util.Objects;

@Metadata(label="DateFilter", versioned=false)
public class DateFilter
extends ReportFilter {
    @Property(required=false, description="Predefined time-frame to apply to the reports query.")
    private TimeFrame timeFrame = TimeFrame.LAST_SIX_MONTHS;
    @Property(required=false, description="Overrides the predefined time-frame with a custom from date.")
    private Date from;
    @Property(required=false, description="Overrides the predefined time-frame with a custom to date.")
    private Date to;

    public DateFilter() {
    }

    public DateFilter(TimeFrame timeFrame, Date from, Date to) {
        this.timeFrame = timeFrame;
        this.from = from;
        this.to = to;
    }

    public DateFilter(TimeFrame timeFrame) {
        this.timeFrame = timeFrame;
    }

    public void visit(BaseSelectArchivedBuilder<?> builder) {
        if (this.timeFrame != null) {
            builder.withStartDate(new Date(this.timeFrame.getStartDate(this.from)));
            builder.withEndDate(new Date(this.timeFrame.getEndDate(this.to)));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateFilter that = (DateFilter)((Object)o);
        return this.timeFrame == that.timeFrame && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.timeFrame, this.from, this.to);
    }

    public String toString() {
        return "[from = " + this.from + ", to = " + this.to + ", timeFrame = " + this.timeFrame + "]";
    }

    public TimeFrame getTimeFrame() {
        return this.timeFrame;
    }

    public void setTimeFrame(TimeFrame timeFrame) {
        this.timeFrame = timeFrame;
    }

    public Date getFrom() {
        return this.from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return this.to;
    }

    public void setTo(Date to) {
        this.to = to;
    }
}

