/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.impl;

import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.reports.job.api.ReportDefinition;
import com.xebialabs.xlrelease.reports.job.api.ReportJobProgressMonitor;
import com.xebialabs.xlrelease.reports.job.api.ReportJobRunContext;
import com.xebialabs.xlrelease.reports.job.api.ReportResult;
import com.xebialabs.xlrelease.reports.job.api.ReportStorage;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.domain.ReportJobStatus;
import com.xebialabs.xlrelease.reports.job.events.ReportJobCompletedEvent;
import com.xebialabs.xlrelease.reports.job.events.ReportJobFailedEvent;
import com.xebialabs.xlrelease.reports.job.impl.GlobalReportStorage;
import com.xebialabs.xlrelease.reports.job.impl.ReportExecutorService;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstance$;
import com.xebialabs.xlrelease.reports.job.impl.ReportingEngineConfiguration;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.Future;
import org.slf4j.Marker;
import org.springframework.context.ApplicationContext;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001\u0002\u000f\u001e\u0001)B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011!!\u0006A!A!\u0002\u0013)\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011}\u0003!\u0011!Q\u0001\n\u0001DQA\u001a\u0001\u0005\u0002\u001dDQ\u0001\u001d\u0001\u0005\u0002EDQ!\u001e\u0001\u0005\u0002YDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!9\u0011q\n\u0001\u0005\n\u0005E\u0003bBA,\u0001\u0011%\u0011\u0011\f\u0005\b\u0003?\u0002A\u0011BA1\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!a\u001b\u0001\t\u0013\t\tg\u0002\u0005\u0002nuA\t!HA8\r\u001daR\u0004#\u0001\u001e\u0003cBaA\u001a\u000b\u0005\u0002\u0005M\u0004bBA;)\u0011%\u0011q\u000f\u0004\u0007\u0003\u0003#B!a!\t\u0013\u0005-uC!A!\u0002\u0013A\u0007B\u00024\u0018\t\u0003\ti\tC\u0004\u0002P]!\t%!&\t\u000f\u0005]s\u0003\"\u0011\u0002\u001a\n\t\"+\u001a9peRTuNY%ogR\fgnY3\u000b\u0005yy\u0012\u0001B5na2T!\u0001I\u0011\u0002\u0007)|'M\u0003\u0002#G\u00059!/\u001a9peR\u001c(B\u0001\u0013&\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002'O\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002Q\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aK\u0019\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\r\u0005s\u0017PU3g!\t\u0011t'D\u00014\u0015\t!T'A\u0003tY\u001a$$NC\u00017\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001d4\u0005\u001daunZ4j]\u001e\f\u0011B]3q_J$(j\u001c2\u0011\u0005mrT\"\u0001\u001f\u000b\u0005uz\u0012A\u00023p[\u0006Lg.\u0003\u0002@y\tI!+\u001a9peRTuNY\u0001\u0013CB\u0004H.[2bi&|gnQ8oi\u0016DH\u000f\u0005\u0002C\u00136\t1I\u0003\u0002E\u000b\u000691m\u001c8uKb$(B\u0001$H\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001%\u0002\u0007=\u0014x-\u0003\u0002K\u0007\n\u0011\u0012\t\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u\u0003q\u0011X\r]8si&tw-\u00128hS:,7i\u001c8gS\u001e,(/\u0019;j_:\u0004\"!\u0014(\u000e\u0003uI!aT\u000f\u00039I+\u0007o\u001c:uS:<WI\\4j]\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006)\"/\u001a9peR,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007CA'S\u0013\t\u0019VDA\u000bSKB|'\u000f^#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002'I,\u0007o\u001c:u\u0015>\u0014'+\u001a9pg&$xN]=\u0011\u0005YKV\"A,\u000b\u0005a{\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011!l\u0016\u0002\u0014%\u0016\u0004xN\u001d;K_\n\u0014V\r]8tSR|'/_\u0001\u0014O2|'-\u00197SKB|'\u000f^*u_J\fw-\u001a\t\u0003\u001bvK!AX\u000f\u0003'\u001dcwNY1m%\u0016\u0004xN\u001d;Ti>\u0014\u0018mZ3\u0002\u0011\u00154XM\u001c;CkN\u0004\"!\u00193\u000e\u0003\tT!aY\u0012\u0002\r\u00154XM\u001c;t\u0013\t)'MA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\fa\u0001P5oSRtD\u0003\u00035jU.dWN\\8\u0011\u00055\u0003\u0001\"B\u001d\t\u0001\u0004Q\u0004\"\u0002!\t\u0001\u0004\t\u0005\"B&\t\u0001\u0004a\u0005\"\u0002)\t\u0001\u0004\t\u0006\"\u0002+\t\u0001\u0004)\u0006\"B.\t\u0001\u0004a\u0006\"B0\t\u0001\u0004\u0001\u0017\u0001C4fi*{'-\u00133\u0016\u0003I\u0004\"\u0001L:\n\u0005Ql#aA%oi\u0006\u0019!/\u001e8\u0015\u0003]\u00042\u0001\f={\u0013\tIXF\u0001\u0004PaRLwN\u001c\t\u0003wzl\u0011\u0001 \u0006\u0003{~\t1!\u00199j\u0013\tyHP\u0001\u0007SKB|'\u000f\u001e*fgVdG/A\u0004f]F,X-^3\u0015\u0005\u0005\u0015\u0001#BA\u0004\u0003+9XBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0010\u0005E\u0011\u0001B;uS2T!!a\u0005\u0002\t)\fg/Y\u0005\u0005\u0003/\tIA\u0001\u0004GkR,(/Z\u0001\u0005M\u0006LG\u000e\u0006\u0003\u0002\u001e\u0005\r\u0002c\u0001\u0017\u0002 %\u0019\u0011\u0011E\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003Ka\u0001\u0019AA\u0014\u0003%)\u0007pY3qi&|g\u000e\u0005\u0003\u0002*\u0005eb\u0002BA\u0016\u0003kqA!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003cI\u0013A\u0002\u001fs_>$h(C\u0001/\u0013\r\t9$L\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY$!\u0010\u0003\u0013QC'o\\<bE2,'bAA\u001c[\u0005)Am\u001c*v]R\u0011\u00111\t\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)!\u0011\u0011JA\t\u0003\rqW\r^\u0005\u0005\u0003\u001b\n9EA\u0002V%&\u000b!c]3oIR{G/\u00197X_J\\\u0017\n^3ngR!\u0011QDA*\u0011\u0019\t)F\u0004a\u0001e\u0006QAo\u001c;bY&#X-\\:\u0002-M,g\u000eZ\"p[BdW\r^3e/>\u00148.\u0013;f[N$B!!\b\u0002\\!1\u0011QL\bA\u0002I\fabY8na2,G/\u001a3Ji\u0016l7/A\u0003bE>\u0014H\u000f\u0006\u0002\u0002\u001e\u0005A1m\\7qY\u0016$X\rF\u0002{\u0003OBq!!\u001b\u0012\u0001\u0004\t\u0019%A\u0005sKN,H\u000e^+sS\u0006)1\u000f^1si\u0006\t\"+\u001a9peRTuNY%ogR\fgnY3\u0011\u00055#2C\u0001\u000b,)\t\ty'A\u0006dkJ\u0014XM\u001c;US6,WCAA=!\u0011\tY(! \u000e\u0005\u00055\u0011\u0002BA@\u0003\u001b\u0011A\u0001R1uK\nyB)\u001a4bk2$(+\u001a9peRTuN\u0019)s_\u001e\u0014Xm]:N_:LGo\u001c:\u0014\t]Y\u0013Q\u0011\t\u0004w\u0006\u001d\u0015bAAEy\nA\"+\u001a9peRTuN\u0019)s_\u001e\u0014Xm]:N_:LGo\u001c:\u0002#I,\u0007o\u001c:u\u0015>\u0014\u0017J\\:uC:\u001cW\r\u0006\u0003\u0002\u0010\u0006M\u0005cAAI/5\tA\u0003\u0003\u0004\u0002\ff\u0001\r\u0001\u001b\u000b\u0005\u0003;\t9\n\u0003\u0004\u0002Vi\u0001\rA\u001d\u000b\u0005\u0003;\tY\n\u0003\u0004\u0002^m\u0001\rA\u001d")
public class ReportJobInstance
implements Logging {
    private final ReportJob reportJob;
    private final ApplicationContext applicationContext;
    private final ReportingEngineConfiguration reportingEngineConfiguration;
    private final ReportExecutorService reportExecutorService;
    private final ReportJobRepository reportJobRepository;
    private final GlobalReportStorage globalReportStorage;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportJobInstance reportJobInstance = this;
        synchronized (reportJobInstance) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public int getJobId() {
        return Predef$.MODULE$.Integer2int(this.reportJob.jobId());
    }

    public Option<ReportResult> run() {
        Some some;
        this.start();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.doRun());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            URI resultUri = (URI)success.value();
            some = new Some((Object)this.complete(resultUri));
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.fail(exception);
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return some;
    }

    public Future<Option<ReportResult>> enqueue() {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Enqueued ").append($this.reportJob.jobId()).toString());
        return this.reportExecutorService.submit(() -> this.run());
    }

    public void fail(Throwable exception) {
        this.logger().warn((Function0 & Serializable & scala.Serializable)() -> exception.getMessage(), (Function0 & Serializable & scala.Serializable)() -> exception);
        this.reportJob.setEndTime(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
        this.reportJob.setStatus(ReportJobStatus.FAILED);
        this.reportJobRepository.update(this.reportJob);
        this.eventBus.publish((XLReleaseEvent)new ReportJobFailedEvent(this.reportJob));
    }

    private URI doRun() {
        ReportDefinition reportDefinition = this.reportJob.getReportDefinition();
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Starting report job [").append(reportDefinition.reportName()).append("] from user [").append(reportDefinition.getGeneratedBy()).append("]").toString());
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)reportDefinition);
        reportDefinition.setGeneratedOn(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
        Integer jobId = this.reportJob.getJobId();
        ReportStorage reportStorage = this.globalReportStorage.reportStorage(jobId, reportDefinition.getGeneratedOn());
        DefaultReportJobProgressMonitor reportJobProgressMonitor = new DefaultReportJobProgressMonitor(this);
        ReportJobRunContext runContext = new ReportJobRunContext(jobId, reportJobProgressMonitor, reportStorage);
        File resultFile = reportDefinition.run(runContext);
        URI contextUri = reportStorage.workdir().toURI();
        URI resultUri = contextUri.relativize(resultFile.toURI());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Finished report job [").append(reportDefinition.reportName()).append("] on [").append(resultUri).append("]").toString());
        return resultUri;
    }

    public void com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$sendTotalWorkItems(int totalItems) {
        this.reportJob.setTotalWorkItems(Predef$.MODULE$.int2Integer(totalItems));
        this.reportJobRepository.updateProgress(this.reportJob);
    }

    public void com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$sendCompletedWorkItems(int completedItems) {
        this.reportJob.setCompletedWorkItems(Predef$.MODULE$.int2Integer(completedItems));
        this.reportJobRepository.updateProgress(this.reportJob);
    }

    private void abort() {
        this.reportJob.setEndTime(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
        this.reportJob.setStatus(ReportJobStatus.ABORTED);
        this.reportJobRepository.update(this.reportJob);
    }

    private ReportResult complete(URI resultUri) {
        this.reportJob.setResultUri(resultUri.toString());
        this.reportJob.setEndTime(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
        this.reportJob.setStatus(ReportJobStatus.COMPLETED);
        this.reportJobRepository.update(this.reportJob);
        this.eventBus.publish((XLReleaseEvent)new ReportJobCompletedEvent(this.reportJob));
        return this.globalReportStorage.reportResult(this.reportJob);
    }

    private void start() {
        this.reportJob.setNode(this.reportingEngineConfiguration.node());
        this.reportJob.setStartTime(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
        this.reportJob.setStatus(ReportJobStatus.STARTED);
        this.reportJobRepository.update(this.reportJob);
    }

    public ReportJobInstance(ReportJob reportJob, ApplicationContext applicationContext, ReportingEngineConfiguration reportingEngineConfiguration, ReportExecutorService reportExecutorService, ReportJobRepository reportJobRepository, GlobalReportStorage globalReportStorage, XLReleaseEventBus eventBus) {
        this.reportJob = reportJob;
        this.applicationContext = applicationContext;
        this.reportingEngineConfiguration = reportingEngineConfiguration;
        this.reportExecutorService = reportExecutorService;
        this.reportJobRepository = reportJobRepository;
        this.globalReportStorage = globalReportStorage;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }

    public static class DefaultReportJobProgressMonitor
    implements ReportJobProgressMonitor {
        private final ReportJobInstance reportJobInstance;

        @Override
        public void sendTotalWorkItems(int totalItems) {
            this.reportJobInstance.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$sendTotalWorkItems(totalItems);
        }

        @Override
        public void sendCompletedWorkItems(int completedItems) {
            this.reportJobInstance.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$sendCompletedWorkItems(completedItems);
        }

        public DefaultReportJobProgressMonitor(ReportJobInstance reportJobInstance) {
            this.reportJobInstance = reportJobInstance;
        }
    }
}

