/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.impl.cleanup;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.configuration.AuditReportSettings;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.domain.ReportJobStatus;
import com.xebialabs.xlrelease.reports.job.impl.GlobalReportStorage;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstance;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstanceFactory;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobFilters;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.threeten.extra.Interval;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001\u0002\t\u0012\u0001\u0001B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u001di\u0005A1A\u0005\u00029Caa\u0016\u0001!\u0002\u0013y\u0005\"\u0002\n\u0001\t\u0003A\u0006\"\u0002/\u0001\t\u0003i\u0006BB6\u0001\t\u0003\u0019\u0002\fC\u0003m\u0001\u0011%\u0001\fC\u0003n\u0001\u0011%a\u000eC\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016!9\u0011\u0011\u0004\u0001\u0005\n\u0005m!a\u0006*fa>\u0014Ho\u00117fC:,'o\u00149fe\u0006$\u0018n\u001c8t\u0015\t\u00112#A\u0004dY\u0016\fg.\u001e9\u000b\u0005Q)\u0012\u0001B5na2T!AF\f\u0002\u0007)|'M\u0003\u0002\u00193\u00059!/\u001a9peR\u001c(B\u0001\u000e\u001c\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001d;\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002=\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tAS&D\u0001*\u0015\tQ3&A\u0003tY\u001a$$NC\u0001-\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0018*\u0005\u001daunZ4j]\u001e\f1C]3q_J$(j\u001c2SKB|7/\u001b;pef\u0004\"!\r\u001b\u000e\u0003IR!aM\u000b\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00026e\t\u0019\"+\u001a9peRTuN\u0019*fa>\u001c\u0018\u000e^8ss\u0006A\"/\u001a9peRTuNY%ogR\fgnY3GC\u000e$xN]=\u0011\u0005aJT\"A\n\n\u0005i\u001a\"\u0001\u0007*fa>\u0014HOS8c\u0013:\u001cH/\u00198dK\u001a\u000b7\r^8ss\u000692m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003{}j\u0011A\u0010\u0006\u0003geI!\u0001\u0011 \u0003/\r{gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\u0018aE4m_\n\fGNU3q_J$8\u000b^8sC\u001e,\u0007C\u0001\u001dD\u0013\t!5CA\nHY>\u0014\u0017\r\u001c*fa>\u0014Ho\u0015;pe\u0006<W-\u0001\u0004=S:LGO\u0010\u000b\u0006\u000f&S5\n\u0014\t\u0003\u0011\u0002i\u0011!\u0005\u0005\u0006_\u0015\u0001\r\u0001\r\u0005\u0006m\u0015\u0001\ra\u000e\u0005\u0006w\u0015\u0001\r\u0001\u0010\u0005\u0006\u0003\u0016\u0001\rAQ\u0001\u0013S:LG/[1mSj\fG/[8o)&lW-F\u0001P!\t\u0001V+D\u0001R\u0015\t\u00116+\u0001\u0003vi&d'\"\u0001+\u0002\t)\fg/Y\u0005\u0003-F\u0013A\u0001R1uK\u0006\u0019\u0012N\\5uS\u0006d\u0017N_1uS>tG+[7fAQ\t\u0011\f\u0005\u0002#5&\u00111l\t\u0002\u0005+:LG/A\u0006o_\u0012,7\t\\3b]V\u0004HCA-_\u0011\u0015y\u0016\u00021\u0001a\u0003\u0011qw\u000eZ3\u0011\u0005\u0005DgB\u00012g!\t\u00197%D\u0001e\u0015\t)w$\u0001\u0004=e>|GOP\u0005\u0003O\u000e\na\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011qmI\u0001\u000egR\fG/^:DY\u0016\fg.\u001e9\u0002\u001dM$xN]1hK\u000ecW-\u00198va\u0006Ya-Y5m\u001d>$WMS8c)\tIv\u000eC\u0003q\u0019\u0001\u0007\u0011/A\u0003k_\nLE\rE\u0002s\u0003\u000fq1a]A\u0001\u001d\t!hP\u0004\u0002v{:\u0011a\u000f \b\u0003ont!\u0001\u001f>\u000f\u0005\rL\u0018\"\u0001\u0010\n\u0005qi\u0012B\u0001\u000e\u001c\u0013\tA\u0012$\u0003\u0002\u0017/%\u0011q0F\u0001\u0004CBL\u0017\u0002BA\u0002\u0003\u000b\taCU3q_J$\u0018N\\4F]\u001eLg.Z*feZL7-\u001a\u0006\u0003\u007fVIA!!\u0003\u0002\f\t)!j\u001c2JI*!\u00111AA\u0003\u0003\u001d\u0011X-];fk\u0016$2!WA\t\u0011\u0015\u0001X\u00021\u0001r\u000311\u0017-\u001b7Ti\u0006dWMS8c)\rI\u0016q\u0003\u0005\u0006a:\u0001\r!]\u0001\u0005M\u0006LG\u000eF\u0003Z\u0003;\ty\u0002C\u0003q\u001f\u0001\u0007\u0011\u000f\u0003\u0004\u0002\"=\u0001\r\u0001Y\u0001\u0004[N<\u0007")
public class ReportCleanerOperations
implements Logging {
    private final ReportJobRepository reportJobRepository;
    private final ReportJobInstanceFactory reportJobInstanceFactory;
    private final ConfigurationRepository configurationRepository;
    private final GlobalReportStorage globalReportStorage;
    private final Date initializationTime;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportCleanerOperations reportCleanerOperations = this;
        synchronized (reportCleanerOperations) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Date initializationTime() {
        return this.initializationTime;
    }

    public void cleanup() {
        this.statusCleanup();
        this.storageCleanup();
    }

    public void nodeCleanup(String node) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Report status cleanup for node ").append(node).append(" started").toString());
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.reportJobRepository.startedNodeJobIds(node).foreach((Function1 & Serializable & scala.Serializable)jobId -> {
            this.failNodeJob(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Report status cleanup failed for jobs on node '").append(node).append("'").toString());
        }
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.reportJobRepository.submittedNodeJobIds(node).foreach((Function1 & Serializable & scala.Serializable)jobId -> {
            this.requeue(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Requeue failed for jobs that were submitted on node '").append(node).append("'").toString());
        }
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Report status cleanup for node ").append(node).append(" ended").toString());
    }

    public void statusCleanup() {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Report status cleanup started");
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.reportJobRepository.startedStaleJobIds(this.initializationTime()).foreach((Function1 & Serializable & scala.Serializable)jobId -> {
            this.failStaleJob(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Report status cleanup failed for stale jobs");
        }
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.reportJobRepository.submittedStaleJobIds(this.initializationTime()).foreach((Function1 & Serializable & scala.Serializable)jobId -> {
            this.requeue(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Requeue failed for previously submitted jobs");
        }
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Report status cleanup ended");
    }

    private void storageCleanup() {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Report storage cleanup started");
        AuditReportSettings reportSettings = (AuditReportSettings)this.configurationRepository.read("Configuration/settings/AuditReportSettings");
        ReportJobFilters filter = new ReportJobFilters();
        ZonedDateTime retentionCutOffDate = LocalDateTime.now().minusDays(Predef$.MODULE$.Integer2int(reportSettings.getReportsRetentionPeriod())).atZone(ZoneId.systemDefault());
        filter.endTime_$eq(Interval.of((Instant)Instant.MIN, (Instant)retentionCutOffDate.toInstant()));
        filter.statuses_$eq((List<String>)new .colon.colon((Object)ReportJobStatus.ABORTED.name(), (List)new .colon.colon((Object)ReportJobStatus.FAILED.name(), (List)new .colon.colon((Object)ReportJobStatus.COMPLETED.name(), (List)Nil$.MODULE$))));
        Page<ReportJob> result = this.reportJobRepository.query(filter, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        result.get().forEach(reportJob -> {
            try {
                if ($this.globalReportStorage.cleanup((ReportJob)((Object)reportJob))) {
                    reportJob.status_$eq(ReportJobStatus.DELETED);
                    $this.reportJobRepository.update((ReportJob)((Object)reportJob));
                }
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            }
        });
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Report storage cleanup finished");
    }

    private void failNodeJob(Integer jobId) {
        this.fail(jobId, new StringBuilder(89).append("Job '").append(jobId).append("' marked as '").append((Object)ReportJobStatus.FAILED).append("' because it was executing on a node that was removed from XLR cluster.").toString());
    }

    private void requeue(Integer jobId) {
        ReportJobInstance reportJobInstance = (ReportJobInstance)this.reportJobRepository.findByJobId(jobId).map((Function1 & Serializable & scala.Serializable)reportJob -> $this.reportJobInstanceFactory.create((ReportJob)((Object)reportJob))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(25).append("Job with id '").append(jobId).append("' not found.").toString(), new Object[0]);
        });
        reportJobInstance.enqueue();
    }

    private void failStaleJob(Integer jobId) {
        this.fail(jobId, new StringBuilder(44).append("Job '").append(jobId).append("' is a stale report job that should be ").append((Object)ReportJobStatus.FAILED).toString());
    }

    private void fail(Integer jobId, String msg) {
        this.reportJobRepository.findByJobId(jobId).foreach((Function1 & Serializable & scala.Serializable)reportJob -> {
            ReportCleanerOperations.$anonfun$fail$1(this, msg, reportJob);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$fail$1(ReportCleanerOperations $this, String msg$1, ReportJob reportJob) {
        new Some((Object)$this.reportJobInstanceFactory.create(reportJob)).foreach((Function1 & Serializable & scala.Serializable)jobInstance -> {
            jobInstance.fail(new IllegalStateException(msg$1));
            return BoxedUnit.UNIT;
        });
    }

    public ReportCleanerOperations(ReportJobRepository reportJobRepository, ReportJobInstanceFactory reportJobInstanceFactory, ConfigurationRepository configurationRepository, GlobalReportStorage globalReportStorage) {
        this.reportJobRepository = reportJobRepository;
        this.reportJobInstanceFactory = reportJobInstanceFactory;
        this.configurationRepository = configurationRepository;
        this.globalReportStorage = globalReportStorage;
        Logging.$init$((Logging)this);
        this.initializationTime = Date.from(Instant.now());
    }
}

