/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.export.UnresolvedReferencesConfigurationItemConverter;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.export.TemplateContent;
import com.xebialabs.xlrelease.export.TemplateImportContext;
import com.xebialabs.xlrelease.export.TemplateImportProcessor;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.views.ImportResult;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import scala.Function1;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=e!\u0002\n\u0014\u0003\u0003a\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u0011-\u0002!\u0011!Q\u0001\n1B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019\u0011\u0006\u0001)A\u0005q!)1\u000b\u0001D\u0001)\")!\r\u0001D\tG\")A\u000e\u0001D\t[\"1A\u0010\u0001D\u0001'uDq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002&\u0001!I!a\n\t\u000f\u0005E\u0002\u0001\"\u0003\u00024!9\u0011q\b\u0001\u0005\n\u0005\u0005\u0003bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0003\u007f\u0002A\u0011BAA\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013\u0013ACQ1tKR+W\u000e\u001d7bi\u0016LU\u000e]8si\u0016\u0014(B\u0001\u000b\u0016\u0003\u0019)\u0007\u0010]8si*\u0011acF\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001G\r\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u000e\u0002\u0007\r|Wn\u0001\u0001\u0016\u0005u!5C\u0001\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fM\u0006\tB/Y:l\u0003\u000e\u001cWm]:TKJ4\u0018nY3\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!*\u0012aB:feZL7-Z\u0005\u0003U\u001d\u0012\u0011\u0003V1tW\u0006\u001b7-Z:t'\u0016\u0014h/[2f\u00039\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016\u0004\"AJ\u0017\n\u00059:#A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\u0018[\u0006L(-\u001a+f[Bd\u0017\r^3Qe>\u001cWm]:peN\u00042!\r\u001c9\u001b\u0005\u0011$BA\u001a5\u0003\u0011)H/\u001b7\u000b\u0003U\nAA[1wC&\u0011qG\r\u0002\t\u001fB$\u0018n\u001c8bYB\u0019\u0011'O\u001e\n\u0005i\u0012$\u0001\u0002'jgR\u0004\"\u0001P\u001f\u000e\u0003MI!AP\n\u0003/Q+W\u000e\u001d7bi\u0016LU\u000e]8siB\u0013xnY3tg>\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003B\u001b:{\u0005c\u0001\u001f\u0001\u0005B\u00111\t\u0012\u0007\u0001\t\u0015)\u0005A1\u0001G\u0005\u0005!\u0016CA$K!\ty\u0002*\u0003\u0002JA\t9aj\u001c;iS:<\u0007C\u0001\u001fL\u0013\ta5CA\bUK6\u0004H.\u0019;f\u0007>tG/\u001a8u\u0011\u0015!C\u00011\u0001&\u0011\u0015YC\u00011\u0001-\u0011\u0015yC\u00011\u00011\u0003I!X-\u001c9mCR,\u0007K]8dKN\u001cxN]:\u0016\u0003a\n1\u0003^3na2\fG/\u001a)s_\u000e,7o]8sg\u0002\n\u0001b];qa>\u0014Ho]\u000b\u0003+r#\"AV-\u0011\u0005}9\u0016B\u0001-!\u0005\u001d\u0011un\u001c7fC:DQAW\u0004A\u0002m\u000bQ\"[7q_J$8i\u001c8uKb$\bCA\"]\t\u0015ivA1\u0001_\u0005\u0005)\u0016CA$`!\ta\u0004-\u0003\u0002b'\t)B+Z7qY\u0006$X-S7q_J$8i\u001c8uKb$\u0018!\u00063p%\u0016\fG\rV3na2\fG/Z\"p]R,g\u000e\u001e\u000b\u0003\u0005\u0012DQ!\u001a\u0005A\u0002\u0019\f1\"\u001b8qkR\u001cFO]3b[B\u0011qM[\u0007\u0002Q*\u0011\u0011\u000eN\u0001\u0003S>L!a\u001b5\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0019I>,\u0006o\u001a:bI\u0016$V-\u001c9mCR,7i\u001c8uK:$HC\u00018{!\r\t\u0014h\u001c\t\u0003a^t!!];\u0011\u0005I\u0004S\"A:\u000b\u0005Q\\\u0012A\u0002\u001fs_>$h(\u0003\u0002wA\u00051\u0001K]3eK\u001aL!\u0001_=\u0003\rM#(/\u001b8h\u0015\t1\b\u0005C\u0003|\u0013\u0001\u0007!)A\buK6\u0004H.\u0019;f\u0007>tG/\u001a8u\u0003M!wnQ8om\u0016\u0014H\u000fV8UK6\u0004H.\u0019;f)\u0015q\u0018\u0011BA\u0006!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001\u0016\u0003\u0019!w.\\1j]&!\u0011qAA\u0001\u0005\u001d\u0011V\r\\3bg\u0016DQa\u001f\u0006A\u0002\tCa!!\u0004\u000b\u0001\u0004y\u0017a\u00053fgRLg.\u0019;j_:4u\u000e\u001c3fe&#\u0017AD5na>\u0014H\u000fV3na2\fG/\u001a\u000b\u0007\u0003'\t\t#a\t\u0011\tEJ\u0014Q\u0003\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D\u000b\u0002\u000bYLWm^:\n\t\u0005}\u0011\u0011\u0004\u0002\r\u00136\u0004xN\u001d;SKN,H\u000e\u001e\u0005\u0006K.\u0001\rA\u001a\u0005\u0007\u0003\u001bY\u0001\u0019A8\u0002+%l\u0007o\u001c:u)\u0016l\u0007\u000f\\1uK\u000e{g\u000e^3oiRA\u00111CA\u0015\u0003W\ti\u0003C\u0003|\u0019\u0001\u0007!\t\u0003\u0004\u0002\u000e1\u0001\ra\u001c\u0005\u0007\u0003_a\u0001\u0019\u00018\u0002\u0011]\f'O\\5oON\fQB]3tKR$V-\u001c9mCR,G\u0003BA\u001b\u0003w\u00012aHA\u001c\u0013\r\tI\u0004\t\u0002\u0005+:LG\u000f\u0003\u0004\u0002>5\u0001\rA`\u0001\be\u0016dW-Y:f\u0003e\u0011Xm]3u+:$Wm\u0019:zaR,G\rU1tg^|'\u000fZ:\u0015\r\u0005U\u00121IA$\u0011\u0019\t)E\u0004a\u0001}\u0006AA/Z7qY\u0006$X\rC\u0004\u000209\u0001\r!!\u0013\u0011\tE\nYe\\\u0005\u0004\u0003\u001b\u0012$AC\"pY2,7\r^5p]\u0006A\"/Z:fiVsG-Z2ssB$X\r\u001a)bgN<xN\u001d3\u0015\u000bY\u000b\u0019&a\u001c\t\u000f\u0005Us\u00021\u0001\u0002X\u0005\u00111-\u001b\t\u0005\u00033\nY'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\r)H-\u001c\u0006\u0005\u0003C\n\u0019'A\u0002ba&TA!!\u001a\u0002h\u00051\u0001\u000f\\;hS:T1!!\u001b\u0018\u0003!!W\r\u001d7ps&$\u0018\u0002BA7\u00037\u0012\u0011cQ8oM&<WO]1uS>t\u0017\n^3n\u0011\u001d\t\th\u0004a\u0001\u0003g\n!\u0003\u001d:pa\u0016\u0014H/\u001f#fg\u000e\u0014\u0018\u000e\u001d;peB!\u0011QOA>\u001b\t\t9H\u0003\u0003\u0002z\u0005}\u0013a\u0002:fM2,7\r^\u0005\u0005\u0003{\n9H\u0001\nQe>\u0004XM\u001d;z\t\u0016\u001c8M]5qi>\u0014\u0018!\b:f[>4X-T5tg&twmR1uK\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\r\u0005U\u00121QAC\u0011\u0019\t)\u0005\u0005a\u0001}\"9\u0011q\u0006\tA\u0002\u0005%\u0013a\u0006;f[Bd\u0017\r^3Fq&\u001cHo],ji\"$\u0016\u000e\u001e7f)\r1\u00161\u0012\u0005\u0007\u0003\u001b\u000b\u0002\u0019A8\u0002\u000bQLG\u000f\\3")
public abstract class BaseTemplateImporter<T extends TemplateContent> {
    private final TaskAccessService taskAccessService;
    private final ReleaseService releaseService;
    private final List<TemplateImportProcessor> templateProcessors;

    private List<TemplateImportProcessor> templateProcessors() {
        return this.templateProcessors;
    }

    public abstract <U extends TemplateImportContext> boolean supports(U var1);

    public abstract T doReadTemplateContent(InputStream var1);

    public abstract List<String> doUpgradeTemplateContent(T var1);

    public abstract Release doConvertToTemplate(T var1, String var2);

    public List<ImportResult> importTemplate(InputStream inputStream, String destinationFolderId) {
        T templateContent = this.doReadTemplateContent(inputStream);
        List<String> upgradeWarnings = this.doUpgradeTemplateContent(templateContent);
        return this.importTemplateContent(templateContent, destinationFolderId, upgradeWarnings);
    }

    private List<ImportResult> importTemplateContent(T templateContent, String destinationFolderId, List<String> warnings) {
        String destinationId = destinationFolderId == null ? Ids.ROOT_FOLDER_ID : destinationFolderId;
        Release template = this.doConvertToTemplate(templateContent, destinationId);
        template.getAttachments().forEach(attachment -> attachment.setFile((OverthereFile)templateContent.localFiles().get(attachment.getExportFilename())));
        Checks.checkArgument((boolean)template.isTemplate(), (String)"Only templates can be imported", (Object[])new Object[0]);
        this.taskAccessService.checkIfAuthenticatedUserCanUseTasks(template.getAllTasks());
        this.templateProcessors().forEach(processor -> warnings.addAll(processor.process(template, destinationId)));
        this.removeMissingGateDependencies(template, warnings);
        this.resetUndecryptedPasswords(template, warnings);
        this.resetTemplate(template);
        while (this.templateExistsWithTitle(template.getTitle())) {
            template.setTitle(RetryTitleGenerator.getNextTitle(template.getTitle()));
        }
        if (!template.hasScheduledStartDate()) {
            template.setScheduledStartDate(template.findFirstSetDate());
        }
        this.releaseService.importTemplate(template, destinationId);
        return Arrays.asList((Object[])new ImportResult[]{new ImportResult(template.getId(), template.getTitle(), warnings)});
    }

    private void resetTemplate(Release release) {
        release.setRunningTriggeredReleasesCount(0);
        release.getReleaseTriggers().forEach(releaseTrigger -> {
            releaseTrigger.setEnabled(false);
            releaseTrigger.resetExecutionId();
        });
    }

    private void resetUndecryptedPasswords(Release template, Collection<String> warnings) {
        block0: {
            BooleanRef issueWarning = BooleanRef.create((boolean)false);
            List configurationItems = CiHelper.getNestedCis((ConfigurationItem)template);
            configurationItems.forEach(configurationItem -> {
                Collection propertyDescriptors = configurationItem.getType().getDescriptor().getPropertyDescriptors();
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(propertyDescriptors).asScala()).foreach((Function1 & Serializable & scala.Serializable)propertyDescriptor -> {
                    BaseTemplateImporter.$anonfun$resetUndecryptedPasswords$2(this, configurationItem, issueWarning, propertyDescriptor);
                    return BoxedUnit.UNIT;
                });
            });
            if (!issueWarning.elem) break block0;
            warnings.add("Passwords could not be decrypted and have been reset.");
        }
    }

    private boolean resetUndecryptedPassword(ConfigurationItem ci, PropertyDescriptor propertyDescriptor) {
        PropertyKind propertyKind = propertyDescriptor.getKind();
        PropertyKind propertyKind2 = PropertyKind.STRING;
        if (!(propertyKind != null ? !propertyKind.equals(propertyKind2) : propertyKind2 != null) && propertyDescriptor.isPassword()) {
            String passwordValue;
            String string = passwordValue = (String)propertyDescriptor.get(ci);
            String string2 = UnresolvedReferencesConfigurationItemConverter.DECRYPTION_FAILED_VALUE;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                propertyDescriptor.set(ci, (Object)"");
                return true;
            }
        }
        return false;
    }

    private void removeMissingGateDependencies(Release template, Collection<String> warnings) {
        template.getAllGates().forEach(gateTask -> gateTask.getDependencies().removeIf(dependency -> {
            void var3_3;
            boolean shouldBeRemoved = !dependency.hasVariableTarget() && !dependency.hasResolvedTarget() && !dependency.isArchived();
            Object object = shouldBeRemoved ? BoxesRunTime.boxToBoolean((boolean)warnings.add(String.format("Gate Task '%s' has a dependency on an unknown Release/Phase/Task", gateTask.getTitle()))) : BoxedUnit.UNIT;
            return (boolean)var3_3;
        }));
    }

    private boolean templateExistsWithTitle(String title) {
        return this.releaseService.templateExistsWithTitle(title);
    }

    public static final /* synthetic */ void $anonfun$resetUndecryptedPasswords$2(BaseTemplateImporter $this, ConfigurationItem configurationItem$1, BooleanRef issueWarning$1, PropertyDescriptor propertyDescriptor) {
        block0: {
            boolean decryptionFailed = $this.resetUndecryptedPassword(configurationItem$1, propertyDescriptor);
            if (!decryptionFailed) break block0;
            issueWarning$1.elem = true;
        }
    }

    public BaseTemplateImporter(TaskAccessService taskAccessService, ReleaseService releaseService, Optional<List<TemplateImportProcessor>> maybeTemplateProcessors) {
        this.taskAccessService = taskAccessService;
        this.releaseService = releaseService;
        this.templateProcessors = maybeTemplateProcessors.orElse(Collections.emptyList());
    }
}

