/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.util.Assert;

public class ParametersParameterAccessor
implements ParameterAccessor {
    private final Parameters<?, ?> parameters;
    private final List<Object> values;

    public ParametersParameterAccessor(Parameters<?, ?> parameters, Object[] values) {
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.isTrue((parameters.getNumberOfParameters() == values.length ? 1 : 0) != 0, (String)"Invalid number of parameters given!");
        this.parameters = parameters;
        this.values = Arrays.stream(values).map(QueryExecutionConverters::unwrap).collect(Collectors.toList());
    }

    public Parameters<?, ?> getParameters() {
        return this.parameters;
    }

    @Override
    public Pageable getPageable() {
        if (!this.parameters.hasPageableParameter()) {
            return Pageable.unpaged();
        }
        Pageable pageable = (Pageable)this.values.get(this.parameters.getPageableIndex());
        return pageable == null ? Pageable.unpaged() : pageable;
    }

    @Override
    public Sort getSort() {
        if (this.parameters.hasSortParameter()) {
            Sort sort = (Sort)this.values.get(this.parameters.getSortIndex());
            return sort == null ? Sort.unsorted() : sort;
        }
        if (this.parameters.hasPageableParameter()) {
            return this.getPageable().getSort();
        }
        return Sort.unsorted();
    }

    @Override
    public Optional<Class<?>> getDynamicProjection() {
        return Optional.ofNullable(this.parameters.hasDynamicProjection() ? (Class)this.values.get(this.parameters.getDynamicProjectionIndex()) : null);
    }

    protected <T> T getValue(int index) {
        return (T)this.values.get(index);
    }

    @Override
    public Object getBindableValue(int index) {
        return this.values.get(((Parameter)this.parameters.getBindableParameter(index)).getIndex());
    }

    @Override
    public boolean hasBindableNullValue() {
        return this.parameters.getBindableParameters().stream().anyMatch(it -> this.values.get(it.getIndex()) == null);
    }

    public BindableParameterIterator iterator() {
        return new BindableParameterIterator(this);
    }

    private static class BindableParameterIterator
    implements Iterator<Object> {
        private final int bindableParameterCount;
        private final ParameterAccessor accessor;
        private int currentIndex = 0;

        public BindableParameterIterator(ParametersParameterAccessor accessor) {
            Assert.notNull((Object)accessor, (String)"ParametersParameterAccessor must not be null!");
            this.accessor = accessor;
            this.bindableParameterCount = ((Parameters)accessor.getParameters().getBindableParameters()).getNumberOfParameters();
        }

        @Override
        public Object next() {
            return this.accessor.getBindableValue(this.currentIndex++);
        }

        @Override
        public boolean hasNext() {
            return this.bindableParameterCount > this.currentIndex;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

