/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.triggers.repository;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.filter.TriggerFilters;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger;
import com.xebialabs.xlrelease.triggers.repository.persistence.TriggerPersistence;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001\u0002\t\u0012\u0001qA\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005m!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003@\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015I\b\u0001\"\u0011{\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002 \u0001!\t%!\t\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u0011q\r\u0001\u0005B\u0005%\u0004bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003W\u0003A\u0011BAW\u0011\u001d\t\t\f\u0001C\u0005\u0003g\u0013AcU9m)JLwmZ3s%\u0016\u0004xn]5u_JL(B\u0001\n\u0014\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003)U\t\u0001\u0002\u001e:jO\u001e,'o\u001d\u0006\u0003-]\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005aI\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005Q\u0012aA2p[\u000e\u00011\u0003\u0002\u0001\u001eG!\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007C\u0001\u0013'\u001b\u0005)#B\u0001\n\u0016\u0013\t9SEA\tUe&<w-\u001a:SKB|7/\u001b;pef\u00042!\u000b\u0017/\u001b\u0005Q#BA\u0016&\u0003\r\u0019\u0018\u000f\\\u0005\u0003[)\u0012Q#\u00138uKJ\u001cW\r\u001d;fIJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00020e5\t\u0001G\u0003\u00022+\u00051Am\\7bS:L!a\r\u0019\u0003\u000fQ\u0013\u0018nZ4fe\u0006\u0011BO]5hO\u0016\u0014\b+\u001a:tSN$XM\\2f+\u00051\u0004CA\u001c;\u001b\u0005A$BA\u001d\u0012\u0003-\u0001XM]:jgR,gnY3\n\u0005mB$A\u0005+sS\u001e<WM\u001d)feNL7\u000f^3oG\u0016\f1\u0003\u001e:jO\u001e,'\u000fU3sg&\u001cH/\u001a8dK\u0002\n1bY5JIN+'O^5dKV\tq\b\u0005\u0002A\u00076\t\u0011I\u0003\u0002C+\u000591/\u001a:wS\u000e,\u0017B\u0001#B\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002\u0019\rL\u0017\nZ*feZL7-\u001a\u0011\u0002\rqJg.\u001b;?)\rA%j\u0013\t\u0003\u0013\u0002i\u0011!\u0005\u0005\u0006i\u0015\u0001\rA\u000e\u0005\u0006{\u0015\u0001\raP\u0001\u0005M&tG-\u0006\u0002O#R\u0011qj\u0016\t\u0003!Fc\u0001\u0001B\u0003S\r\t\u00071KA\u0001U#\t!f\u0006\u0005\u0002\u001f+&\u0011ak\b\u0002\b\u001d>$\b.\u001b8h\u0011\u0015Af\u00011\u0001Z\u0003%!(/[4hKJLE\r\u0005\u0002[C:\u00111l\u0018\t\u00039~i\u0011!\u0018\u0006\u0003=n\ta\u0001\u0010:p_Rt\u0014B\u00011 \u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001|\u0002F\u0001\u0004f!\t1G.D\u0001h\u0015\tA\u0017.A\u0006ue\u0006t7/Y2uS>t'BA\u0016k\u0015\tYW#\u0001\u0002eE&\u0011Qn\u001a\u0002\u000b\u0013N\u0014V-\u00193P]2L\bF\u0001\u0004p!\t\u0001x/D\u0001r\u0015\t\u00118/\u0001\u0006b]:|G/\u0019;j_:T!\u0001^;\u0002\u000f5,GO]5dg*\u0011a/G\u0001\tG>$\u0017\r[1mK&\u0011\u00010\u001d\u0002\u0006)&lW\rZ\u0001\u0007GJ,\u0017\r^3\u0016\u0005mlHC\u0001?\u007f!\t\u0001V\u0010B\u0003S\u000f\t\u00071\u000bC\u0003\u0000\u000f\u0001\u0007A0A\u0004ue&<w-\u001a:)\u0005\u001dy\u0017AB;qI\u0006$X-\u0006\u0003\u0002\b\u0005-A\u0003BA\u0005\u0003\u001b\u00012\u0001UA\u0006\t\u0015\u0011\u0006B1\u0001T\u0011\u0019y\b\u00021\u0001\u0002\n!\u0012\u0001b\\\u0001\u0007I\u0016dW\r^3\u0015\t\u0005U\u00111\u0004\t\u0004=\u0005]\u0011bAA\r?\t!QK\\5u\u0011\u0015A\u0016\u00021\u0001ZQ\tIq.\u0001\bgS:$')\u001f$pY\u0012,'/\u00133\u0015\u0011\u0005\r\u0012\u0011HA\u001f\u0003\u000f\u0002R!!\n\u000269j!!a\n\u000b\u0007E\nIC\u0003\u0003\u0002,\u00055\u0012\u0001\u00023bi\u0006TA!a\f\u00022\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u00024\u0005\u0019qN]4\n\t\u0005]\u0012q\u0005\u0002\u0005!\u0006<W\r\u0003\u0004\u0002<)\u0001\r!W\u0001\tM>dG-\u001a:JI\"9\u0011q\b\u0006A\u0002\u0005\u0005\u0013!\u00048fgR,GMR8mI\u0016\u00148\u000fE\u0002\u001f\u0003\u0007J1!!\u0012 \u0005\u001d\u0011un\u001c7fC:Dq!!\u0013\u000b\u0001\u0004\tY%\u0001\u0005qC\u001e,\u0017M\u00197f!\u0011\t)#!\u0014\n\t\u0005=\u0013q\u0005\u0002\t!\u0006<W-\u00192mK\"\u0012!\"\u001a\u0015\u0003\u0015=\f\u0001D\\;nE\u0016\u0014xJ\u001a+f[Bd\u0017\r^3Ue&<w-\u001a:t)\u0011\tI&a\u0018\u0011\u0007y\tY&C\u0002\u0002^}\u00111!\u00138u\u0011\u0019\t\tg\u0003a\u00013\u0006QA/Z7qY\u0006$X-\u00133)\u0005-)\u0007FA\u0006p\u0003A1\u0017N\u001c3CsR+W\u000e\u001d7bi\u0016LE\r\u0006\u0004\u0002$\u0005-\u0014Q\u000e\u0005\u0007\u0003Cb\u0001\u0019A-\t\u000f\u0005%C\u00021\u0001\u0002L!\u0012A\"\u001a\u0015\u0003\u0019=\f!BZ5oI\nKH+\u001f9f)\u0019\t\u0019#a\u001e\u0002&\"9\u0011\u0011P\u0007A\u0002\u0005m\u0014a\u0003;sS\u001e<WM\u001d+za\u0016\u0004b!! \u0002\b\u00065e\u0002BA@\u0003\u0007s1\u0001XAA\u0013\u0005\u0001\u0013bAAC?\u00059\u0001/Y2lC\u001e,\u0017\u0002BAE\u0003\u0017\u0013A\u0001T5ti*\u0019\u0011QQ\u0010\u0011\t\u0005=\u0015\u0011U\u0007\u0003\u0003#SA!a%\u0002\u0016\u00069!/\u001a4mK\u000e$(\u0002BAL\u00033\u000b1!\u00199j\u0015\u0011\tY*!(\u0002\rAdWoZ5o\u0015\r\tyjF\u0001\tI\u0016\u0004Hn\\=ji&!\u00111UAI\u0005\u0011!\u0016\u0010]3\t\u000f\u0005%S\u00021\u0001\u0002L!\u0012Q\"\u001a\u0015\u0003\u001b=\faBZ5y!J|\u0007/\u001a:us&#7\u000f\u0006\u0003\u0002\u0016\u0005=\u0006\"B@\u000f\u0001\u0004q\u0013\u0001\u00064jq6\u000b\u0007\u000f]3e!J|\u0007/\u001a:us&#7\u000f\u0006\u0003\u0002\u0016\u0005U\u0006BB@\u0010\u0001\u0004\t9\f\u0005\u0003\u0002:\u0006}VBAA^\u0015\r\tilE\u0001\fKZ,g\u000e^0cCN,G-\u0003\u0003\u0002B\u0006m&!E#wK:$()Y:fIR\u0013\u0018nZ4fe\"\u001a\u0001!!2\u0011\u0007\u0019\f9-C\u0002\u0002J\u001e\u0014q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class SqlTriggerRepository
implements TriggerRepository {
    private final TriggerPersistence triggerPersistence;
    private final CiIdService ciIdService;
    private Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors;

    public void registerPersistenceInterceptor(PersistenceInterceptor<Trigger> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public Seq<PersistenceInterceptor<Trigger>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(Seq<PersistenceInterceptor<Trigger>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public TriggerPersistence triggerPersistence() {
        return this.triggerPersistence;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    @IsReadOnly
    public <T extends Trigger> T find(String triggerId) {
        Option maybeTrigger = this.triggerPersistence().findById(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId))));
        return (T)((Trigger)maybeTrigger.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Repository entity [%s] not found", new Object[]{triggerId});
        }));
    }

    @Timed
    public <T extends Trigger> T create(T trigger) {
        if (!Ids.isTriggerId((String)trigger.getId())) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Trigger Id [").append(trigger.getId()).append("] is not valid").toString());
        }
        this.fixPropertyIds(trigger);
        this.interceptCreate((ConfigurationItem)trigger);
        this.triggerPersistence().insert(trigger);
        this.afterCreate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public <T extends Trigger> T update(T trigger) {
        this.fixPropertyIds(trigger);
        this.interceptUpdate((ConfigurationItem)trigger);
        this.triggerPersistence().update(trigger);
        this.afterUpdate((ConfigurationItem)trigger);
        return trigger;
    }

    @Timed
    public void delete(String triggerId) {
        this.interceptDelete(triggerId);
        this.triggerPersistence().delete(Ids.getFolderlessId((String)CiId.RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(triggerId))));
        this.afterDelete(triggerId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByFolderId(String folderId, boolean nestedFolders, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setFolderId(folderId);
        filter.setNestedFolders(Predef$.MODULE$.boolean2Boolean(nestedFolders));
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public int numberOfTemplateTriggers(String templateId) {
        return this.triggerPersistence().numberOfTemplateTriggers(templateId);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByTemplateId(String templateId, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTemplateId(templateId);
        return this.triggerPersistence().findBy(filter, pageable);
    }

    @Timed
    @IsReadOnly
    public Page<Trigger> findByType(List<Type> triggerType, Pageable pageable) {
        TriggerFilters filter = new TriggerFilters();
        filter.setTriggerType((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)triggerType.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), List$.MODULE$.canBuildFrom())).asJava());
        return this.triggerPersistence().findBy(filter, pageable);
    }

    private void fixPropertyIds(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            VariablePersistenceHelper$.MODULE$.fixUpVariableIds(releaseTrigger.getId(), releaseTrigger.getVariables(), this.ciIdService());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (trigger2 instanceof EventBasedTrigger) {
            EventBasedTrigger eventBasedTrigger = (EventBasedTrigger)trigger2;
            this.fixMappedPropertyIds(eventBasedTrigger);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void fixMappedPropertyIds(EventBasedTrigger trigger) {
        Set ids = Set$.MODULE$.empty();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(trigger.getMappedProperties()).asScala()).foreach((Function1 & Serializable & scala.Serializable)mappedProperty -> {
            SqlTriggerRepository.$anonfun$fixMappedPropertyIds$1(this, trigger, ids, mappedProperty);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$fixMappedPropertyIds$1(SqlTriggerRepository $this, EventBasedTrigger trigger$1, Set ids$1, MappedProperty mappedProperty) {
        if (mappedProperty.getId() == null || mappedProperty.getId().isEmpty()) {
            String id = $this.ciIdService().getUniqueId(Type.valueOf(MappedProperty.class), trigger$1.getId(), ids$1.toSet());
            ids$1.add((Object)id);
            mappedProperty.setId(id);
        } else {
            mappedProperty.setId(new StringBuilder(1).append(trigger$1.getId()).append("/").append(Ids.getName((String)mappedProperty.getId())).toString());
        }
    }

    public SqlTriggerRepository(TriggerPersistence triggerPersistence, CiIdService ciIdService) {
        this.triggerPersistence = triggerPersistence;
        this.ciIdService = ciIdService;
        InterceptedRepository.$init$((InterceptedRepository)this);
    }
}

