/*
 * Decompiled with CFR 0.152.
 */
package net.conjur.api;

public class Credentials {
    private static final String CONJUR_AUTHN_LOGIN_PROPERTY = "CONJUR_AUTHN_LOGIN";
    private static final String CONJUR_AUTHN_API_KEY_PROPERTY = "CONJUR_AUTHN_API_KEY";
    private String username;
    private String password;

    public Credentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public static Credentials fromSystemProperties() {
        String login = System.getProperty(CONJUR_AUTHN_LOGIN_PROPERTY);
        String apiKey = System.getProperty(CONJUR_AUTHN_API_KEY_PROPERTY);
        return new Credentials(login, apiKey);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return this.username + ":" + this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Credentials)) {
            return false;
        }
        Credentials that = (Credentials)o;
        if (!this.password.equals(that.getPassword())) {
            return false;
        }
        return this.username.equals(that.getUsername());
    }

    public int hashCode() {
        int result = this.username.hashCode();
        result = 31 * result + this.password.hashCode();
        return result;
    }
}

