/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider;

import java.net.URI;
import java.util.List;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.message.JmsMessageFactory;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsConsumerId;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsTransactionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.Provider;
import org.apache.qpid.jms.provider.ProviderConstants;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.ProviderFuture;
import org.apache.qpid.jms.provider.ProviderListener;
import org.apache.qpid.jms.provider.ProviderSynchronization;

public class ProviderWrapper<E extends Provider>
implements Provider,
ProviderListener {
    protected final E next;
    protected ProviderListener listener;

    public ProviderWrapper(E next) {
        this.next = next;
        this.next.setProviderListener(this);
    }

    @Override
    public void connect(JmsConnectionInfo connectionInfo) throws ProviderException {
        this.next.connect(connectionInfo);
    }

    @Override
    public void start() throws ProviderException, IllegalStateException {
        if (this.listener == null) {
            throw new IllegalStateException("Cannot start with null ProviderListener");
        }
        this.next.start();
    }

    @Override
    public void close() {
        this.next.close();
    }

    @Override
    public URI getRemoteURI() {
        return this.next.getRemoteURI();
    }

    @Override
    public List<URI> getAlternateURIs() {
        return this.next.getAlternateURIs();
    }

    @Override
    public void create(JmsResource resource, AsyncResult request) throws ProviderException {
        this.next.create(resource, request);
    }

    @Override
    public void start(JmsResource resource, AsyncResult request) throws ProviderException {
        this.next.start(resource, request);
    }

    @Override
    public void stop(JmsResource resource, AsyncResult request) throws ProviderException {
        this.next.stop(resource, request);
    }

    @Override
    public void destroy(JmsResource resourceId, AsyncResult request) throws ProviderException {
        this.next.destroy(resourceId, request);
    }

    @Override
    public void send(JmsOutboundMessageDispatch envelope, AsyncResult request) throws ProviderException {
        this.next.send(envelope, request);
    }

    @Override
    public void acknowledge(JmsSessionId sessionId, ProviderConstants.ACK_TYPE ackType, AsyncResult request) throws ProviderException {
        this.next.acknowledge(sessionId, ackType, request);
    }

    @Override
    public void acknowledge(JmsInboundMessageDispatch envelope, ProviderConstants.ACK_TYPE ackType, AsyncResult request) throws ProviderException {
        this.next.acknowledge(envelope, ackType, request);
    }

    @Override
    public void commit(JmsTransactionInfo transactionInfo, JmsTransactionInfo nextTransactionInfo, AsyncResult request) throws ProviderException {
        this.next.commit(transactionInfo, nextTransactionInfo, request);
    }

    @Override
    public void rollback(JmsTransactionInfo transactionInfo, JmsTransactionInfo nextTransactionInfo, AsyncResult request) throws ProviderException {
        this.next.rollback(transactionInfo, nextTransactionInfo, request);
    }

    @Override
    public void recover(JmsSessionId sessionId, AsyncResult request) throws ProviderException {
        this.next.recover(sessionId, request);
    }

    @Override
    public void unsubscribe(String subscription, AsyncResult request) throws ProviderException {
        this.next.unsubscribe(subscription, request);
    }

    @Override
    public void pull(JmsConsumerId consumerId, long timeout, AsyncResult request) throws ProviderException {
        this.next.pull(consumerId, timeout, request);
    }

    @Override
    public JmsMessageFactory getMessageFactory() {
        return this.next.getMessageFactory();
    }

    @Override
    public ProviderFuture newProviderFuture() {
        return this.next.newProviderFuture();
    }

    @Override
    public ProviderFuture newProviderFuture(ProviderSynchronization synchronization) {
        return this.next.newProviderFuture(synchronization);
    }

    @Override
    public void setProviderListener(ProviderListener listener) {
        this.listener = listener;
    }

    @Override
    public ProviderListener getProviderListener() {
        return this.listener;
    }

    @Override
    public void onInboundMessage(JmsInboundMessageDispatch envelope) {
        this.listener.onInboundMessage(envelope);
    }

    @Override
    public void onCompletedMessageSend(JmsOutboundMessageDispatch envelope) {
        this.listener.onCompletedMessageSend(envelope);
    }

    @Override
    public void onFailedMessageSend(JmsOutboundMessageDispatch envelope, ProviderException cause) {
        this.listener.onFailedMessageSend(envelope, cause);
    }

    @Override
    public void onConnectionInterrupted(URI remoteURI) {
        this.listener.onConnectionInterrupted(remoteURI);
    }

    @Override
    public void onConnectionRecovery(Provider provider) throws Exception {
        this.listener.onConnectionRecovery(provider);
    }

    @Override
    public void onConnectionRecovered(Provider provider) throws Exception {
        this.listener.onConnectionRecovered(provider);
    }

    @Override
    public void onConnectionRestored(URI remoteURI) {
        this.listener.onConnectionRestored(remoteURI);
    }

    @Override
    public void onConnectionEstablished(URI remoteURI) {
        this.listener.onConnectionEstablished(this.next.getRemoteURI());
    }

    @Override
    public void onConnectionFailure(ProviderException ex) {
        this.listener.onConnectionFailure(ex);
    }

    @Override
    public void onResourceClosed(JmsResource resource, ProviderException cause) {
        this.listener.onResourceClosed(resource, cause);
    }

    @Override
    public void onProviderException(ProviderException cause) {
        this.listener.onProviderException(cause);
    }

    public Provider getNext() {
        return this.next;
    }
}

