/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.versioning.scm.ScmConnectorService;
import com.xebialabs.xlrelease.versioning.scm.ScmTemplateToBlobsConverter;
import com.xebialabs.xlrelease.versioning.scm.connector.Blobs;
import com.xebialabs.xlrelease.versioning.scm.connector.ScmConnector;
import com.xebialabs.xlrelease.versioning.scm.connector.ScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo$;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001i3AAB\u0004\u0001%!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0011!\u0011\u0003A!A!\u0002\u0013\u0019\u0003\"B\u0015\u0001\t\u0003Q\u0003\"\u0002 \u0001\t\u0003y$!G*d[R+W\u000e\u001d7bi\u0016\u001cFo\u001c:bO\u0016\u001cVM\u001d<jG\u0016T!\u0001C\u0005\u0002\u0007M\u001cWN\u0003\u0002\u000b\u0017\u0005Qa/\u001a:tS>t\u0017N\\4\u000b\u00051i\u0011!\u0003=me\u0016dW-Y:f\u0015\tqq\"A\u0005yK\nL\u0017\r\\1cg*\t\u0001#A\u0002d_6\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\f1c]2n\u0007>tg.Z2u_J\u001cVM\u001d<jG\u0016\u0004\"a\u0007\u000f\u000e\u0003\u001dI!!H\u0004\u0003'M\u001bWnQ8o]\u0016\u001cGo\u001c:TKJ4\u0018nY3\u00027M\u001cW\u000eV3na2\fG/\u001a+p\u00052|'m]\"p]Z,'\u000f^3s!\tY\u0002%\u0003\u0002\"\u000f\tY2kY7UK6\u0004H.\u0019;f)>\u0014En\u001c2t\u0007>tg/\u001a:uKJ\faB]3mK\u0006\u001cXmU3sm&\u001cW\r\u0005\u0002%O5\tQE\u0003\u0002'\u0017\u000591/\u001a:wS\u000e,\u0017B\u0001\u0015&\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtD\u0003B\u0016-[9\u0002\"a\u0007\u0001\t\u000be!\u0001\u0019\u0001\u000e\t\u000by!\u0001\u0019A\u0010\t\u000b\t\"\u0001\u0019A\u0012)\u0005\u0011\u0001\u0004CA\u0019=\u001b\u0005\u0011$BA\u001a5\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003kY\nqAZ1di>\u0014\u0018P\u0003\u00028q\u0005)!-Z1og*\u0011\u0011HO\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t1(A\u0002pe\u001eL!!\u0010\u001a\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001E2sK\u0006$XMT3x-\u0016\u00148/[8o)\u0015\u00015*T(R!\t\t\u0005J\u0004\u0002C\rB\u00111)F\u0007\u0002\t*\u0011Q)E\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d+\u0012A\u0002)sK\u0012,g-\u0003\u0002J\u0015\n11\u000b\u001e:j]\u001eT!aR\u000b\t\u000b1+\u0001\u0019\u0001!\u0002\u0015Q,W\u000e\u001d7bi\u0016LE\rC\u0003O\u000b\u0001\u0007\u0001)A\u0004wKJ\u001c\u0018n\u001c8\t\u000bA+\u0001\u0019\u0001!\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\u0005\u0006%\u0016\u0001\r\u0001Q\u0001\u0005kN,'\u000f\u000b\u0002\u0001)B\u0011Q\u000bW\u0007\u0002-*\u0011q\u000bO\u0001\u000bgR,'/Z8usB,\u0017BA-W\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class ScmTemplateStorageService {
    private final ScmConnectorService scmConnectorService;
    private final ScmTemplateToBlobsConverter scmTemplateToBlobsConverter;
    private final ReleaseService releaseService;

    public String createNewVersion(String templateId, String version, String description, String user) {
        Release template = this.releaseService.findById(templateId);
        ScmConnectorConfig scmConfiguration = this.scmConnectorService.findScmConnectorConfig(template.getId());
        ScmConnector scmConnector = scmConfiguration.getConnector();
        Blobs blobs = this.scmTemplateToBlobsConverter.convertTemplate(template);
        String identifier = scmConnector.getIdentifier(blobs);
        ValidatedCommitInfo commitInfo = (ValidatedCommitInfo)ValidatedCommitInfo$.MODULE$.create(version, description, identifier).get();
        scmConnector.createNewVersion(blobs, commitInfo, user).get();
        return commitInfo.tag().refName();
    }

    @Autowired
    public ScmTemplateStorageService(ScmConnectorService scmConnectorService, ScmTemplateToBlobsConverter scmTemplateToBlobsConverter, ReleaseService releaseService) {
        this.scmConnectorService = scmConnectorService;
        this.scmTemplateToBlobsConverter = scmTemplateToBlobsConverter;
        this.releaseService = releaseService;
    }
}

