/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.xlrelease.utils.SensitiveValueScrubber;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionOutputWriter
extends Writer {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionOutputWriter.class);
    private final SensitiveValueScrubber scrubber;
    protected Writer out;
    protected OverthereExecutionOutputHandler[] outputHandlers;

    public ExecutionOutputWriter(SensitiveValueScrubber scrubber, Writer out, OverthereExecutionOutputHandler ... outputHandlers) {
        super((Object)out);
        this.scrubber = scrubber;
        this.out = out;
        this.outputHandlers = outputHandlers;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len == 1) {
            this.out.write(cbuf, off, len);
            this.notifyChar(cbuf[off]);
        } else {
            String line = String.valueOf(cbuf, off, len);
            String cleanLine = this.scrubber.scrubValues(line);
            this.out.write(cleanLine);
            this.notifyLine(cleanLine);
        }
    }

    private void notifyChar(char c) {
        for (OverthereExecutionOutputHandler outputHandler : this.outputHandlers) {
            outputHandler.handleChar(c);
        }
    }

    protected void notifyLine(String line) {
        for (OverthereExecutionOutputHandler outputHandler : this.outputHandlers) {
            outputHandler.handleLine(line);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.closeHandlers();
        this.out.close();
    }

    protected void closeHandlers() throws IOException {
        logger.debug("Closing {} output handlers", (Object)this.outputHandlers.length);
        for (OverthereExecutionOutputHandler outputHandler : this.outputHandlers) {
            if (!(outputHandler instanceof Closeable)) continue;
            ((Closeable)outputHandler).close();
        }
    }

    public String toString() {
        return this.out.toString();
    }
}

