/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.panel;

import com.jeta.forms.defaults.DefaultInitializer;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.FormAccessor;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.gui.form.FormIterator;
import com.jeta.forms.gui.formmgr.FormManagerUtils;
import com.jeta.open.gui.framework.JETAPanel;
import com.jeta.open.i18n.I18N;
import com.jeta.open.i18n.I18NUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;

public class FormPanel
extends JETAPanel {
    private HashMap m_user_objects = new HashMap();
    private FormComponent m_form_comp;
    private FocusTraversalPolicy m_focus_policy;
    private boolean m_policy_set = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormPanel(String string) {
        DefaultInitializer.initialize();
        boolean bl = FormUtils.isDesignMode();
        try {
            FormUtils.setDesignMode(false);
            FormComponent formComponent = FormManagerUtils.openPackagedForm(string);
            formComponent.postInitialize(this);
            this.m_form_comp = formComponent;
            this.addForm(formComponent, new BorderLayout(), "Center");
        }
        catch (Exception exception) {
            BoxLayout boxLayout = new BoxLayout(this, 1);
            this.setLayout(boxLayout);
            JLabel jLabel = new JLabel(I18N.getLocalizedMessage("Error:"));
            jLabel.setForeground(Color.red);
            jLabel.setAlignmentX(0.0f);
            JLabel jLabel2 = new JLabel(string);
            jLabel2.setForeground(Color.red);
            jLabel2.setAlignmentX(0.0f);
            jLabel2.setToolTipText(string);
            this.add(jLabel);
            this.add(jLabel2);
            this.add(Box.createVerticalStrut(5));
        }
        finally {
            FormUtils.setDesignMode(bl);
        }
    }

    public FormPanel(InputStream inputStream) throws FormException {
        try {
            FormComponent formComponent;
            DefaultInitializer.initialize();
            this.m_form_comp = formComponent = FormManagerUtils.openForm(inputStream);
            this.setLayout(new BorderLayout());
            this.add((Component)formComponent, "Center");
        }
        catch (Exception exception) {
            if (exception instanceof FormException) {
                throw (FormException)exception;
            }
            throw new FormException("FormPane failed to load form (.jfrm) from InputStream", exception);
        }
    }

    public FormPanel(FormComponent formComponent) {
        DefaultInitializer.initialize();
        this.setLayout(new BorderLayout());
        this.add((Component)formComponent, "Center");
        formComponent.postInitialize(this);
        this.m_form_comp = formComponent;
    }

    protected void addForm(FormComponent formComponent, LayoutManager layoutManager, Object object) {
        this.setLayout(layoutManager);
        this.add((Component)formComponent, object);
    }

    public Iterator beanIterator(boolean bl) {
        return new FormIterator(this.getFormAccessor(), bl);
    }

    public Object get(String string) {
        if (string == null) {
            return null;
        }
        return this.m_user_objects.get(string);
    }

    public Container getFormContainer() {
        return this.m_form_comp.getChildView().getFormContainer();
    }

    public FormAccessor getFormAccessor() {
        return this.m_form_comp.getChildView().getFormAccessor();
    }

    public FormAccessor getFormAccessor(String string) {
        Component component = this.getComponentByName(string);
        if (component instanceof FormAccessor) {
            return (FormAccessor)((Object)component);
        }
        return null;
    }

    public void put(String string, Object object) {
        if (string != null) {
            this.m_user_objects.put(string, object);
        }
    }

    public void revalidate() {
        if (this.m_form_comp != null) {
            this.m_form_comp.revalidate();
        }
        super.revalidate();
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        I18NUtils.applyComponentOrientation(this, componentOrientation);
        super.applyComponentOrientation(componentOrientation);
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        super.setFocusTraversalPolicy(focusTraversalPolicy);
    }

    public void updateFocusPolicy() {
    }

    public void updateUI() {
        super.updateUI();
        if (this.m_form_comp != null) {
            this.m_form_comp.updateUI();
        }
    }
}

