/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.internal.annotations.Private;
import org.jparsec.internal.util.Lists;

public final class OperatorTable<T> {
    private final List<Operator> ops = Lists.arrayList();

    public OperatorTable<T> prefix(Parser<? extends Function<? super T, ? extends T>> parser, int precedence) {
        this.ops.add(new Operator(parser, precedence, Associativity.PREFIX));
        return this;
    }

    public OperatorTable<T> postfix(Parser<? extends Function<? super T, ? extends T>> parser, int precedence) {
        this.ops.add(new Operator(parser, precedence, Associativity.POSTFIX));
        return this;
    }

    public OperatorTable<T> infixl(Parser<? extends BiFunction<? super T, ? super T, ? extends T>> parser, int precedence) {
        this.ops.add(new Operator(parser, precedence, Associativity.LASSOC));
        return this;
    }

    public OperatorTable<T> infixr(Parser<? extends BiFunction<? super T, ? super T, ? extends T>> parser, int precedence) {
        this.ops.add(new Operator(parser, precedence, Associativity.RASSOC));
        return this;
    }

    public OperatorTable<T> infixn(Parser<? extends BiFunction<? super T, ? super T, ? extends T>> parser, int precedence) {
        this.ops.add(new Operator(parser, precedence, Associativity.NASSOC));
        return this;
    }

    public Parser<T> build(Parser<? extends T> operand) {
        return OperatorTable.buildExpressionParser(operand, this.operators());
    }

    @Private
    Operator[] operators() {
        Collections.sort(this.ops);
        return this.ops.toArray(new Operator[this.ops.size()]);
    }

    static <T> Parser<T> buildExpressionParser(Parser<? extends T> term, Operator ... ops) {
        if (ops.length == 0) {
            return term.cast();
        }
        int begin = 0;
        int precedence = ops[0].precedence;
        Associativity associativity = ops[0].associativity;
        int end = 0;
        Parser ret = term.cast();
        for (int i = 1; i < ops.length; ++i) {
            Operator op = ops[i];
            end = i;
            if (op.precedence == precedence && op.associativity == associativity) continue;
            end = i;
            Parser<?> p = OperatorTable.slice(ops, begin, end);
            ret = OperatorTable.build(p, associativity, ret);
            begin = i;
            precedence = ops[i].precedence;
            associativity = ops[i].associativity;
        }
        if (end != ops.length) {
            end = ops.length;
            associativity = ops[begin].associativity;
            Parser<?> p = OperatorTable.slice(ops, begin, end);
            ret = OperatorTable.build(p, associativity, ret);
        }
        return ret;
    }

    private static Parser<?> slice(Operator[] ops, int begin, int end) {
        Parser[] ps = new Parser[end - begin];
        for (int i = 0; i < ps.length; ++i) {
            ps[i] = ops[i + begin].op;
        }
        return Parsers.or(ps);
    }

    private static <T> Parser<T> build(Parser op, Associativity associativity, Parser<T> operand) {
        switch (associativity) {
            case PREFIX: {
                return operand.prefix(op);
            }
            case POSTFIX: {
                return operand.postfix(op);
            }
            case LASSOC: {
                return operand.infixl(op);
            }
            case RASSOC: {
                return operand.infixr(op);
            }
            case NASSOC: {
                return operand.infixn(op);
            }
        }
        throw new AssertionError();
    }

    static final class Operator
    implements Comparable<Operator> {
        final Parser<?> op;
        final int precedence;
        final Associativity associativity;

        Operator(Parser<?> op, int precedence, Associativity associativity) {
            this.op = op;
            this.precedence = precedence;
            this.associativity = associativity;
        }

        @Override
        public int compareTo(Operator that) {
            if (this.precedence > that.precedence) {
                return -1;
            }
            if (this.precedence < that.precedence) {
                return 1;
            }
            return this.associativity.compareTo(that.associativity);
        }
    }

    static enum Associativity {
        PREFIX,
        POSTFIX,
        LASSOC,
        NASSOC,
        RASSOC;

    }
}

