/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.appdba.sqlplus.change.exception.DaticalSpErrorLogException;
import com.datical.liquibase.ext.config.SqlplusConfiguration;
import com.datical.liquibase.ext.config.SqlplusConfiguration$ConfigurationKeys;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import com.datical.liquibase.ext.tools.NativeToolFileCreator;
import com.datical.liquibase.ext.tools.NativeToolFileCreator$FileTypeEnum;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.logging.Logger;
import liquibase.resource.InputStreamList;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class SqlPlusRunner
extends ExecuteShellCommandChange {
    private ChangeSet changeSet;
    private Sql[] sqlStrings;
    private File outFile = null;
    private File spoolFile = null;
    private Boolean keepTempFile;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private Boolean tempOverwrite;
    private boolean ignoreSpErrorLog = false;
    private static final String DATICAL_SPERRORLOG = "DATICAL_SPERRORLOG";
    private String errorLoggingIdentifier;

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    public SqlPlusRunner() {
    }

    public SqlPlusRunner(ChangeSet changeSet, Sql[] sqlArray, boolean bl2) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlArray;
        this.setTimeout("1800");
        this.errorLoggingIdentifier = UUID.randomUUID().toString();
        this.ignoreSpErrorLog = bl2;
    }

    @Override
    protected List<String> createFinalCommandArray(Database object) {
        this.loadSqlplusProperties();
        List<String> list = super.createFinalCommandArray((Database)object);
        try {
            this.writeSqlStrings((Database)object);
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException(exception);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = SqlplusConfiguration.TEMP_KEEP.getCurrentValue();
        }
        if (!this.args.isEmpty()) {
            list.addAll(Collections.unmodifiableList(this.args));
        }
        if (!list.contains("-L")) {
            list.add("-L");
        }
        object = this.buildConnectionString((Database)object);
        list.add((String)object);
        if (this.outFile != null) {
            list.add("@" + this.outFile.getAbsolutePath());
        }
        object = StringUtil.join(list, " ").replaceAll("^(.*?) (.*?)/\"(.*)\"@(.)", "$1 ******/******@$4");
        Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS command:\n".concat(String.valueOf(object)));
        return list;
    }

    @Override
    protected void processResult(int n2, String string3, String string2, Database database) {
        try {
            List<?> list = this.processResultFromDaticalSpErrorLog(database);
            StringBuilder stringBuilder = new StringBuilder();
            if (list == null || list.isEmpty()) {
                super.processResult(n2, string3, string2, database);
                return;
            }
            stringBuilder.append("Error executing change set '");
            stringBuilder.append(this.changeSet.toString());
            stringBuilder.append("'\n");
            for (String string3 : list) {
                stringBuilder.append(string3.toString().concat("\n"));
            }
            throw new DaticalSpErrorLogException(stringBuilder.toString());
        }
        finally {
            this.dropDaticalSpErrorLog(database);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeCommand(Database object) {
        block17: {
            try {
                this.createDaticalSpErrorLogIfNeeded((Database)object);
            }
            catch (DaticalSpErrorLogException daticalSpErrorLogException) {
                Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning(daticalSpErrorLogException.getMessage());
            }
            try {
                this.finalCommandArray = this.createFinalCommandArray((Database)object);
                super.executeCommand((Database)object);
                if (this.spoolFile == null) break block17;
            }
            catch (TimeoutException timeoutException) {
                try {
                    this.ignoreSpErrorLog = true;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.processResult(0, null, null, (Database)object);
                    object = timeoutException.getMessage() + System.lineSeparator() + System.lineSeparator() + "The sqlplus executable failed to return a response within the configured timeout.\nPlease check liquibase.sqlcmd.timeout specified in liquibase.sqlplus.conf file, the LIQUIBASE_SQLPLUS_TIMEOUT Enviroment variable, or other config locations.\nLearn more at https://docs.liquibase.com/concepts/advanced/runwith.html." + System.lineSeparator();
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object)));
                    Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning((String)object);
                    throw new LiquibaseException(timeoutException);
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw illegalArgumentException;
                    }
                    catch (Exception exception) {
                        throw new LiquibaseException(exception);
                    }
                }
                catch (Throwable throwable) {
                    if (this.spoolFile != null) {
                        try {
                            this.captureSpoolOutputInLog();
                        }
                        catch (IOException iOException) {
                            Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS was unable to read the spool file located at " + this.spoolFile.getAbsolutePath());
                        }
                    }
                    if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                        Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS run script can be located at: " + this.outFile.getAbsolutePath());
                    }
                    throw throwable;
                }
            }
            try {
                this.captureSpoolOutputInLog();
            }
            catch (IOException iOException) {
                Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS was unable to read the spool file located at " + this.spoolFile.getAbsolutePath());
            }
        }
        if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
            Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS run script can be located at: " + this.outFile.getAbsolutePath());
            return;
        }
    }

    private void createDaticalSpErrorLogIfNeeded(Database object) {
        if (this.ignoreSpErrorLog) {
            return;
        }
        String string = this.getLiquibaseCatalogName((Database)object);
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase((Database)object);
        try {
            object = String.format("SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER='%s' AND TABLE_NAME='%s'", string, DATICAL_SPERRORLOG);
            object = jdbcExecutor.queryForList((SqlStatement)new RawSqlStatement((String)object), String.class);
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning(databaseException.getMessage());
            throw new DaticalSpErrorLogException(String.format("Can't check if table: %s exists due to an error", DATICAL_SPERRORLOG), databaseException);
        }
        if (object != null && !object.isEmpty()) {
            try {
                jdbcExecutor.execute(new RawSqlStatement(String.format("DELETE FROM %s.%s", string, DATICAL_SPERRORLOG)));
            }
            catch (DatabaseException databaseException) {
                Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to clear rows from table: %s.%s due to an error. Table is locked or the user has insufficient privileges", string, DATICAL_SPERRORLOG));
            }
        }
        try {
            object = String.format("CREATE TABLE %s.%s (username VARCHAR(256), timestamp TIMESTAMP, script VARCHAR(256), identifier VARCHAR(256), message CLOB, statement CLOB)", string, DATICAL_SPERRORLOG);
            jdbcExecutor.execute(new RawSqlStatement((String)object));
            return;
        }
        catch (DatabaseException databaseException) {
            if (databaseException.getMessage().contains("insufficient privileges")) {
                Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to create table: %s.%s due to an error. Insufficient privileges", string, DATICAL_SPERRORLOG));
                return;
            }
            Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to create table: %s.%s due to an error. The table may already exist or you may not have privileges to create it.", string, DATICAL_SPERRORLOG));
            return;
        }
    }

    private void dropDaticalSpErrorLog(Database database) {
        if (this.ignoreSpErrorLog) {
            return;
        }
        String string = this.getLiquibaseCatalogName(database);
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase(database);
        try {
            jdbcExecutor.execute(new RawSqlStatement(String.format("DROP TABLE %s.%s", string, DATICAL_SPERRORLOG)));
            return;
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to drop table: %s.%s  No action is required.To prevent this message in the future ensure that the user has the DROP TABLE privilege. ", string, DATICAL_SPERRORLOG));
            return;
        }
    }

    private String getLiquibaseCatalogName(Database database) {
        return "\"" + database.getLiquibaseCatalogName() + "\"";
    }

    private List<?> processResultFromDaticalSpErrorLog(Database object) {
        if (this.ignoreSpErrorLog) {
            return Collections.emptyList();
        }
        String string = this.getLiquibaseCatalogName((Database)object);
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase((Database)object);
        object = null;
        try {
            String string2 = String.format("select CONCAT(CONCAT('Query: ', STATEMENT), CONCAT('>>> Has an error: ', MESSAGE)) as ERROR_MESSAGE from %s.%s WHERE IDENTIFIER='%s'", string, DATICAL_SPERRORLOG, this.errorLoggingIdentifier);
            object = jdbcExecutor.queryForList((SqlStatement)new RawSqlStatement(string2), String.class);
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to query table: %s.%s  No action is required.To prevent this message in the future ensure that the user has the correct privileges. ", string, DATICAL_SPERRORLOG));
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSqlplusProperties() {
        boolean bl2 = StringUtil.trimToEmpty(System.getProperties().getProperty("os.name")).toLowerCase().startsWith("windows");
        this.setExecutable("sqlplus");
        if (bl2) {
            this.setExecutable("sqlplus.exe");
        }
        File file = null;
        Properties properties = new Properties();
        Object object = SqlplusConfiguration.PATH.getCurrentValue();
        if (object != null) {
            file = new File((String)object);
        }
        object = SqlplusConfiguration.TIMEOUT.getCurrentValue();
        String string = SqlplusConfiguration.ARGS.getCurrentValue();
        this.assignPropertiesFromConfiguration();
        Object object2 = Scope.getCurrentScope().getResourceAccessor();
        InputStream inputStream = null;
        try {
            object2 = object2.openStreams(null, "liquibase.sqlplus.conf");
            Throwable throwable = null;
            try {
                if (object2 == null || ((InputStreamList)object2).size() == 0) {
                    Scope.getCurrentScope().getLog(this.getClass()).info("No configuration file named 'liquibase.sqlplus.conf' found.");
                } else {
                    String string2 = ((InputStreamList)object2).getURIs().get(0).getRawPath();
                    Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS configuration file located at '" + string2 + "'.");
                    inputStream = ((InputStreamList)object2).iterator().next();
                    properties.load(inputStream);
                    if (properties.containsKey("liquibase.sqlplus.path")) {
                        file = new File(properties.getProperty("liquibase.sqlplus.path"));
                    }
                    if (properties.containsKey("liquibase.sqlplus.timeout")) {
                        object = this.determineTimeout(properties);
                    }
                    if (properties.containsKey("liquibase.sqlplus.args")) {
                        string = properties.getProperty("liquibase.sqlplus.args");
                    }
                    this.overrideWithFileProperties(properties);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((InputStreamList)object2).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((InputStreamList)object2).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            try {
                throw new UnexpectedLiquibaseException(iOException);
            }
            catch (Throwable throwable5) {
                try {
                    if (inputStream == null) throw throwable5;
                    inputStream.close();
                    throw throwable5;
                }
                catch (Exception exception) {}
                throw throwable5;
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        this.handleSqlplusExecutable(file);
        this.handleTimeout((Integer)object);
        this.handleArgs(string);
        this.logProperties();
    }

    private int determineTimeout(Properties object) {
        if ((object = ((Properties)object).getProperty("liquibase.sqlplus.timeout")) == null) {
            return -1;
        }
        try {
            return Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException("Invalid value '" + (String)object + "' for property 'liquibase.sqlplus.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com");
        }
    }

    private void logProperties() {
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlplus' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlplus' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempOverwrite != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlplus' with a keep temp file overwrite value of '" + this.tempOverwrite + "'");
        }
        if (this.tempName != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlplus' with a keep temp file name value of '" + this.tempName + "'");
        }
    }

    private void handleArgs(String string) {
        if (string != null) {
            string = string.trim();
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlplus' with a extra arguments of '" + string + "'");
            this.args = StringUtil.splitAndTrim(string, " ");
        }
    }

    private void handleTimeout(Integer n2) {
        if (n2 != null) {
            this.validateTimeout(n2);
            this.setTimeout(String.valueOf(n2));
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'sqlplus' with a timeout of '" + n2 + "'");
        }
    }

    private void handleSqlplusExecutable(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            throw new UnexpectedLiquibaseException("The executable for the native executor 'sqlplus' cannot be found at path '" + file.getAbsolutePath() + "' as specified in the liquibase.sqlplus.conf file.\nPlease specify the correct path for the 'sqlplus' executable, or modify your PATH so that it can be located.  Learn more at http://docs.liquibase.com.");
        }
        if (!file.canExecute()) {
            throw new UnexpectedLiquibaseException("The 'sqlplus' executable in the liquibase.sqlplus.conf file at " + file.getAbsolutePath() + " cannot be executed");
        }
        try {
            this.setExecutable(file.getCanonicalPath());
            Scope.getCurrentScope().getLog(this.getClass()).info("Using the 'sqlplus' executable located at:  '" + file.getCanonicalPath() + "'");
            return;
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException);
        }
    }

    private void overrideWithFileProperties(Properties properties) {
        if (properties.containsKey("liquibase.sqlplus.keep.temp")) {
            this.keepTempFile = this.getBooleanFromProperties(properties, "liquibase.sqlplus.keep.temp");
        }
        if (properties.containsKey(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"))) {
            this.tempName = properties.getProperty(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"));
        }
        if (properties.containsKey(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"))) {
            this.tempOverwrite = this.getBooleanFromProperties(properties, SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"));
        }
        if (properties.containsKey(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"))) {
            this.tempPath = properties.getProperty(SqlplusConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"));
        }
    }

    private void assignPropertiesFromConfiguration() {
        this.tempName = SqlplusConfiguration.TEMP_NAME.getCurrentValue();
        this.tempPath = SqlplusConfiguration.TEMP_PATH.getCurrentValue();
        this.tempOverwrite = SqlplusConfiguration.TEMP_OVERWRITE.getCurrentValue();
        if (!SqlplusConfiguration.TEMP_KEEP.getCurrentConfiguredValue().wasDefaultValueUsed()) {
            this.keepTempFile = SqlplusConfiguration.TEMP_KEEP.getCurrentValue();
        }
    }

    private Boolean getBooleanFromProperties(Properties object, String string) {
        if (!((object = ((Properties)object).getProperty(string)) == null || ((String)object).isEmpty() || ((String)(object = ((String)object).toLowerCase())).equals("true") || ((String)object).equals("false"))) {
            throw new UnexpectedLiquibaseException("Invalid value '" + (String)object + "' for property '" + string + "'. Must be 'true' or 'false'.  Learn more at https://docs.liquibase.com");
        }
        return Boolean.valueOf((String)object);
    }

    private void validateTimeout(Integer n2) {
        if (n2 == null) {
            return;
        }
        if (n2.equals(-1)) {
            return;
        }
        if (n2.equals(0)) {
            throw new UnexpectedLiquibaseException("Invalid timeout value of 0");
        }
        if (n2 <= 0) {
            throw new UnexpectedLiquibaseException("Invalid timeout value of '" + n2 + "'");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSqlStrings(Database object) {
        BufferedWriter bufferedWriter;
        block18: {
            if (this.sqlStrings == null) return;
            if (this.sqlStrings.length == 0) {
                return;
            }
            Scope.getCurrentScope().getLog(this.getClass()).info("Creating the SQL run script");
            NativeToolFileCreator nativeToolFileCreator = new NativeToolFileCreator(this.changeSet, this.tempName, this.tempPath, this.tempOverwrite == null ? SqlplusConfiguration.TEMP_OVERWRITE.getDefaultValue().booleanValue() : this.tempOverwrite.booleanValue(), this.keepTempFile == null ? SqlplusConfiguration.TEMP_KEEP.getDefaultValue().booleanValue() : this.keepTempFile.booleanValue());
            try {
                this.spoolFile = nativeToolFileCreator.generateTemporaryFile(NativeToolFileCreator$FileTypeEnum.spool);
            }
            catch (IOException iOException) {
                throw new UnexpectedLiquibaseException(iOException);
            }
            try {
                this.outFile = nativeToolFileCreator.generateTemporaryFile(NativeToolFileCreator$FileTypeEnum.sql);
            }
            catch (IOException iOException) {
                throw new UnexpectedLiquibaseException(iOException);
            }
            int n3 = this.isAddWhenever();
            object = this.getLiquibaseCatalogName((Database)object);
            bufferedWriter = Files.newBufferedWriter(Paths.get(this.outFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
            Throwable throwable = null;
            try {
                Object object2;
                int n2;
                bufferedWriter.write("SET ECHO ON\n");
                bufferedWriter.write("SET DEFINE OFF\n");
                bufferedWriter.write(String.format("SET ERRORLOGGING ON TABLE %s.%s TRUNCATE IDENTIFIER '%s' %n", object, DATICAL_SPERRORLOG, this.errorLoggingIdentifier));
                if (n3 != 0) {
                    bufferedWriter.write("WHENEVER SQLERROR EXIT FAILURE;\n");
                }
                bufferedWriter.write("SPOOL \"" + this.spoolFile.getAbsolutePath() + "\"\n");
                bufferedWriter.write("SET SQLBLANKLINES ON\n\n");
                object = this.sqlStrings;
                n3 = this.sqlStrings.length;
                for (n2 = 0; n2 < n3 && !this.warnOnSpoolStatements((Sql)(object2 = object[n2])); ++n2) {
                }
                object = this.sqlStrings;
                n3 = this.sqlStrings.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    object2 = object[n2].toSql().replace("\r", "");
                    bufferedWriter.write((String)object2 + "\n");
                }
                object = this.getEndDelimiter();
                if (object != null && ((String)object).equals("\n/$")) {
                    bufferedWriter.write("/\n");
                }
                bufferedWriter.write("EXIT;\n");
                if (bufferedWriter == null) return;
                if (throwable == null) break block18;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable4) {
                    if (bufferedWriter == null) throw throwable4;
                    if (throwable == null) {
                        bufferedWriter.close();
                        throw throwable4;
                    }
                    try {
                        bufferedWriter.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
            }
            try {
                bufferedWriter.close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        bufferedWriter.close();
    }

    private boolean warnOnSpoolStatements(Sql stringArray) {
        stringArray = stringArray.toSql().split("\n");
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!stringArray[i2].toLowerCase().contains("spool")) continue;
            Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning("SPOOL statements were detected in your script for change set " + this.changeSet.getId() + "::" + this.changeSet.getAuthor() + ".\nThis may prevent sqlplus spool output from being included in the Liquibase logs");
            return true;
        }
        return false;
    }

    private boolean isAddWhenever() {
        boolean bl2 = true;
        Sql[] sqlArray = this.sqlStrings;
        int n2 = this.sqlStrings.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!sqlArray[i2].toSql().toLowerCase().startsWith("whenever")) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    private String getEndDelimiter() {
        String string = null;
        for (Change change : this.changeSet.getChanges()) {
            if (change instanceof AbstractSQLChange && (string = ((AbstractSQLChange)change).getEndDelimiter()) != null) break;
        }
        return string;
    }

    private void captureSpoolOutputInLog() {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        if (!this.spoolFile.exists()) {
            logger.warning("Unable to locate spool output file " + this.spoolFile.getAbsolutePath());
            return;
        }
        logger.info("Writing spool output to log");
        Throwable throwable = null;
        try (BufferedReader bufferedReader = Files.newBufferedReader(this.spoolFile.toPath());){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                logger.info(string);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        logger.info("\n");
        logger.info("Spool output written to log");
    }

    protected String buildConnectionString(Database object) {
        Object object2;
        if (object == null) {
            return null;
        }
        object = object.getConnection();
        String string = "";
        String string2 = "";
        if (object instanceof ProJdbcConnection) {
            object2 = (ProJdbcConnection)object;
            string = ((ProJdbcConnection)object2).getUsername();
            if (string == null) {
                string = object.getConnectionUserName();
            }
            string = StringUtil.trimToEmpty(string);
            string2 = StringUtil.trimToEmpty(((ProJdbcConnection)object2).getPassword());
            if (string2.equals("")) {
                string = "";
            } else {
                string2 = "\"" + string2 + "\"";
            }
        }
        if (((Matcher)(object = OracleDatabase.PROXY_USER.matcher((CharSequence)(object2 = object.getURL())))).matches()) {
            string = string + "[" + ((Matcher)object).group(1) + "]";
        }
        object = ((String)object2).split("jdbc:oracle:(.*)@")[1];
        return string + "/" + string2 + "@" + (String)object;
    }
}

