package com.xebialabs.xlrelease.api.v1.views.search;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.xlrelease.api.v1.views.BaseAppEnvView;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentLabelView;
import com.xebialabs.xlrelease.api.v1.views.EnvironmentStageView;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;

public class EnvironmentReservationSearchView extends BaseAppEnvView {
    // id used from super class is Environment ID, not reservation ID
    private String description;
    private EnvironmentStageView stage;
    private List<EnvironmentLabelView> labels = new ArrayList<>();
    private List<ReservationSearchView> reservations = new ArrayList<>();

    public static EnvironmentReservationSearchView from(Environment environment, List<EnvironmentReservation> reservations) {
        EnvironmentReservationSearchView view = new EnvironmentReservationSearchView();
        view.setId(environment.getId());
        view.setFolderId(environment.getFolderId());
        view.setTitle(environment.getTitle());
        view.setDescription(environment.getDescription());
        view.setStage(EnvironmentStageView.fromEnvironmentStage(environment.getStage()));
        view.setLabels(
                environment.getLabels()
                        .stream()
                        .map(EnvironmentLabelView::fromEnvironmentLabel)
                        .collect(Collectors.toList())
        );
        view.setReservations(
                reservations
                        .stream()
                        .map(ReservationSearchView::fromEnvironmentReservation)
                        .collect(Collectors.toList())
        );
        return view;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public EnvironmentStageView getStage() {
        return stage;
    }

    public void setStage(final EnvironmentStageView stage) {
        this.stage = stage;
    }

    public List<ReservationSearchView> getReservations() {
        return reservations;
    }

    public void setReservations(final List<ReservationSearchView> reservations) {
        this.reservations = reservations;
    }

    public List<EnvironmentLabelView> getLabels() {
        return labels;
    }

    public void setLabels(final List<EnvironmentLabelView> labels) {
        this.labels = labels;
    }
}
