package com.xebialabs.xlrelease.api.v1;

import java.util.List;
import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.FacetFilters;
import com.xebialabs.xlrelease.domain.facet.ConfigurationFacet;
import com.xebialabs.xlrelease.domain.facet.Facet;

// this API is not public as it might still change in the future (i.e. be part of of the TaskApi or similar)
@Path("/api/v1/facets/")
@Produces({MediaType.APPLICATION_JSON})
@Consumes({MediaType.APPLICATION_JSON})
public interface FacetApi extends ApiService {

    default String serviceName() {
        return "facetApi";
    }

    @GET
    @Path("{facetId:.*Facet[^/-]*}")
    @PublicApiMember
    Facet getFacet(@PathParam("facetId") String facetId);

    @POST
    @PublicApiMember
    Facet createFacet(ConfigurationFacet configurationFacet);

    @PublicApiMember
    Facet newFacet(String type);

    @PUT
    @Path("{facetId:.*Facet[^/]*}")
    @PublicApiMember
    Facet updateFacet(@PathParam("facetId") String facetId, ConfigurationFacet configurationFacet);

    @DELETE
    @Path("{facetId:.*Facet[^/]*}")
    @PublicApiMember
    void deleteFacet(@PathParam("facetId") String facetId);

    @POST
    @Path("search")
    @PublicApiMember
    List<Facet> searchFacets(FacetFilters facetFilters);

    @GET
    @Path("types")
    @PublicApiMember
    List<Descriptor> getFacetTypes(@QueryParam("baseType") String baseType);
}
