package com.xebialabs.xlrelease.api.v1;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.rest.AllCILevels;

/**
 * Operations related to permissions.
 */
@Path("/api/v1/global-permissions")
@AllCILevels
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@PublicApi
@ShowOnlyPublicApiMembers
public interface PermissionsApi extends ApiService {

    default String serviceName() {
        return "permissionsApi";
    }

    /**
     * Returns the list of global permissions.
     */
    @GET
    @PublicApiMember
    List<String> getGlobalPermissions();

}
