/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.AbortRelease;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.api.v1.views.BasicReleaseView;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.rest.AllCILevels;
import com.xebialabs.xlrelease.search.ReleaseCountResults;
import com.xebialabs.xlrelease.search.ReleaseFullSearchResult;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Path(value="/api/v1/releases")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AllCILevels
@PublicApi
@ShowOnlyPublicApiMembers
public interface ReleaseApi
extends ApiService {
    public static final String SERVICE_NAME = "releaseApi";
    public static final long DEFAULT_PAGE = 0L;
    public static final String ARCHIVE_PAGE = "archivePage";
    public static final String ARCHIVE_RESULTS_PER_PAGE = "archiveResultsPerPage";

    @Override
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @GET
    @Path(value="attachments/{attachmentId:.*/Attachment[^/]*}")
    @Produces(value={"application/octet-stream"})
    public Response downloadAttachment(@PathParam(value="attachmentId") String var1);

    @PublicApiMember
    public byte[] getAttachment(String var1) throws IOException;

    @POST
    @Path(value="count")
    public ReleaseCountResults countReleases(ReleasesFilters var1);

    @POST
    @Path(value="search")
    @PublicApiMember
    public List<Release> searchReleases(ReleasesFilters var1, @DefaultValue(value="0") @QueryParam(value="page") Long var2, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long var3, @DefaultValue(value="false") @QueryParam(value="pageIsOffset") Boolean var4);

    @PublicApiMember
    public List<Release> searchReleases(ReleasesFilters var1, Long var2, Long var3);

    @PublicApiMember
    public List<Release> searchReleases(ReleasesFilters var1);

    @POST
    @Path(value="search/overview")
    @PublicApiMember
    public List<BasicReleaseView> searchReleasesOverview(ReleasesFilters var1, @DefaultValue(value="0") @QueryParam(value="page") Long var2, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long var3);

    @POST
    @Path(value="fullSearch")
    public ReleaseFullSearchResult fullSearchReleases(@QueryParam(value="page") Long var1, @QueryParam(value="archivePage") Long var2, @QueryParam(value="resultsPerPage") Long var3, @QueryParam(value="archiveResultsPerPage") Long var4, ReleasesFilters var5);

    @GET
    @Path(value="/")
    @PublicApiMember
    public List<Release> getReleases(@DefaultValue(value="0") @QueryParam(value="page") Long var1, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long var2, @DefaultValue(value="1") @QueryParam(value="depth") Integer var3);

    @GET
    @Path(value="/")
    @PublicApiMember
    public List<Release> getReleases(@DefaultValue(value="0") @QueryParam(value="page") Long var1, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long var2);

    @Deprecated(since="24.1.0")
    @PublicApiMember
    public List<Release> getReleases();

    @GET
    @Path(value="/{releaseId:((?!archived).)*Release[^/]*}")
    @PublicApiMember
    public Release getRelease(@PathParam(value="releaseId") String var1, @DefaultValue(value="false") @QueryParam(value="roleIds") boolean var2);

    @PublicApiMember
    public Release getRelease(String var1);

    @GET
    @Path(value="/archived/{releaseId:.*Release[^/]*}")
    @PublicApiMember
    public Release getArchivedRelease(@PathParam(value="releaseId") String var1, @DefaultValue(value="false") @QueryParam(value="roleIds") boolean var2);

    @PublicApiMember
    public Release getArchivedRelease(String var1);

    @GET
    @Path(value="/{releaseId:.*Release[^/]*}/active-tasks")
    @PublicApiMember
    public List<Task> getActiveTasks(@PathParam(value="releaseId") String var1);

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/start")
    @PublicApiMember
    public Release start(@PathParam(value="releaseId") String var1);

    @PUT
    @Path(value="/{releaseId:.*Release[^/]*}")
    public Release updateRelease(@PathParam(value="releaseId") String var1, Release var2);

    @PublicApiMember
    public Release updateRelease(Release var1);

    @DELETE
    @Path(value="/{releaseId:.*Release[^/]*}")
    @PublicApiMember
    public void delete(@PathParam(value="releaseId") String var1);

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/abort")
    public Release abort(@PathParam(value="releaseId") String var1, AbortRelease var2);

    @PublicApiMember
    public Release abort(String var1, String var2);

    @GET
    @Path(value="/byTitle")
    @PublicApiMember
    public List<Release> searchReleasesByTitle(@QueryParam(value="releaseTitle") String var1);

    @GET
    @Path(value="/{releaseId:.*Release[^/]*}/variables")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> getVariables(@PathParam(value="releaseId") String var1);

    @GET
    @Path(value="/{releaseId:.*Release[^/]*}/variableValues")
    @PublicApiMember
    public Map<String, String> getVariableValues(@PathParam(value="releaseId") String var1);

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(@PathParam(value="variableId") String var1);

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/possibleValues")
    @PublicApiMember
    public Collection<Object> getVariablePossibleValues(@PathParam(value="variableId") String var1);

    @GET
    @Path(value="/{variableId:.*/Variable[^/]*}/used")
    @PublicApiMember
    public Boolean isVariableUsed(@PathParam(value="variableId") String var1);

    @POST
    @Path(value="/{variableId:.*/Variable[^/]*}/replace")
    @PublicApiMember
    public void replaceVariable(@PathParam(value="variableId") String var1, VariableOrValue var2);

    @DELETE
    @Path(value="/{variableId:.*/Variable[^/]*}")
    @PublicApiMember
    public void deleteVariable(@PathParam(value="variableId") String var1);

    @POST
    @Path(value="/{releaseId:.*?}/variables")
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(@PathParam(value="releaseId") String var1, Variable var2);

    @PUT
    @Path(value="/{releaseId:.*?}/variables")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> updateVariables(@PathParam(value="releaseId") String var1, List<com.xebialabs.xlrelease.domain.variables.Variable> var2);

    @PUT
    @Path(value="/{variableId:.*/Variable[^/]*}")
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(@PathParam(value="variableId") String var1, com.xebialabs.xlrelease.domain.variables.Variable var2);

    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(com.xebialabs.xlrelease.domain.variables.Variable var1);

    @GET
    @Path(value="/permissions")
    @PublicApiMember
    public List<String> getPermissions();

    @GET
    @Path(value="/{releaseId:.*Release[^/]*}/teams")
    @PublicApiMember
    public List<TeamView> getTeams(@PathParam(value="releaseId") String var1);

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/teams")
    @PublicApiMember
    public List<TeamView> setTeams(@PathParam(value="releaseId") String var1, List<TeamView> var2);

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/resume")
    @PublicApiMember
    public Release resume(@PathParam(value="releaseId") String var1);

    @POST
    @Path(value="/{releaseId:.*Release[^/]*}/restart")
    public Release restartPhases(@PathParam(value="releaseId") String var1, @QueryParam(value="fromPhaseId") String var2, @QueryParam(value="fromTaskId") String var3, @QueryParam(value="phaseVersion") PhaseVersion var4, @QueryParam(value="resume") boolean var5);

    @PublicApiMember
    public Release restartPhase(Release var1);

    @PublicApiMember
    public Release restartPhase(Release var1, boolean var2);

    @PublicApiMember
    public Release restartPhase(Release var1, Phase var2);

    @PublicApiMember
    public Release restartPhase(Release var1, Phase var2, PhaseVersion var3);

    @PublicApiMember
    public Release restartPhase(Release var1, Phase var2, Task var3);

    @PublicApiMember
    public Release restartPhase(Release var1, Phase var2, Task var3, PhaseVersion var4);

    @PublicApiMember
    public Release restartPhase(Release var1, Phase var2, Task var3, PhaseVersion var4, boolean var5);
}

