/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.CreateTeam;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.rest.AllCILevels;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Map;

@Path(value="/api/v1/folders")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@AllCILevels
@PublicApi
@ShowOnlyPublicApiMembers
public interface FolderApi
extends ApiService {
    public static final String EXPRESSION_FOLDER_ID = "/{folderId:.*(Folder[^/]*|Applications)}";

    @Override
    default public String serviceName() {
        return "folderApi";
    }

    @GET
    @Path(value="/list")
    @PublicApiMember
    public List<Folder> listRoot(@QueryParam(value="page") Long var1, @QueryParam(value="resultsPerPage") Long var2, @QueryParam(value="depth") Integer var3, @QueryParam(value="permissions") Boolean var4);

    @PublicApiMember
    default public List<Folder> listRoot() {
        return this.listRoot(null, null, null, null);
    }

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/list")
    @PublicApiMember
    public List<Folder> list(@PathParam(value="folderId") String var1, @QueryParam(value="page") Long var2, @QueryParam(value="resultsPerPage") Long var3, @QueryParam(value="depth") Integer var4, @QueryParam(value="permissions") Boolean var5);

    @GET
    @Path(value="/find")
    @PublicApiMember
    public Folder find(@QueryParam(value="byPath") String var1, @QueryParam(value="depth") Integer var2);

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}")
    @PublicApiMember
    public Folder getFolder(@PathParam(value="folderId") String var1, @QueryParam(value="depth") Integer var2);

    @PublicApiMember
    public Folder getFolder(String var1);

    @Deprecated(since="24.1.0")
    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/templates")
    @PublicApiMember
    public List<Release> getTemplates(@PathParam(value="folderId") String var1, @DefaultValue(value="RELEASE") @QueryParam(value="kind") String var2, @QueryParam(value="page") Long var3, @QueryParam(value="resultsPerPage") Long var4, @QueryParam(value="depth") Integer var5);

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/templates")
    @PublicApiMember
    public List<Release> getTemplates(@PathParam(value="folderId") String var1, @DefaultValue(value="RELEASE") @QueryParam(value="kind") String var2, @QueryParam(value="page") Long var3, @QueryParam(value="resultsPerPage") Long var4);

    @Deprecated(since="24.1.0")
    @PublicApiMember
    default public List<Release> getTemplates(String folderId, Long page, Long resultPerPage, Integer depth) {
        return this.getTemplates(folderId, ReleaseKind.RELEASE.name(), page, resultPerPage, depth);
    }

    @PublicApiMember
    default public List<Release> getTemplates(String folderId, Long page, Long resultPerPage) {
        return this.getTemplates(folderId, ReleaseKind.RELEASE.name(), page, resultPerPage);
    }

    @PublicApiMember
    public List<Release> getTemplates(String var1);

    @Deprecated(since="24.1.0")
    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/releases")
    @PublicApiMember
    public List<Release> searchReleases(@PathParam(value="folderId") String var1, @QueryParam(value="page") Long var2, @QueryParam(value="numberbypage") Long var3, @QueryParam(value="depth") Integer var4, ReleasesFilters var5);

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/releases")
    @PublicApiMember
    public List<Release> searchReleases(@PathParam(value="folderId") String var1, @QueryParam(value="page") Long var2, @QueryParam(value="numberbypage") Long var3, ReleasesFilters var4);

    @PublicApiMember
    public List<Release> searchReleases(String var1, ReleasesFilters var2);

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/templates/{templateId:.*Release[^/]*}")
    @PublicApiMember
    public void moveTemplate(@PathParam(value="folderId") String var1, @PathParam(value="templateId") String var2, @QueryParam(value="mergePermissions") Boolean var3);

    @PublicApiMember
    public void moveTemplate(String var1, String var2);

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}")
    @PublicApiMember
    public Folder addFolder(@PathParam(value="folderId") String var1, Folder var2);

    @DELETE
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}")
    @PublicApiMember
    public void delete(@PathParam(value="folderId") String var1);

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/move")
    @PublicApiMember
    public Folder move(@PathParam(value="folderId") String var1, @QueryParam(value="newParentId") String var2);

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/rename")
    @PublicApiMember
    public void rename(@PathParam(value="folderId") String var1, @QueryParam(value="newName") String var2);

    @GET
    @Path(value="/permissions")
    @PublicApiMember
    public List<String> getPermissions();

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams")
    @PublicApiMember
    public List<TeamView> getTeams(@PathParam(value="folderId") String var1);

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams")
    @PublicApiMember
    public List<TeamView> setTeams(@PathParam(value="folderId") String var1, List<TeamView> var2);

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/folderOwner")
    public boolean isFolderOwner(@PathParam(value="folderId") String var1);

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/variables")
    @PublicApiMember
    public List<com.xebialabs.xlrelease.domain.variables.Variable> listVariables(@PathParam(value="folderId") String var1, @QueryParam(value="folderOnly") boolean var2);

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/variableValues")
    @PublicApiMember
    public Map<String, String> listVariableValues(@PathParam(value="folderId") String var1, @QueryParam(value="folderOnly") boolean var2);

    @POST
    @PublicApiMember
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/variables")
    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(@PathParam(value="folderId") String var1, Variable var2);

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{variableId:.*Variable[^/]*}")
    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(@PathParam(value="folderId") String var1, @PathParam(value="variableId") String var2);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{variableId:.*Variable[^/]*}")
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(@PathParam(value="folderId") String var1, @PathParam(value="variableId") String var2, com.xebialabs.xlrelease.domain.variables.Variable var3);

    @PublicApiMember
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(String var1, com.xebialabs.xlrelease.domain.variables.Variable var2);

    @DELETE
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{variableId:.*Variable[^/]*}")
    @PublicApiMember
    public void deleteVariable(@PathParam(value="folderId") String var1, @PathParam(value="variableId") String var2);

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{teamId:Team[^/]*}")
    @PublicApiMember
    public Team getTeam(@PathParam(value="folderId") String var1, @PathParam(value="teamId") String var2);

    @GET
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams/{teamName}")
    @PublicApiMember
    public Team findTeam(@PathParam(value="folderId") String var1, @PathParam(value="teamName") String var2);

    @POST
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/create-team")
    public String createTeam(@PathParam(value="folderId") String var1, CreateTeam var2);

    @PublicApiMember
    default public String createTeam(String folderId, String name, List<String> principals, List<String> roles, List<String> permissions) {
        return this.createTeam(folderId, new CreateTeam(name, principals, roles, permissions));
    }

    @DELETE
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams/{teamName}")
    @PublicApiMember
    public void deleteTeamByName(@PathParam(value="folderId") String var1, @PathParam(value="teamName") String var2);

    @DELETE
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{teamId:Team[^/]*}")
    @PublicApiMember
    public void deleteTeamById(@PathParam(value="folderId") String var1, @PathParam(value="teamId") String var2);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{teamId:Team[^/]*}/add-principals")
    @PublicApiMember
    public void addPrincipalsToTeamById(@PathParam(value="folderId") String var1, @PathParam(value="teamId") String var2, List<String> var3);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams/{teamName}/add-principals")
    @PublicApiMember
    public void addPrincipalsToTeamByName(@PathParam(value="folderId") String var1, @PathParam(value="teamName") String var2, List<String> var3);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{teamId:Team[^/]*}/remove-principals")
    @PublicApiMember
    public void removePrincipalsFromTeamById(@PathParam(value="folderId") String var1, @PathParam(value="teamId") String var2, List<String> var3);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams/{teamName}/remove-principals")
    @PublicApiMember
    public void removePrincipalsFromTeamByName(@PathParam(value="folderId") String var1, @PathParam(value="teamName") String var2, List<String> var3);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{teamId:Team[^/]*}/add-roles")
    @PublicApiMember
    public void addRoleNamesToTeamById(@PathParam(value="folderId") String var1, @PathParam(value="teamId") String var2, List<String> var3);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams/{teamName}/add-roles")
    @PublicApiMember
    public void addRoleNamesToTeamByName(@PathParam(value="folderId") String var1, @PathParam(value="teamName") String var2, List<String> var3);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{teamId:Team[^/]*}/remove-roles")
    @PublicApiMember
    public void removeRoleNamesFromTeamById(@PathParam(value="folderId") String var1, @PathParam(value="teamId") String var2, List<String> var3);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams/{teamName}/remove-roles")
    @PublicApiMember
    public void removeRoleNamesFromTeamByName(@PathParam(value="folderId") String var1, @PathParam(value="teamName") String var2, List<String> var3);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{teamId:Team[^/]*}/add-permissions")
    @PublicApiMember
    public void addPermissionsToTeamById(@PathParam(value="folderId") String var1, @PathParam(value="teamId") String var2, List<String> var3);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams/{teamName}/add-permissions")
    @PublicApiMember
    public void addPermissionsToTeamByName(@PathParam(value="folderId") String var1, @PathParam(value="teamName") String var2, List<String> var3);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/{teamId:Team[^/]*}/remove-permissions")
    @PublicApiMember
    public void removePermissionsFromTeamById(@PathParam(value="folderId") String var1, @PathParam(value="teamId") String var2, List<String> var3);

    @PUT
    @Path(value="/{folderId:.*(Folder[^/]*|Applications)}/teams/{teamName}/remove-permissions")
    @PublicApiMember
    public void removePermissionsFromTeamByName(@PathParam(value="folderId") String var1, @PathParam(value="teamName") String var2, List<String> var3);
}

