package com.xebialabs.xlrelease.api.v1;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.views.AutoconfigResponse;

@Path("/api/v1/deployment-providers")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public interface DeploymentProviderApi extends ApiService {

    default String serviceName() {
        return "deploymentProviderApi";
    }

    @POST
    @Path("/autoconfigure/{statusWebhookEventSourceId:.*/Configuration[^/]*}")
    AutoconfigResponse autoconfigureDeploymentProvider(@PathParam("statusWebhookEventSourceId") String statusWebhookEventSourceId);

    @POST
    @Path("/patch/{statusWebhookEventSourceId:.*/Configuration[^/]*}")
    void patchDeploymentProvider(@PathParam("statusWebhookEventSourceId") String statusWebhookEventSourceId);

}
