package com.xebialabs.xlrelease.api.v1;

import java.util.List;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import com.xebialabs.xlrelease.api.v1.forms.DatacenterTargetStateRequest;
import com.xebialabs.xlrelease.api.v1.views.ApplicationStatusView;
import com.xebialabs.xlrelease.domain.Datacenter;

@Path("/api/v1/management")
@Produces({MediaType.APPLICATION_JSON})
@Consumes({MediaType.APPLICATION_JSON})
public interface ManagementApi {

    @POST
    @Path("/services/stop")
    void stop();

    @POST
    @Path("/services/start")
    void start();

    @GET
    @Path("/services/status")
    ApplicationStatusView applicationStatus();

    @GET
    @Path("/datacenters")
    List<Datacenter> getDatacenters();

    @PUT
    @Path("/datacenters/{datacenter}/state")
    void setDatacenterState(@PathParam("datacenter") String datacenter, DatacenterTargetStateRequest datacenterTargetStateRequest);

    @POST
    @Path("/datacenters/{datacenter}")
    Datacenter createDatacenter(@PathParam("datacenter") String datacenter);

    @DELETE
    @Path("/datacenters/{datacenter}")
    void deleteDatacenter(@PathParam("datacenter") String datacenter);
}
