package com.xebialabs.xlrelease.api.v1;

import java.util.List;
import java.util.Map;
import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;

import com.xebialabs.xlrelease.api.v1.views.CacheGroupView;

/**
 * Operations on caches
 */
@Path("/api/v1/caches")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
public interface CacheManagementApi {

    /**
     * Lists available cache groups.
     *
     * @return list of cache groups
     */
    @GET
    @Path("/groups")
    List<CacheGroupView> listCacheGroups();

    /**
     * Clears all caches.
     */
    @DELETE
    @Path("/groups")
    void clearAllCacheGroups();

    /**
     * Clears all caches for the particular cache group.
     *
     * @param cacheGroup the cache group to clear
     */
    @DELETE
    @Path("/groups/{cacheGroup}")
    void clearCacheGroup(@PathParam("cacheGroup") String cacheGroup);

    /**
     * Fetches cache statistics for the particular cache group.
     *
     * @param cacheGroup the cache group to fetch statistics for
     * @return cache statistics
     */
    @GET
    @Path("/groups/{cacheGroup}/statistics")
    Map<String, Map<String, String>> getCacheStatistics(@PathParam("cacheGroup") String cacheGroup);
}
