package com.xebialabs.xlrelease.api.v1;

import jakarta.ws.rs.*;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

import com.xebialabs.xlplatform.documentation.PublicApi;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.domain.Release;

/**
 * Operations with release DSL.
 */
@Path("/api/v1/dsl")
@PublicApi
@ShowOnlyPublicApiMembers
public interface DslApi extends ApiService {

    default String serviceName() {
        return "dslApi";
    }

    /**
     * Shows a DSL preview of a given template.
     *
     * @param templateId the template identifier.
     * @param asTemplate if true, will render as template, otherwise will render as release.
     * @return UTF-8 encoded DSL string
     */
    @GET
    @Path("/preview/{templateId:.*Release[^/]*}")
    @Produces(MediaType.TEXT_PLAIN)
    Response previewExportTemplateToXFile(@PathParam("templateId") String templateId,
                                          @QueryParam("exportTemplate") boolean asTemplate);

    /**
     * Exports given template into DSL.
     *
     * @param templateId the template identifier.
     * @param asTemplate if true, will render as template, otherwise will render as release.
     * @return a zip file with the DSL and attachments if the template contains them
     */
    @GET
    @Path("/export/{templateId:.*Release[^/]*}")
    @Produces(MediaType.APPLICATION_OCTET_STREAM)
    Response exportTemplateToXFile(@PathParam("templateId") String templateId,
                                   @QueryParam("exportTemplate") boolean asTemplate);

    /**
     * Exports template as DSL.
     *
     * @param template template to export
     * @return DSL string
     */
    @PublicApiMember
    String exportTemplate(Release template);

    @PublicApiMember
    String exportTemplate(Release template, boolean asTemplate);

}
