package com.xebialabs.xlrelease.support.cache.caffeine.spring

import com.github.benmanes.caffeine.cache.{Cache, CacheLoader, LoadingCache}
import com.xebialabs.xlrelease.support.cache.caffeine.{CaffeineCacheBuilder, CaffeineCacheDelegate, LoadingCaffeineCacheDelegate}
import com.xebialabs.xlrelease.support.cache.config.CacheSettings
import org.springframework.cache.caffeine.CaffeineCacheManager

class XlrCaffeineCacheManager(cacheManagerName: String, cacheSettings: CacheSettings)
  extends CaffeineCacheManager with CaffeineCacheBuilder {

  override def createNativeCaffeineCache(name: String): Cache[AnyRef, AnyRef] = {
    buildCache(cacheManagerName, name, cacheSettings)
  }

  def createNativeCaffeineCache[K, V](name: String, cacheLoader: CacheLoader[K, V]): LoadingCache[K, V] = {
    buildCache(cacheManagerName, name, cacheSettings, Some(cacheLoader))
      .asInstanceOf[LoadingCache[K, V]]
  }

  override def setCacheLoader(cacheLoader: CacheLoader[AnyRef, AnyRef]): Unit = {
    throw new UnsupportedOperationException("Cache loading not support by this manager implementation")
  }

  def createNativeCacheAndRegister[K, V](name: String): CaffeineCacheDelegate[K, V] = {
    val cache = createNativeCaffeineCache(name)
    registerCustomCache(name, cache)
    cache.asInstanceOf[CaffeineCacheDelegate[K, V]]
  }

  def createNativeCacheAndRegister[K, V](name: String, cacheLoader: CacheLoader[K, V]): LoadingCaffeineCacheDelegate[K, V] = {
    val cache = createNativeCaffeineCache(name, cacheLoader)
    registerCustomCache(name, cache.asInstanceOf[Cache[AnyRef, AnyRef]])
    cache.asInstanceOf[LoadingCaffeineCacheDelegate[K, V]]
  }

  def getNativeCache[K, V](name: String): CaffeineCacheDelegate[K, V] = {
    super.getCache(name).getNativeCache.asInstanceOf[CaffeineCacheDelegate[K, V]]
  }

  def getOrCreateCache[K, V](name: String): CaffeineCacheDelegate[K, V] = {
    Option(this.getNativeCache[K, V](name))
      .getOrElse(this.createNativeCacheAndRegister[K, V](name))
  }

  def updateCachesState(enabled: Boolean): Unit = {
    getCacheNames.forEach(name => {
      val cache = getNativeCache(name)
      if (enabled) {
        cache.enable()
      } else {
        cache.disable()
      }
    })
  }
}