package com.xebialabs.xlrelease.domain.utils;

import java.util.List;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.ContainerTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Task;

import static com.google.common.collect.ImmutableList.copyOf;
import static com.xebialabs.deployit.plugin.api.reflect.Type.valueOf;
import static com.xebialabs.xlrelease.domain.Task.isDefaultTaskType;
import static java.util.Comparator.comparing;
import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;
import static java.util.stream.Stream.of;

public class TaskTypes {
    private static List<Type> defaultTaskTypes;

    public static List<Type> getDefaultTaskTypes() {
        if (defaultTaskTypes == null) {
            defaultTaskTypes = copyOf(concat(of(valueOf(Task.class)), getTypes(Task.class).stream())
                    .filter(
                        type -> isDefaultTaskType(type)
                                && !type.instanceOf(valueOf(CustomScriptTask.class))
                                && !type.instanceOf(valueOf(ContainerTask.class))
                                && type != Task.UNKNOWN_TASK_TYPE
                    )
                    .collect(toList()));
        }
        return defaultTaskTypes;
    }

    public static List<Type> getTypes(Class<? extends ConfigurationItem> clazz) {
        return DescriptorRegistry.getSubtypes(valueOf(clazz))
                .stream()
                .filter(type -> !type.getDescriptor().isVirtual())
                .sorted(comparing(Type::toString))
                .collect(toList());
    }
}
