package com.xebialabs.xlrelease.builder;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.ContainerTask;

import static com.google.common.collect.Maps.newHashMap;

public class ContainerTaskBuilder extends TaskBuilder<ContainerTask, ContainerTaskBuilder> {

    private String type;

    private Map<String, Object> inputParameters = newHashMap();

    private Map<String, Object> outputProperties = newHashMap();

    private String statusLine;

    private boolean keepPreviousOutputPropertiesOnRetry;

    public ContainerTaskBuilder(String type) {
        this.type = type;
    }

    public ContainerTaskBuilder withInputParameters(Map<String, Object> inputParameters) {
        this.inputParameters = inputParameters;
        return this;
    }

    public ContainerTaskBuilder withOutputProperties(Map<String, Object> outputProperties) {
        this.outputProperties = outputProperties;
        return this;
    }

    public ContainerTaskBuilder withStatusLine(String statusLine) {
        this.statusLine = statusLine;
        return this;
    }

    public ContainerTaskBuilder withKeepPreviousOutputPropertiesOnRetry(final boolean keepPreviousOutputPropertiesOnRetry) {
        this.keepPreviousOutputPropertiesOnRetry = keepPreviousOutputPropertiesOnRetry;
        return this;
    }

    @Override
    public ContainerTask build() {
        ContainerTask task = Type.valueOf(type).getDescriptor().newInstance(null);
        setFields(task);
        task.setStatusLine(statusLine);
        task.setKeepPreviousOutputPropertiesOnRetry(keepPreviousOutputPropertiesOnRetry);
        for (Map.Entry<String, Object> entry : inputParameters.entrySet()) {
            task.setProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : outputProperties.entrySet()) {
            task.setProperty(entry.getKey(), entry.getValue());
        }
        return task;
    }
}
