package com.xebialabs.xlrelease.builder;

import java.util.Set;

import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.notification.MailPriority;

import static com.google.common.collect.Sets.newHashSet;

public class NotificationTaskBuilder extends TaskBuilder<NotificationTask, NotificationTaskBuilder> {
    private Set<String> addresses = newHashSet();
    private Set<String> cc = newHashSet();
    private Set<String> bcc = newHashSet();
    private String replyTo;
    private String from;
    private String senderUsername;
    private String senderPassword;
    private MailPriority mailPriority;
    private String subject;
    private String body;

    public NotificationTaskBuilder withAddresses(String... addresses) {
        this.addresses = newHashSet(addresses);
        return this;
    }

    public NotificationTaskBuilder withAddresses(Set<String> addresses) {
        this.addresses.addAll(addresses);
        return this;
    }

    public NotificationTaskBuilder withCc(Set<String> cc) {
        this.cc.addAll(cc);
        return this;
    }

    public NotificationTaskBuilder withCc(String... cc) {
        this.cc.addAll(newHashSet(cc));
        return this;
    }

    public NotificationTaskBuilder withBcc(Set<String> bcc) {
        this.bcc.addAll(bcc);
        return this;
    }

    public NotificationTaskBuilder withBcc(String... bcc) {
        this.bcc.addAll(newHashSet(bcc));
        return this;
    }

    public NotificationTaskBuilder withReplyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public NotificationTaskBuilder withFrom(String from) {
        this.from = from;
        return this;
    }

    public NotificationTaskBuilder withSenderUsername(String username) {
        this.senderUsername = username;
        return this;
    }

    public NotificationTaskBuilder withSenderPassword(String password) {
        this.senderPassword = password;
        return this;
    }

    public NotificationTaskBuilder withMailPriority(MailPriority mailPriority) {
        this.mailPriority= mailPriority;
        return this;
    }

    public NotificationTaskBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public NotificationTaskBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    @Override
    protected void setFields(NotificationTask task) {
        super.setFields(task);
        task.setAddresses(addresses);
        task.setSubject(subject);
        task.setBody(body);
        task.setCc(cc);
        task.setBcc(bcc);
        task.setReplyTo(replyTo);
        task.setFrom(from);
        task.setSenderUsername(senderUsername);
        task.setSenderPassword(senderPassword);
        task.setPriority(mailPriority);
    }

    @Override
    public NotificationTask build() {
        NotificationTask task = new NotificationTask().getType().getDescriptor().newInstance("dummy");
        setFields(task);
        return task;
    }
}
