/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.notification.MailPriority;
import java.util.Set;

public class NotificationTaskBuilder
extends TaskBuilder<NotificationTask, NotificationTaskBuilder> {
    private Set<String> addresses = Sets.newHashSet();
    private Set<String> cc = Sets.newHashSet();
    private Set<String> bcc = Sets.newHashSet();
    private String replyTo;
    private String from;
    private String senderUsername;
    private String senderPassword;
    private MailPriority mailPriority;
    private String subject;
    private String body;

    public NotificationTaskBuilder withAddresses(String ... addresses) {
        this.addresses = Sets.newHashSet((Object[])addresses);
        return this;
    }

    public NotificationTaskBuilder withAddresses(Set<String> addresses) {
        this.addresses.addAll(addresses);
        return this;
    }

    public NotificationTaskBuilder withCc(Set<String> cc) {
        this.cc.addAll(cc);
        return this;
    }

    public NotificationTaskBuilder withCc(String ... cc) {
        this.cc.addAll(Sets.newHashSet((Object[])cc));
        return this;
    }

    public NotificationTaskBuilder withBcc(Set<String> bcc) {
        this.bcc.addAll(bcc);
        return this;
    }

    public NotificationTaskBuilder withBcc(String ... bcc) {
        this.bcc.addAll(Sets.newHashSet((Object[])bcc));
        return this;
    }

    public NotificationTaskBuilder withReplyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public NotificationTaskBuilder withFrom(String from) {
        this.from = from;
        return this;
    }

    public NotificationTaskBuilder withSenderUsername(String username) {
        this.senderUsername = username;
        return this;
    }

    public NotificationTaskBuilder withSenderPassword(String password) {
        this.senderPassword = password;
        return this;
    }

    public NotificationTaskBuilder withMailPriority(MailPriority mailPriority) {
        this.mailPriority = mailPriority;
        return this;
    }

    public NotificationTaskBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public NotificationTaskBuilder withBody(String body) {
        this.body = body;
        return this;
    }

    @Override
    protected void setFields(NotificationTask task) {
        super.setFields(task);
        task.setAddresses(this.addresses);
        task.setSubject(this.subject);
        task.setBody(this.body);
        task.setCc(this.cc);
        task.setBcc(this.bcc);
        task.setReplyTo(this.replyTo);
        task.setFrom(this.from);
        task.setSenderUsername(this.senderUsername);
        task.setSenderPassword(this.senderPassword);
        task.setPriority(this.mailPriority);
    }

    @Override
    public NotificationTask build() {
        NotificationTask task = (NotificationTask)new NotificationTask().getType().getDescriptor().newInstance("dummy");
        this.setFields(task);
        return task;
    }
}

