package com.xebialabs.xlrelease.runner.repository

import com.xebialabs.xlrelease.runner.domain.RunnerId
import com.xebialabs.xlrelease.runner.repository.data.RunnerTokenRow

import java.util.Date

trait RunnerTokenRepository {

  def exists(runnerId: RunnerId): Boolean

  def findByToken(tokenHash: String): Option[RunnerTokenRow]

  def create(runnerId: RunnerId, tokenHash: String, expiryDate: Date): Unit

  def update(runnerId: RunnerId, tokenHash: String, expiryDate: Date): Unit

  def delete(runnerId: RunnerId): Unit
}
