package com.xebialabs.xlrelease.script.jython

import com.xebialabs.xlrelease.script.Jsr223EngineFactory
import grizzled.slf4j.Logging
import org.apache.commons.lang3.reflect.FieldUtils.readField
import org.python.core.PySystemState
import org.python.jsr223.{PyScriptEngine, PyScriptEngineFactory}
import org.python.util.PythonInterpreter

import javax.script.ScriptEngine

object JythonEngineInstance extends Jsr223EngineFactory with Logging {
  private val engineFactory: PyScriptEngineFactory = new PyScriptEngineFactory()

  {
    PySystemState.initialize()
    PySystemState.packageManager = SandboxAwarePackageManager.getInstance
  }

  private val restrictedEngine = createEngine(true)
  private val unrestrictedEngine = createEngine(false)

  def getScriptEngine(restricted: Boolean): ScriptEngine = {
    logger.debug(s"Jython engine [restricted: $restricted] instance started.")
    if (restricted) {
      restrictedEngine
    } else {
      unrestrictedEngine
    }
  }

  private def createEngine(restricted: Boolean): ScriptEngine = {
    try {
      SandboxAwarePackageManager.setSandboxed(restricted)
      if (restricted) {
        val engine = engineFactory.getScriptEngine.asInstanceOf[PyScriptEngine]
        val interpreter = readField(engine, "interp", true).asInstanceOf[PythonInterpreter]
        val parentLoader = Thread.currentThread().getContextClassLoader
        interpreter.getSystemState.setClassLoader(new JythonScriptClassLoader(parentLoader))
        engine
      } else {
        engineFactory.getScriptEngine
      }
    } finally {
      SandboxAwarePackageManager.setSandboxed(false)
    }
  }
}
